/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.RangeUtil;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class CipherFeedback
extends FeedbackCipher {
    private final byte[] k;
    private final byte[] register;
    private int numBytes;
    private byte[] registerSave = null;

    CipherFeedback(SymmetricCipher symmetricCipher, int n) {
        super(symmetricCipher);
        if (n > this.blockSize) {
            n = this.blockSize;
        }
        this.numBytes = n;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
    }

    @Override
    String getFeedback() {
        return "CFB";
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 == null || byArray2.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = byArray2;
        this.reset();
        this.embeddedCipher.init(false, string, byArray);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.registerSave == null) {
            this.registerSave = new byte[this.blockSize];
        }
        System.arraycopy(this.register, 0, this.registerSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.registerSave, 0, this.register, 0, this.blockSize);
    }

    @Override
    int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        RangeUtil.blockSizeCheck(n2, this.numBytes);
        RangeUtil.nullAndBoundsCheck(byArray, n, n2);
        RangeUtil.nullAndBoundsCheck(byArray2, n3, n2);
        int n4 = this.blockSize - this.numBytes;
        for (int i = n2 / this.numBytes; i > 0; --i) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            if (n4 != 0) {
                System.arraycopy(this.register, this.numBytes, this.register, 0, n4);
            }
            for (int j = 0; j < this.numBytes; ++j) {
                byte by = (byte)(this.k[j] ^ byArray[j + n]);
                byArray2[j + n3] = by;
                this.register[n4 + j] = by;
            }
            n += this.numBytes;
            n3 += this.numBytes;
        }
        return n2;
    }

    @Override
    int encryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n2 % this.numBytes;
        int n5 = this.encrypt(byArray, n, n2 - n4, byArray2, n3);
        n += n5;
        n3 += n5;
        if (n4 != 0) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            for (int i = 0; i < n4; ++i) {
                byArray2[i + n3] = (byte)(this.k[i] ^ byArray[i + n]);
            }
        }
        return n2;
    }

    @Override
    int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        RangeUtil.blockSizeCheck(n2, this.numBytes);
        RangeUtil.nullAndBoundsCheck(byArray, n, n2);
        RangeUtil.nullAndBoundsCheck(byArray2, n3, n2);
        int n4 = this.blockSize - this.numBytes;
        for (int i = n2 / this.numBytes; i > 0; --i) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            if (n4 != 0) {
                System.arraycopy(this.register, this.numBytes, this.register, 0, n4);
            }
            for (int j = 0; j < this.numBytes; ++j) {
                this.register[j + n4] = byArray[j + n];
                byArray2[j + n3] = (byte)(byArray[j + n] ^ this.k[j]);
            }
            n3 += this.numBytes;
            n += this.numBytes;
        }
        return n2;
    }

    @Override
    int decryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n2 % this.numBytes;
        int n5 = this.decrypt(byArray, n, n2 - n4, byArray2, n3);
        n += n5;
        n3 += n5;
        if (n4 != 0) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            for (int i = 0; i < n4; ++i) {
                byArray2[i + n3] = (byte)(byArray[i + n] ^ this.k[i]);
            }
        }
        return n2;
    }
}

