/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.List;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.internal.org.objectweb.asm.util.TraceClassVisitor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;

final class ASMToolkit {
    private static Type TYPE_STRING = Type.getType(String.class);
    private static Type Type_THREAD = Type.getType(Thread.class);
    private static Type TYPE_CLASS = Type.getType(Class.class);

    ASMToolkit() {
    }

    public static void invokeSpecial(MethodVisitor methodVisitor, String string, Method method) {
        methodVisitor.visitMethodInsn(183, string, method.getName(), method.getDescriptor(), false);
    }

    public static void invokeStatic(MethodVisitor methodVisitor, String string, Method method) {
        methodVisitor.visitMethodInsn(184, string, method.getName(), method.getDescriptor(), false);
    }

    public static void invokeVirtual(MethodVisitor methodVisitor, String string, Method method) {
        methodVisitor.visitMethodInsn(182, string, method.getName(), method.getDescriptor(), false);
    }

    public static Type toType(ValueDescriptor valueDescriptor) {
        String string;
        switch (string = valueDescriptor.getTypeName()) {
            case "byte": {
                return Type.BYTE_TYPE;
            }
            case "short": {
                return Type.SHORT_TYPE;
            }
            case "int": {
                return Type.INT_TYPE;
            }
            case "long": {
                return Type.LONG_TYPE;
            }
            case "double": {
                return Type.DOUBLE_TYPE;
            }
            case "float": {
                return Type.FLOAT_TYPE;
            }
            case "char": {
                return Type.CHAR_TYPE;
            }
            case "boolean": {
                return Type.BOOLEAN_TYPE;
            }
            case "java.lang.String": {
                return TYPE_STRING;
            }
            case "java.lang.Thread": {
                return Type_THREAD;
            }
            case "java.lang.Class": {
                return TYPE_CLASS;
            }
        }
        throw new Error("Not a valid type " + valueDescriptor.getTypeName());
    }

    public static String getDescriptor(String string) {
        if ("int".equals(string)) {
            return "I";
        }
        if ("long".equals(string)) {
            return "J";
        }
        if ("boolean".equals(string)) {
            return "Z";
        }
        if ("float".equals(string)) {
            return "F";
        }
        if ("double".equals(string)) {
            return "D";
        }
        if ("short".equals(string)) {
            return "S";
        }
        if ("char".equals(string)) {
            return "C";
        }
        if ("byte".equals(string)) {
            return "B";
        }
        String string2 = ASMToolkit.getInternalName(string);
        return Type.getObjectType(string2).getDescriptor();
    }

    public static String getInternalName(String string) {
        return string.replace(".", "/");
    }

    public static Method makeWriteMethod(List<EventInstrumentation.FieldInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (EventInstrumentation.FieldInfo fieldInfo : list) {
            if (fieldInfo.fieldName.equals("eventThread") || fieldInfo.fieldName.equals("stackTrace")) continue;
            stringBuilder.append(fieldInfo.fieldDescriptor);
        }
        stringBuilder.append(")V");
        return new Method("write", stringBuilder.toString());
    }

    public static void logASM(String string, byte[] byArray) {
        Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.INFO, "Generated bytecode for class " + string);
        Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.TRACE, () -> {
            ClassReader classReader = new ClassReader(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            printWriter.println("Bytecode:");
            classReader.accept(new TraceClassVisitor(printWriter), 0);
            return byteArrayOutputStream.toString();
        });
    }
}

