/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.util.Map;
import jdk.internal.platform.CgroupInfo;
import jdk.internal.platform.CgroupSubsystem;
import jdk.internal.platform.CgroupSubsystemController;
import jdk.internal.platform.CgroupV1Metrics;
import jdk.internal.platform.cgroupv1.CgroupV1MemorySubSystemController;
import jdk.internal.platform.cgroupv1.CgroupV1SubsystemController;

public class CgroupV1Subsystem
implements CgroupSubsystem,
CgroupV1Metrics {
    private CgroupV1MemorySubSystemController memory;
    private CgroupV1SubsystemController cpu;
    private CgroupV1SubsystemController cpuacct;
    private CgroupV1SubsystemController cpuset;
    private CgroupV1SubsystemController blkio;
    private static volatile CgroupV1Subsystem INSTANCE;
    private static final String PROVIDER_NAME = "cgroupv1";

    private CgroupV1Subsystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CgroupV1Subsystem getInstance(Map<String, CgroupInfo> map) {
        if (INSTANCE != null) return INSTANCE;
        CgroupV1Subsystem cgroupV1Subsystem = CgroupV1Subsystem.initSubSystem(map);
        Class<CgroupV1Subsystem> clazz = CgroupV1Subsystem.class;
        synchronized (CgroupV1Subsystem.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = cgroupV1Subsystem;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static CgroupV1Subsystem initSubSystem(Map<String, CgroupInfo> map) {
        CgroupV1Subsystem cgroupV1Subsystem = new CgroupV1Subsystem();
        boolean bl = false;
        block14: for (CgroupInfo cgroupInfo : map.values()) {
            switch (cgroupInfo.getName()) {
                case "memory": {
                    if (cgroupInfo.getMountRoot() == null || cgroupInfo.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController cgroupV1SubsystemController = new CgroupV1MemorySubSystemController(cgroupInfo.getMountRoot(), cgroupInfo.getMountPoint());
                    cgroupV1SubsystemController.setPath(cgroupInfo.getCgroupPath());
                    boolean bl2 = CgroupV1Subsystem.getHierarchical((CgroupV1MemorySubSystemController)cgroupV1SubsystemController);
                    ((CgroupV1MemorySubSystemController)cgroupV1SubsystemController).setHierarchical(bl2);
                    boolean bl3 = CgroupV1Subsystem.getSwapEnabled((CgroupV1MemorySubSystemController)cgroupV1SubsystemController);
                    ((CgroupV1MemorySubSystemController)cgroupV1SubsystemController).setSwapEnabled(bl3);
                    cgroupV1Subsystem.setMemorySubSystem((CgroupV1MemorySubSystemController)cgroupV1SubsystemController);
                    bl = true;
                    continue block14;
                }
                case "cpuset": {
                    if (cgroupInfo.getMountRoot() == null || cgroupInfo.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController cgroupV1SubsystemController = new CgroupV1SubsystemController(cgroupInfo.getMountRoot(), cgroupInfo.getMountPoint());
                    cgroupV1SubsystemController.setPath(cgroupInfo.getCgroupPath());
                    cgroupV1Subsystem.setCpuSetController(cgroupV1SubsystemController);
                    bl = true;
                    continue block14;
                }
                case "cpuacct": {
                    if (cgroupInfo.getMountRoot() == null || cgroupInfo.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController cgroupV1SubsystemController = new CgroupV1SubsystemController(cgroupInfo.getMountRoot(), cgroupInfo.getMountPoint());
                    cgroupV1SubsystemController.setPath(cgroupInfo.getCgroupPath());
                    cgroupV1Subsystem.setCpuAcctController(cgroupV1SubsystemController);
                    bl = true;
                    continue block14;
                }
                case "cpu": {
                    if (cgroupInfo.getMountRoot() == null || cgroupInfo.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController cgroupV1SubsystemController = new CgroupV1SubsystemController(cgroupInfo.getMountRoot(), cgroupInfo.getMountPoint());
                    cgroupV1SubsystemController.setPath(cgroupInfo.getCgroupPath());
                    cgroupV1Subsystem.setCpuController(cgroupV1SubsystemController);
                    bl = true;
                    continue block14;
                }
                case "blkio": {
                    if (cgroupInfo.getMountRoot() == null || cgroupInfo.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController cgroupV1SubsystemController = new CgroupV1SubsystemController(cgroupInfo.getMountRoot(), cgroupInfo.getMountPoint());
                    cgroupV1SubsystemController.setPath(cgroupInfo.getCgroupPath());
                    cgroupV1Subsystem.setBlkIOController(cgroupV1SubsystemController);
                    bl = true;
                    continue block14;
                }
            }
            throw new AssertionError((Object)("Unrecognized controller in infos: " + cgroupInfo.getName()));
        }
        if (bl) {
            return cgroupV1Subsystem;
        }
        return null;
    }

    private static boolean getSwapEnabled(CgroupV1MemorySubSystemController cgroupV1MemorySubSystemController) {
        long l = CgroupV1Subsystem.getLongValue(cgroupV1MemorySubSystemController, "memory.memsw.limit_in_bytes");
        return l > 0L;
    }

    private static boolean getHierarchical(CgroupV1MemorySubSystemController cgroupV1MemorySubSystemController) {
        long l = CgroupV1Subsystem.getLongValue(cgroupV1MemorySubSystemController, "memory.use_hierarchy");
        return l > 0L;
    }

    private void setMemorySubSystem(CgroupV1MemorySubSystemController cgroupV1MemorySubSystemController) {
        this.memory = cgroupV1MemorySubSystemController;
    }

    private void setCpuController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.cpu = cgroupV1SubsystemController;
    }

    private void setCpuAcctController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.cpuacct = cgroupV1SubsystemController;
    }

    private void setCpuSetController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.cpuset = cgroupV1SubsystemController;
    }

    private void setBlkIOController(CgroupV1SubsystemController cgroupV1SubsystemController) {
        this.blkio = cgroupV1SubsystemController;
    }

    private static long getLongValue(CgroupSubsystemController cgroupSubsystemController, String string) {
        return CgroupSubsystemController.getLongValue(cgroupSubsystemController, string, CgroupV1SubsystemController::convertStringToLong, -1L);
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpuacct.usage");
    }

    @Override
    public long[] getPerCpuUsage() {
        String string = CgroupSubsystemController.getStringValue(this.cpuacct, "cpuacct.usage_percpu");
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(" ");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i]);
        }
        return lArray;
    }

    @Override
    public long getCpuUserUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "user");
    }

    @Override
    public long getCpuSystemUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "system");
    }

    @Override
    public long getCpuPeriod() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpu.cfs_period_us");
    }

    @Override
    public long getCpuQuota() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpu.cfs_quota_us");
    }

    @Override
    public long getCpuShares() {
        long l = CgroupV1Subsystem.getLongValue(this.cpuacct, "cpu.shares");
        if (l == 0L || l == 1024L) {
            return -1L;
        }
        return l;
    }

    @Override
    public long getCpuNumPeriods() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "throttled_time");
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.cpus"));
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_cpus"));
    }

    @Override
    public int[] getCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.mems"));
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_mems"));
    }

    @Override
    public double getCpuSetMemoryPressure() {
        return CgroupV1SubsystemController.getDoubleValue(this.cpuset, "cpuset.memory_pressure");
    }

    @Override
    public Boolean isCpuSetMemoryPressureEnabled() {
        long l = CgroupV1Subsystem.getLongValue(this.cpuset, "cpuset.memory_pressure_enabled");
        return l == 1L;
    }

    @Override
    public long getMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.failcnt");
    }

    @Override
    public long getMemoryLimit() {
        long l = CgroupV1Subsystem.getLongValue(this.memory, "memory.limit_in_bytes");
        if (l > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String string = "hierarchical_memory_limit";
            l = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", string);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(l);
    }

    @Override
    public long getMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.max_usage_in_bytes");
    }

    @Override
    public long getMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.usage_in_bytes");
    }

    @Override
    public long getKernelMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.failcnt");
    }

    @Override
    public long getKernelMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.limit_in_bytes"));
    }

    @Override
    public long getKernelMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.max_usage_in_bytes");
    }

    @Override
    public long getKernelMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.usage_in_bytes");
    }

    @Override
    public long getTcpMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.failcnt");
    }

    @Override
    public long getTcpMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.limit_in_bytes"));
    }

    @Override
    public long getTcpMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.max_usage_in_bytes");
    }

    @Override
    public long getTcpMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapFailCount() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryFailCount();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.failcnt");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryLimit();
        }
        long l = CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.limit_in_bytes");
        if (l > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String string = "hierarchical_memsw_limit";
            l = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", string);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(l);
    }

    @Override
    public long getMemoryAndSwapMaxUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryMaxUsage();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.max_usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryUsage();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.usage_in_bytes");
    }

    @Override
    public Boolean isMemoryOOMKillEnabled() {
        long l = CgroupV1SubsystemController.getLongEntry(this.memory, "memory.oom_control", "oom_kill_disable");
        return l == 0L;
    }

    @Override
    public long getMemorySoftLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.soft_limit_in_bytes"));
    }

    @Override
    public long getBlkIOServiceCount() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_service_bytes", "Total");
    }

    @Override
    public long getBlkIOServiced() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_serviced", "Total");
    }
}

