/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.framework.protobuf;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProgressReport;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.framework.IFrameworkSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;

public class ProtobufSupport
implements IFrameworkSupport {
    public static final String PROTOBUF_GENERATED_SOURCE = "protobuf_generated_source";

    @Override
    public void onDidProjectsImported(IProgressMonitor monitor) {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null) {
            return;
        }
        if (!preferencesManager.getPreferences().isProtobufSupportEnabled()) {
            return;
        }
        List<IProject> projects = ProjectUtils.getGradleProjects();
        if (projects.isEmpty()) {
            return;
        }
        ArrayList<String> projectNames = new ArrayList<String>();
        for (IProject project : projects) {
            boolean hasGenerated;
            Set<File> protobufOutputDirs;
            if (!ProjectUtils.isJavaProject(project) || (protobufOutputDirs = this.findProtobufOutputDirectories(project)).isEmpty() || (hasGenerated = this.containsJavaFiles(protobufOutputDirs))) continue;
            projectNames.add(project.getName());
        }
        if (!projectNames.isEmpty()) {
            ActionableNotification notification = new ActionableNotification().withSeverity(MessageType.Info).withMessage("Would you like to generate Java source files out of your proto files?").withCommands(Arrays.asList(new Command("Generate", "java.protobuf.generateSources", Arrays.asList(projectNames))));
            JavaLanguageServerPlugin.getProjectsManager().getConnection().sendActionableNotification(notification);
        }
    }

    private Set<File> findProtobufOutputDirectories(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        HashSet<File> protobufOutputDirs = new HashSet<File>();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
                    int n3 = iClasspathAttributeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathAttribute attribute = iClasspathAttributeArray[n4];
                        if (Objects.equals(attribute.getName(), PROTOBUF_GENERATED_SOURCE) && Objects.equals(attribute.getValue(), "true")) {
                            protobufOutputDirs.add(new File(project.getLocation().toFile(), entry.getPath().removeFirstSegments(1).toString()));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
        }
        return protobufOutputDirs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsJavaFiles(Set<File> generatedDirectories) {
        for (File dir : generatedDirectories) {
            if (!dir.exists()) {
                return false;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Stream<Path> walkStream = Files.walk(dir.toPath(), new FileVisitOption[0]);){
                    boolean containsJavaFile = walkStream.filter(p -> p.toFile().isFile()).anyMatch(f -> f.toString().endsWith(".java"));
                    if (!containsJavaFile) continue;
                    return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        return false;
    }

    public static void generateProtobufSources(List<String> projectNames, IProgressMonitor monitor) {
        if (projectNames == null || projectNames.isEmpty()) {
            return;
        }
        JavaClientConnection.JavaLanguageClient client = JavaLanguageServerPlugin.getProjectsManager().getConnection();
        ProgressReport progressReport = new ProgressReport(UUID.randomUUID().toString());
        progressReport.setTask("Running Gradle tasks");
        progressReport.setComplete(false);
        progressReport.setTotalWork(projectNames.size());
        progressReport.setStatus("Generating Java sources from proto files...");
        client.sendProgressReport(progressReport);
        try {
            for (String projectName : projectNames) {
                if (!StringUtils.isEmpty((CharSequence)projectName)) {
                    ProtobufSupport.runGenerateProtobufTasks(projectName, monitor);
                }
                progressReport.setWorkDone(progressReport.getWorkDone() + 1);
            }
        }
        finally {
            progressReport.setComplete(true);
            client.sendProgressReport(progressReport);
        }
    }

    private static void runGenerateProtobufTasks(String projectName, IProgressMonitor monitor) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            return;
        }
        Optional build = GradleCore.getWorkspace().getBuild(project);
        if (build.isEmpty()) {
            return;
        }
        try {
            ((GradleBuild)build.get()).withConnection(connection -> {
                connection.newBuild().forTasks(new String[]{"generateProto", "generateTestProto"}).run();
                return null;
            }, monitor);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e);
        }
    }
}

