/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;

public final class ReferencesHandler {
    private final PreferenceManager preferenceManager;

    public ReferencesHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    private IJavaSearchScope createSearchScope(IJavaElement elementToSearch) throws JavaModelException {
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        int includeMask = 11;
        if (this.isInsideJRE(elementToSearch)) {
            includeMask |= 4;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)includeMask);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Location> findReferences(ReferenceParams param, IProgressMonitor monitor) {
        ITypeRoot typeRoot;
        ArrayList<Location> locations;
        block23: {
            locations = new ArrayList<Location>();
            typeRoot = null;
            try {
                boolean returnCompilationUnit = this.preferenceManager == null ? false : this.preferenceManager.isClientSupportsClassFileContent() && this.preferenceManager.getPreferences().isIncludeDecompiledSources();
                typeRoot = JDTUtils.resolveTypeRoot(param.getTextDocument().getUri(), returnCompilationUnit, monitor);
                if (typeRoot == null) {
                    ArrayList<Location> arrayList = locations;
                    JDTUtils.discardClassFileWorkingCopy(typeRoot);
                    return arrayList;
                }
                IJavaElement elementToSearch = JDTUtils.findElementAtSelection(typeRoot, param.getPosition().getLine(), param.getPosition().getCharacter(), this.preferenceManager, monitor);
                if (elementToSearch == null) {
                    int offset = JsonRpcHelpers.toOffset(typeRoot.getBuffer(), param.getPosition().getLine(), param.getPosition().getCharacter());
                    elementToSearch = typeRoot.getElementAt(offset);
                }
                if (elementToSearch == null) {
                    ArrayList<Location> arrayList = locations;
                    JDTUtils.discardClassFileWorkingCopy(typeRoot);
                    return arrayList;
                }
                this.search(elementToSearch, locations, monitor, param.getContext().isIncludeDeclaration());
                if (monitor.isCanceled()) {
                    List<Location> list = Collections.emptyList();
                    JDTUtils.discardClassFileWorkingCopy(typeRoot);
                    return list;
                }
                if (!this.preferenceManager.getPreferences().isIncludeAccessors() || !(elementToSearch instanceof IField)) break block23;
                IField field = (IField)elementToSearch;
                IMethod getter = GetterSetterUtil.getGetter((IField)field);
                if (getter != null) {
                    this.search((IJavaElement)getter, locations, monitor, false);
                }
                if (monitor.isCanceled()) {
                    List<Location> list = Collections.emptyList();
                    JDTUtils.discardClassFileWorkingCopy(typeRoot);
                    return list;
                }
                IMethod setter = GetterSetterUtil.getSetter((IField)field);
                if (setter != null) {
                    this.search((IJavaElement)setter, locations, monitor, false);
                }
                if (monitor.isCanceled()) {
                    List<Location> list = Collections.emptyList();
                    JDTUtils.discardClassFileWorkingCopy(typeRoot);
                    return list;
                }
                String builderName = this.getBuilderName(field);
                IType builder = field.getJavaProject().findType(builderName);
                if (monitor.isCanceled()) {
                    List<Location> list = Collections.emptyList();
                    JDTUtils.discardClassFileWorkingCopy(typeRoot);
                    return list;
                }
                if (builder != null) {
                    String fieldSignature = field.getTypeSignature();
                    IMethod[] iMethodArray = builder.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        String[] parameters = method.getParameterTypes();
                        if (parameters.length == 1 && field.getElementName().equals(method.getElementName()) && fieldSignature.equals(parameters[0])) {
                            this.search((IJavaElement)method, locations, monitor, false);
                        }
                        ++n2;
                    }
                }
                if (!monitor.isCanceled()) break block23;
                List<Location> list = Collections.emptyList();
                JDTUtils.discardClassFileWorkingCopy(typeRoot);
                return list;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Find references failure ", e);
                return locations;
            }
            finally {
                JDTUtils.discardClassFileWorkingCopy(typeRoot);
            }
        }
        JDTUtils.discardClassFileWorkingCopy(typeRoot);
        return locations;
    }

    private String getBuilderName(IField field) {
        IType declaringType = field.getDeclaringType();
        IAnnotation annotation = declaringType.getAnnotation("Builder");
        if (annotation == null || !annotation.exists()) {
            annotation = declaringType.getAnnotation("lombok.Builder");
        }
        if (annotation != null && annotation.exists()) {
            try {
                IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                int n = iMemberValuePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemberValuePair pair = iMemberValuePairArray[n2];
                    if (pair.getValueKind() == 9) {
                        String stringValue;
                        String memberName = pair.getMemberName();
                        Object value = pair.getValue();
                        if ("builderClassName".equals(memberName) && value instanceof String && !(stringValue = (String)value).isEmpty()) {
                            return declaringType.getFullyQualifiedName() + "." + stringValue;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return declaringType.getFullyQualifiedName() + "." + declaringType.getElementName() + "Builder";
    }

    private boolean isInsideJRE(IJavaElement element) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
        if (root != null) {
            try {
                IClasspathEntry entry = root.getRawClasspathEntry();
                if (entry.getEntryKind() == 5) {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)root.getJavaProject());
                    return container != null && container.getKind() == 3;
                }
                return false;
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        return true;
    }

    public void search(IJavaElement elementToSearch, final List<Location> locations, final IProgressMonitor monitor, boolean isIncludeDeclaration) throws CoreException, JavaModelException {
        final boolean includeClassFiles = this.preferenceManager.isClientSupportsClassFileContent();
        final boolean includeDecompiledSources = this.preferenceManager.getPreferences().isIncludeDecompiledSources();
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)elementToSearch, (int)2);
        if (isIncludeDeclaration) {
            SearchPattern patternDecl = SearchPattern.createPattern((IJavaElement)elementToSearch, (int)0);
            pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)patternDecl);
        }
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(elementToSearch), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getAccuracy() == 1) {
                    return;
                }
                Object o = match.getElement();
                if (o instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)o;
                    ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                    if (compilationUnit != null) {
                        Location location = JDTUtils.toLocation(compilationUnit, match.getOffset(), match.getLength());
                        locations.add(location);
                    } else if (includeClassFiles) {
                        IClassFile cf = (IClassFile)element.getAncestor(6);
                        if (cf != null && cf.getSourceRange() != null) {
                            Location location = JDTUtils.toLocation(cf, match.getOffset(), match.getLength());
                            locations.add(location);
                        } else if (includeDecompiledSources && cf != null) {
                            List<Location> result = JDTUtils.searchDecompiledSources(element, cf, false, false, monitor);
                            locations.addAll(result);
                        }
                    }
                }
            }
        }, monitor);
    }
}

