/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.jdt.core.dom.AST;

public class ASTHelper {
    public static final int JLS2 = 2;
    public static final int JLS3 = 3;
    public static final int JLS4 = 4;
    public static final int JLS8 = 8;
    public static final int JLS9 = 9;
    public static final int JLS10 = 10;
    public static final int JLS11 = 11;
    public static final int JLS12 = 12;
    public static final int JLS13 = 13;
    public static final int JLS14 = 14;
    public static final int JLS15 = 15;
    public static final int JLS16 = 16;
    public static final int JLS17 = 17;
    public static final int JLS18 = 18;
    public static final int JLS19 = 19;
    public static final int JLS20 = 20;
    public static final int JLS21 = 21;
    public static final int JLS22 = 22;

    private static boolean isNodeTypeSupportedInAST(AST ast, int nodeType) {
        switch (nodeType) {
            case 49: 
            case 100: 
            case 101: {
                return ast.apiLevel() >= 14;
            }
            case 102: {
                return ast.apiLevel() >= 15;
            }
            case 62: 
            case 103: {
                return ast.apiLevel() >= 16;
            }
            case 110: {
                return ast.apiLevel() >= 18;
            }
            case 104: 
            case 106: 
            case 113: {
                return ast.apiLevel() >= 21;
            }
        }
        return true;
    }

    private static boolean isModifierSupportedInAST(AST ast, int modifier) {
        switch (modifier) {
            case 512: 
            case 4096: {
                return ast.apiLevel() >= 17;
            }
        }
        return true;
    }

    public static boolean isYieldNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 101);
    }

    public static boolean isSwitchExpressionNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 100);
    }

    public static boolean isTextBlockNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 102);
    }

    public static boolean isSwitchCaseExpressionsSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 49);
    }

    public static boolean isRecordDeclarationNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 103);
    }

    public static boolean isSealedTypeSupportedInAST(AST ast) {
        return ASTHelper.isModifierSupportedInAST(ast, 512);
    }

    public static boolean isInstanceofExpressionPatternSupported(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 62);
    }

    public static boolean isPatternSupported(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 106);
    }

    public static boolean isRecordPatternSupported(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 113);
    }

    public static boolean isJavaDocCodeSnippetSupported(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 110);
    }
}

