/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.OutputStreamMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVM;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.ILibraryLocationResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.osgi.util.NLS;

public class StandardVMType
extends AbstractVMInstallType {
    private static final String RT_JAR = "rt.jar";
    private static final String SRC = "src";
    private static final String SRC_ZIP = "src.zip";
    private static final String SRC_JAR = "src.jar";
    private static final String JRE = "jre";
    private static final String LIB = "lib";
    private static final String BAR = "|";
    private static final String RELEASE_FILE = "release";
    private static final String JAVA_VERSION = "JAVA_VERSION";
    private static final String JRT_FS_JAR = "jrt-fs.jar";
    public static final String ID_STANDARD_VM_TYPE = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    public static final String MIN_VM_SIZE = "-Xmx16m";
    private static FilenameFilter fgArchiveFilter = (arg0, arg1) -> arg1.endsWith(".zip") || arg1.endsWith(".jar");
    private String fDefaultRootPath = "";
    private static Map<String, LibraryInfo> fgFailedInstallPath = new HashMap<String, LibraryInfo>();
    private static Map<String, List<LibraryLocation>> fgDefaultLibLocs = new HashMap<String, List<LibraryLocation>>();
    private static final List<Path> CANDIDATE_JAVA_FILES = Stream.of("javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe").map(string -> Path.of(string, new String[0])).toList();
    private static final Path[] CANDIDATE_JAVA_LOCATIONS = new Path[]{Path.of("", new String[0]), Path.of("bin", new String[0]), Path.of("jre", "bin")};
    private static final Path BIN = Path.of("bin", new String[0]);
    private static ILibraryLocationResolver[] fgLibraryLocationResolvers = null;

    public static File findJavaExecutable(File vmInstallLocation) {
        Path filePath = vmInstallLocation.toPath();
        boolean isBin = filePath.endsWith(BIN);
        for (Path exeName : CANDIDATE_JAVA_FILES) {
            int j = 0;
            while (j < CANDIDATE_JAVA_LOCATIONS.length) {
                Path javaFile;
                if ((isBin || j != 0) && Files.isRegularFile(javaFile = filePath.resolve(CANDIDATE_JAVA_LOCATIONS[j]).resolve(exeName), new LinkOption[0])) {
                    return javaFile.toFile();
                }
                ++j;
            }
        }
        return null;
    }

    private static ILibraryLocationResolver[] getLibraryLocationResolvers() {
        if (fgLibraryLocationResolvers == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.launching", "libraryLocationResolvers");
            IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
            Arrays.sort(configs, Comparator.comparing(IConfigurationElement::getNamespaceIdentifier));
            ArrayList<ILibraryLocationResolver> resolvers = new ArrayList<ILibraryLocationResolver>(configs.length);
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    resolvers.add((ILibraryLocationResolver)e.createExecutableExtension("class"));
                }
                catch (CoreException e1) {
                    LaunchingPlugin.log(e1.getStatus());
                }
                ++n2;
            }
            fgLibraryLocationResolvers = resolvers.toArray(new ILibraryLocationResolver[0]);
        }
        return fgLibraryLocationResolvers;
    }

    @Override
    public String getName() {
        return LaunchingMessages.StandardVMType_Standard_VM_3;
    }

    @Override
    protected IVMInstall doCreateVMInstall(String id) {
        return new StandardVM(this, id);
    }

    protected synchronized LibraryInfo getLibraryInfo(File javaHome, File javaExecutable) {
        String installPath = javaHome.getAbsolutePath();
        LibraryInfo info = LaunchingPlugin.getLibraryInfo(installPath);
        if ((info == null || LaunchingPlugin.timeStampChanged(installPath)) && (info = fgFailedInstallPath.get(installPath)) == null) {
            String version = this.readReleaseVersion(javaHome);
            if (JavaCore.compareJavaVersions((String)version, (String)"1.8") > 0) {
                info = new LibraryInfo(version, new String[0], new String[0], new String[0]);
                LaunchingPlugin.setLibraryInfo(installPath, info);
            } else {
                info = this.generateLibraryInfo(javaHome, javaExecutable);
                if (info == null) {
                    info = this.generateLibraryInfo(javaHome, javaExecutable);
                }
                if (info == null) {
                    info = this.getDefaultLibraryInfo(javaHome);
                    fgFailedInstallPath.put(installPath, info);
                } else {
                    LaunchingPlugin.setLibraryInfo(installPath, info);
                }
            }
        }
        return info;
    }

    protected boolean canDetectDefaultSystemLibraries(File javaHome, File javaExecutable) {
        LibraryLocation[] locations = this.getDefaultLibraryLocations(javaHome);
        String version = this.getVMVersion(javaHome, javaExecutable);
        return locations.length > 0 && !version.startsWith("1.1");
    }

    protected String getVMVersion(File javaHome, File javaExecutable) {
        LibraryInfo info = this.getLibraryInfo(javaHome, javaExecutable);
        return info.getVersion();
    }

    @Override
    public File detectInstallLocation() {
        if ("macosx".equals(Platform.getOS())) {
            return null;
        }
        return this.getJavaHomeLocation();
    }

    protected File getJavaHomeLocation() {
        File parent;
        File javaHome;
        try {
            javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
            return null;
        }
        if (!javaHome.exists()) {
            return null;
        }
        File javaExecutable = StandardVMType.findJavaExecutable(javaHome);
        if (javaExecutable == null) {
            return null;
        }
        boolean foundLibraries = false;
        if (javaHome.getName().equalsIgnoreCase(JRE) && this.canDetectDefaultSystemLibraries(parent = new File(javaHome.getParent()), javaExecutable)) {
            javaHome = parent;
            foundLibraries = true;
        }
        if (!foundLibraries && !this.canDetectDefaultSystemLibraries(javaHome, javaExecutable)) {
            return null;
        }
        return javaHome;
    }

    protected IPath getDefaultSystemLibrary(File javaHome) {
        IPath home = IPath.fromFile((File)javaHome);
        IPath jreLibPath = home.append(LIB).append(RT_JAR);
        if (jreLibPath.toFile().isFile()) {
            return jreLibPath;
        }
        return home.append(JRE).append(LIB).append(RT_JAR);
    }

    protected IPath getDefaultSystemLibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        while (parent != null) {
            File parentsrc = new File(parent, SRC_JAR);
            if (parentsrc.isFile()) {
                this.setDefaultRootPath(SRC);
                return IPath.fromFile((File)parentsrc);
            }
            parentsrc = new File(parent, SRC_ZIP);
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("");
                return IPath.fromFile((File)parentsrc);
            }
            parent = parent.getParentFile();
        }
        IPath result = this.checkForJ9LibrarySource(libLocation);
        if (result != null) {
            return result;
        }
        IPath libName = IPath.fromOSString((String)libLocation.getName());
        String extension = libName.getFileExtension();
        String prefix = libName.removeFileExtension().lastSegment();
        if (extension != null) {
            IPath srcPath = IPath.fromFile((File)libLocation);
            srcPath = srcPath.removeLastSegments(1);
            StringBuilder buf = new StringBuilder();
            buf.append(prefix);
            buf.append("-src.");
            buf.append(extension);
            srcPath = srcPath.append(buf.toString());
            if (srcPath.toFile().exists()) {
                return srcPath;
            }
        }
        this.setDefaultRootPath("");
        return IPath.EMPTY;
    }

    private IPath checkForJ9LibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        String name = libLocation.getName();
        if (name.equalsIgnoreCase("classes.zip")) {
            File source = new File(parent, "source/source.zip");
            return source.isFile() ? IPath.fromFile((File)source) : IPath.EMPTY;
        }
        if (name.equalsIgnoreCase("locale.zip")) {
            File source = new File(parent, "source/locale-src.zip");
            return source.isFile() ? IPath.fromFile((File)source) : IPath.EMPTY;
        }
        if (name.equalsIgnoreCase("charconv.zip")) {
            File source = new File(parent, "charconv-src.zip");
            return source.isFile() ? IPath.fromFile((File)source) : IPath.EMPTY;
        }
        return null;
    }

    protected IPath getDefaultPackageRootPath() {
        return IPath.fromOSString((String)this.getDefaultRootPath());
    }

    @Override
    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        List<LibraryLocation> allLibs = fgDefaultLibLocs.get(installLocation.getAbsolutePath());
        if (allLibs == null) {
            File javaExecutable = StandardVMType.findJavaExecutable(installLocation);
            LibraryInfo libInfo = javaExecutable == null ? this.getDefaultLibraryInfo(installLocation) : this.getLibraryInfo(installLocation, javaExecutable);
            allLibs = new ArrayList<LibraryLocation>(StandardVMType.gatherAllLibraries(libInfo.getEndorsedDirs()));
            URL url = this.getDefaultJavadocLocation(installLocation);
            if (libInfo.getBootpath().length == 0) {
                IPath sourceRootPath = IPath.EMPTY;
                IPath path = IPath.fromFile((File)installLocation.getAbsoluteFile()).append(LIB).append(SRC_ZIP);
                File lib = path.toFile();
                if (lib.exists() && lib.isFile()) {
                    sourceRootPath = this.getDefaultSystemLibrarySource(lib);
                } else {
                    path = IPath.fromFile((File)installLocation.getAbsoluteFile()).append(SRC_ZIP);
                    lib = path.toFile();
                    if (lib.exists() && lib.isFile()) {
                        sourceRootPath = this.getDefaultSystemLibrarySource(lib);
                    }
                }
                IPath pathName = IPath.fromFile((File)installLocation.getAbsoluteFile()).append(LIB).append(JRT_FS_JAR);
                File jrtfsJar = pathName.toFile();
                boolean exists = jrtfsJar.exists();
                if (!exists) {
                    pathName = IPath.fromFile((File)installLocation.getAbsoluteFile()).append(JRT_FS_JAR);
                    exists = pathName.toFile().exists();
                }
                if (exists) {
                    LibraryLocation libraryLocation = new LibraryLocation(pathName, sourceRootPath, this.getDefaultPackageRootPath(), this.getDefaultJavadocLocation(installLocation));
                    allLibs.add(libraryLocation);
                }
            }
            String[] bootpath = libInfo.getBootpath();
            ArrayList<LibraryLocation> boot = new ArrayList<LibraryLocation>(bootpath.length);
            String[] exists = bootpath;
            int jrtfsJar = bootpath.length;
            int pathName = 0;
            while (pathName < jrtfsJar) {
                String element = exists[pathName];
                IPath path = IPath.fromOSString((String)element);
                File lib = path.toFile();
                if (lib.exists() && lib.isFile()) {
                    LibraryLocation libraryLocation = new LibraryLocation(path, this.getDefaultSystemLibrarySource(lib), this.getDefaultPackageRootPath(), url);
                    boot.add(libraryLocation);
                }
                ++pathName;
            }
            allLibs.addAll(boot);
            allLibs.addAll(StandardVMType.gatherAllLibraries(libInfo.getExtensionDirs()));
            HashSet<String> set = new HashSet<String>();
            LibraryLocation lib = null;
            ListIterator<LibraryLocation> liter = allLibs.listIterator();
            while (liter.hasNext()) {
                lib = liter.next();
                IPath systemLibraryPath = lib.getSystemLibraryPath();
                String device = systemLibraryPath.getDevice();
                if (device != null) {
                    systemLibraryPath = systemLibraryPath.setDevice(device.toUpperCase());
                }
                if (set.add(systemLibraryPath.toOSString())) continue;
                liter.remove();
            }
            fgDefaultLibLocs.put(installLocation.getAbsolutePath(), allLibs);
        }
        return allLibs.toArray(new LibraryLocation[allLibs.size()]);
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        IPath rtjar = this.getDefaultSystemLibrary(installLocation);
        File extDir = this.getDefaultExtensionDirectory(installLocation);
        File endDir = this.getDefaultEndorsedDirectory(installLocation);
        String[] dirs = null;
        dirs = extDir == null ? new String[]{} : new String[]{extDir.getAbsolutePath()};
        String[] endDirs = null;
        endDirs = endDir == null ? new String[]{} : new String[]{endDir.getAbsolutePath()};
        return new LibraryInfo("???", new String[]{rtjar.toOSString()}, dirs, endDirs);
    }

    public static List<LibraryLocation> gatherAllLibraries(String[] dirPaths) {
        ArrayList<LibraryLocation> libraries = new ArrayList<LibraryLocation>();
        String[] stringArray = dirPaths;
        int n = dirPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String[] names;
            String dirPath = stringArray[n2];
            File extDir = new File(dirPath);
            if (extDir.isDirectory() && (names = extDir.list(fgArchiveFilter)) != null) {
                String[] stringArray2 = names;
                int n3 = names.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray2[n4];
                    File jar = new File(extDir, name);
                    if (jar.isFile()) {
                        try {
                            IPath libPath = IPath.fromFile((File)jar.getCanonicalFile());
                            IPath sourcePath = IPath.EMPTY;
                            IPath packageRoot = IPath.EMPTY;
                            URL javadocLocation = null;
                            URL indexLocation = null;
                            ILibraryLocationResolver[] iLibraryLocationResolverArray = StandardVMType.getLibraryLocationResolvers();
                            int n5 = iLibraryLocationResolverArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ILibraryLocationResolver resolver = iLibraryLocationResolverArray[n6];
                                try {
                                    sourcePath = resolver.getSourcePath(libPath);
                                    packageRoot = resolver.getPackageRoot(libPath);
                                    javadocLocation = resolver.getJavadocLocation(libPath);
                                    indexLocation = resolver.getIndexLocation(libPath);
                                    if (sourcePath != IPath.EMPTY || packageRoot != IPath.EMPTY || javadocLocation != null || indexLocation != null) {
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    LaunchingPlugin.log(e);
                                }
                                ++n6;
                            }
                            LibraryLocation library = new LibraryLocation(libPath, sourcePath, packageRoot, javadocLocation, indexLocation);
                            libraries.add(library);
                        }
                        catch (IOException e) {
                            LaunchingPlugin.log(e);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return libraries;
    }

    protected File getDefaultExtensionDirectory(File installLocation) {
        File jre = null;
        jre = installLocation.getName().equalsIgnoreCase(JRE) ? installLocation : new File(installLocation, JRE);
        File lib = new File(jre, LIB);
        File ext = new File(lib, "ext");
        return ext;
    }

    protected File getDefaultEndorsedDirectory(File installLocation) {
        File lib = new File(installLocation, LIB);
        return new File(lib, "endorsed");
    }

    protected String getDefaultRootPath() {
        return this.fDefaultRootPath;
    }

    protected void setDefaultRootPath(String defaultRootPath) {
        this.fDefaultRootPath = defaultRootPath;
    }

    @Override
    public IStatus validateInstallLocation(File javaHome) {
        File javaExecutable = StandardVMType.findJavaExecutable(javaHome);
        if (javaExecutable == null) {
            return Status.error((String)LaunchingMessages.StandardVMType_Not_a_JDK_Root__Java_executable_was_not_found_1);
        }
        if (this.canDetectDefaultSystemLibraries(javaHome, javaExecutable)) {
            return new Status(0, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_ok_2, null);
        }
        return Status.error((String)LaunchingMessages.StandardVMType_Not_a_JDK_root__System_library_was_not_found__1);
    }

    protected LibraryInfo generateLibraryInfo(File javaHome, File javaExecutable) {
        LibraryInfo info;
        block16: {
            info = null;
            IPath classesZip = IPath.fromFile((File)javaHome.getAbsoluteFile()).append(LIB).append("classes.zip");
            if (classesZip.toFile().exists()) {
                return new LibraryInfo("1.1.x", new String[]{classesZip.toOSString()}, new String[0], new String[0]);
            }
            File file = LaunchingPlugin.getFileInPlugin(IPath.fromPortableString((String)"lib/launchingsupport.jar"));
            if (file != null && file.exists()) {
                String javaExecutablePath = javaExecutable.getAbsolutePath();
                CharSequence[] cmdLine = new String[]{javaExecutablePath, MIN_VM_SIZE, "-classpath", file.getAbsolutePath(), "org.eclipse.jdt.internal.launching.support.LibraryDetector"};
                Process p = null;
                try {
                    try {
                        Map map;
                        String[] envp = null;
                        if ("macosx".equals(Platform.getOS()) && (map = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved()).remove("JAVA_JVM_VERSION") != null) {
                            envp = new String[map.size()];
                            int i = 0;
                            for (Map.Entry entry : map.entrySet()) {
                                envp[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                                ++i;
                            }
                        }
                        p = DebugPlugin.exec((String[])cmdLine, null, envp);
                        IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"Library Detection");
                        process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
                        IStreamMonitor outputStreamMonitor = process.getStreamsProxy().getOutputStreamMonitor();
                        int i = 0;
                        while (i < 600) {
                            if (process.isTerminated() && this.isReadingDone(outputStreamMonitor)) break;
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                LaunchingPlugin.log(e);
                            }
                            ++i;
                        }
                        StandardVMType.checkProcessResult(process);
                        info = this.parseLibraryInfo(process);
                    }
                    catch (Throwable ioe) {
                        LaunchingPlugin.log(ioe);
                        if (p != null) {
                            p.destroy();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        p.destroy();
                    }
                    throw throwable;
                }
                if (p != null) {
                    p.destroy();
                }
            }
        }
        if (info == null) {
            LaunchingPlugin.log(NLS.bind((String)"Failed to retrieve default libraries for {0}", (Object)javaHome.getAbsolutePath()));
        }
        return info;
    }

    private boolean isReadingDone(IStreamMonitor monitor) {
        if (monitor instanceof OutputStreamMonitor) {
            OutputStreamMonitor streamMonitor = (OutputStreamMonitor)monitor;
            return streamMonitor.isReadingDone();
        }
        return true;
    }

    protected LibraryInfo parseLibraryInfo(IProcess process) {
        int index;
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if (text != null && text.length() > 0 && (index = text.indexOf(BAR)) > 0) {
            String version = text.substring(0, index);
            if ((index = (text = text.substring(index + 1)).indexOf(BAR)) > 0) {
                String bootPaths = text.substring(0, index);
                String[] bootPath = this.parsePaths(bootPaths);
                if ((index = (text = text.substring(index + 1)).indexOf(BAR)) > 0) {
                    String extDirPaths = text.substring(0, index);
                    String endorsedDirsPath = text.substring(index + 1);
                    String[] extDirs = this.parsePaths(extDirPaths);
                    String[] endDirs = this.parsePaths(endorsedDirsPath);
                    return new LibraryInfo(version, bootPath, extDirs, endDirs);
                }
            }
        }
        return null;
    }

    protected String[] parsePaths(String paths) {
        return paths.split(File.pathSeparator);
    }

    @Override
    public void disposeVMInstall(String id) {
        IVMInstall vm = this.findVMInstall(id);
        if (vm != null) {
            String path = vm.getInstallLocation().getAbsolutePath();
            LaunchingPlugin.setLibraryInfo(path, null);
            fgFailedInstallPath.remove(path);
            fgDefaultLibLocs.remove(path);
        }
        super.disposeVMInstall(id);
    }

    @Override
    public URL getDefaultJavadocLocation(File installLocation) {
        LibraryInfo libInfo;
        File javaExecutable = StandardVMType.findJavaExecutable(installLocation);
        if (javaExecutable != null && (libInfo = this.getLibraryInfo(installLocation, javaExecutable)) != null) {
            String version = libInfo.getVersion();
            return StandardVMType.getDefaultJavadocLocation(version);
        }
        return null;
    }

    public static URL getDefaultJavadocLocation(String version) {
        try {
            if (version.startsWith("22")) {
                return new URL("https://docs.oracle.com/en/java/javase/22/docs/api/");
            }
            if (version.startsWith("21")) {
                return new URL("https://docs.oracle.com/en/java/javase/21/docs/api/");
            }
            if (version.startsWith("20")) {
                return new URL("https://docs.oracle.com/en/java/javase/20/docs/api/");
            }
            if (version.startsWith("19")) {
                return new URL("https://docs.oracle.com/en/java/javase/19/docs/api/");
            }
            if (version.startsWith("18")) {
                return new URL("https://docs.oracle.com/en/java/javase/18/docs/api/");
            }
            if (version.startsWith("17")) {
                return new URL("https://docs.oracle.com/en/java/javase/17/docs/api/");
            }
            if (version.startsWith("16")) {
                return new URL("https://docs.oracle.com/en/java/javase/16/docs/api/");
            }
            if (version.startsWith("15")) {
                return new URL("https://docs.oracle.com/en/java/javase/15/docs/api/");
            }
            if (version.startsWith("14")) {
                return new URL("https://docs.oracle.com/en/java/javase/14/docs/api/");
            }
            if (version.startsWith("13")) {
                return new URL("https://docs.oracle.com/en/java/javase/13/docs/api/");
            }
            if (version.startsWith("12")) {
                return new URL("https://docs.oracle.com/en/java/javase/12/docs/api/");
            }
            if (version.startsWith("11")) {
                return new URL("https://docs.oracle.com/en/java/javase/11/docs/api/");
            }
            if (version.startsWith("10")) {
                return new URL("https://docs.oracle.com/javase/10/docs/api/");
            }
            if (version.startsWith("9")) {
                return new URL("https://docs.oracle.com/javase/9/docs/api/");
            }
            if (version.startsWith("1.8")) {
                return new URL("https://docs.oracle.com/javase/8/docs/api/");
            }
            if (version.startsWith("1.7")) {
                return new URL("https://docs.oracle.com/javase/7/docs/api/");
            }
            if (version.startsWith("1.6")) {
                return new URL("https://docs.oracle.com/javase/6/docs/api/");
            }
            if (version.startsWith("1.5")) {
                return new URL("https://docs.oracle.com/javase/1.5.0/docs/api/");
            }
            if (version.startsWith("1.4")) {
                return new URL("https://docs.oracle.com/javase/1.5.0/docs/api/");
            }
            if (version.startsWith("1.3")) {
                return new URL("https://docs.oracle.com/javase/1.5.0/docs/api/");
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public synchronized String readReleaseVersion(File javaHome) {
        String version = "";
        Path releaseFile = javaHome.getAbsoluteFile().toPath().resolve(RELEASE_FILE);
        if (Files.notExists(releaseFile, new LinkOption[0])) {
            return version;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<String> lines = Files.lines(releaseFile, Charset.defaultCharset());){
                version = lines.filter(s -> s.contains(JAVA_VERSION)).findFirst().map(line -> line.substring(JAVA_VERSION.length() + 2, line.length() - 1)).orElse("");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | UncheckedIOException e) {
            LaunchingPlugin.log(e);
        }
        return version;
    }

    private static void checkProcessResult(IProcess process) throws DebugException {
        boolean isTerminated = process.isTerminated();
        if (!isTerminated) {
            String output = StandardVMType.getOutput(process);
            String errorMessage = NLS.bind((String)"Process not finished.\n Command line arguments: {0}\nOutput: {1}", (Object)process.getAttribute(IProcess.ATTR_CMDLINE), (Object)output);
            LaunchingPlugin.log(new IllegalStateException(errorMessage));
        } else {
            int exitCode = process.getExitValue();
            if (exitCode != 0) {
                String output = StandardVMType.getOutput(process);
                Object[] errorInfo = new Object[]{exitCode, process.getAttribute(IProcess.ATTR_CMDLINE), output};
                String errorMessage = NLS.bind((String)"Process returned with error code \"{0}\".\nCommand line arguments: {1}\nOutput: {2}", (Object[])errorInfo);
                IllegalStateException exception = new IllegalStateException(errorMessage);
                LaunchingPlugin.log(exception);
            }
        }
    }

    private static String getOutput(IProcess process) {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String output = "IProcess.getStreamsProxy() returned null";
        if (streamsProxy != null) {
            String[] lines = new String[]{"Standard output:", streamsProxy.getOutputStreamMonitor().getContents(), "Standard error:", streamsProxy.getErrorStreamMonitor().getContents()};
            output = String.join((CharSequence)System.lineSeparator(), Arrays.asList(lines));
        }
        return output;
    }
}

