/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.microsoft.java.debug.plugin.internal.ResolveClasspathsHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;

public class ProjectSettingsChecker {
    public static boolean check(ProjectSettingsCheckerParams params) {
        Map options = new HashMap();
        IJavaProject javaProject = null;
        if (StringUtils.isNotBlank((CharSequence)params.projectName)) {
            javaProject = JdtUtils.getJavaProject(params.projectName);
        } else if (StringUtils.isNotBlank((CharSequence)params.className)) {
            try {
                List<IJavaProject> projects = ResolveClasspathsHandler.getJavaProjectFromType(params.className);
                if (!projects.isEmpty()) {
                    javaProject = projects.get(0);
                }
            }
            catch (CoreException coreException) {}
        }
        if (javaProject != null) {
            options = javaProject.getOptions(params.inheritedOptions);
        }
        for (Map.Entry<String, String> expected : params.expectedOptions.entrySet()) {
            if (Objects.equals(options.get(expected.getKey()), expected.getValue())) continue;
            return false;
        }
        return true;
    }

    public static class ProjectSettingsCheckerParams {
        String className;
        String projectName;
        boolean inheritedOptions;
        Map<String, String> expectedOptions;
    }
}

