/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.EventNotification;
import org.eclipse.jdt.ls.core.internal.EventType;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.handlers.BuildWorkspaceHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.extended.ProjectBuildParams;

public class ClasspathUpdateHandler
implements IElementChangedListener {
    private final JavaClientConnection connection;
    private final BaseDocumentLifeCycleHandler lifeCycleHandler;

    public ClasspathUpdateHandler(JavaClientConnection client) {
        this(client, null);
    }

    public ClasspathUpdateHandler(JavaClientConnection client, BaseDocumentLifeCycleHandler lifeCycleHandler) {
        this.connection = client;
        this.lifeCycleHandler = lifeCycleHandler;
    }

    public void elementChanged(ElementChangedEvent event) {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        this.processDelta(event.getDelta(), projects);
        if (this.connection != null && projects != null && !projects.isEmpty()) {
            for (final IJavaProject javaProject : projects) {
                final String uri = ProjectUtils.getProjectRealFolder(javaProject.getProject()).toFile().toURI().toString();
                final PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
                if (!preferenceManager.getPreferences().isAutobuildEnabled()) {
                    if (this.lifeCycleHandler != null) {
                        ICompilationUnit[] iCompilationUnitArray = JavaCore.getWorkingCopies(null);
                        int n = iCompilationUnitArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICompilationUnit unit = iCompilationUnitArray[n2];
                            if (unit.getJavaProject().equals(javaProject)) {
                                try {
                                    this.lifeCycleHandler.triggerValidation(unit);
                                }
                                catch (JavaModelException e) {
                                    JavaLanguageServerPlugin.logException("Failed to revalidate document after classpath change: " + String.valueOf(unit.getPath()), e);
                                }
                            }
                            ++n2;
                        }
                    }
                } else if (preferenceManager.getPreferences().getNullAnalysisMode().equals((Object)Preferences.FeatureStatus.automatic)) {
                    WorkspaceJob job = new WorkspaceJob("Classpath Update Job"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            if (!preferenceManager.getPreferences().updateAnnotationNullAnalysisOptions(javaProject, true)) {
                                return Status.OK_STATUS;
                            }
                            BuildWorkspaceHandler buildWorkspaceHandler = new BuildWorkspaceHandler(JavaLanguageServerPlugin.getProjectsManager());
                            ProjectBuildParams params = new ProjectBuildParams(Arrays.asList(new TextDocumentIdentifier(uri)), true);
                            BuildWorkspaceStatus status = buildWorkspaceHandler.buildProjects(params, monitor);
                            switch (status) {
                                case FAILED: 
                                case WITH_ERROR: {
                                    return Status.error((String)"error occurs during building project");
                                }
                                case SUCCEED: {
                                    return Status.OK_STATUS;
                                }
                                case CANCELLED: {
                                    return Status.CANCEL_STATUS;
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(20);
                    job.setRule((ISchedulingRule)javaProject.getProject());
                    job.schedule();
                }
                EventNotification notification = new EventNotification().withType(EventType.ClasspathUpdated).withData(uri);
                this.connection.sendEventNotification(notification);
            }
        }
    }

    public void addElementChangeListener() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void removeElementChangeListener() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    private void processDeltaChildren(IJavaElementDelta delta, Set<IJavaProject> projects) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta c = iJavaElementDeltaArray[n2];
            this.processDelta(c, projects);
            ++n2;
        }
    }

    private void processDelta(IJavaElementDelta delta, Set<IJavaProject> projects) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                this.processDeltaChildren(delta, projects);
                break;
            }
            case 2: {
                if (!this.isClasspathChanged(delta.getFlags())) break;
                IJavaProject javaProject = (IJavaProject)element;
                projects.add(javaProject);
                break;
            }
        }
    }

    private boolean isClasspathChanged(int flags) {
        return (flags & 0x220600) != 0;
    }
}

