/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.assist;

import java.util.List;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;

public class ContentContextHelper {
    private String contents;
    private int position;
    private final String prefix;

    public ContentContextHelper(String text, int position, String prefix) {
        this.contents = text;
        this.position = position;
        this.prefix = prefix;
    }

    public String getProposalStart() {
        String proposalStart = "";
        if (!StringUtil.isEmpty(this.contents)) {
            if (ContentContextHelper.matchEmptyExpressions(this.contents, CompoundInterpreter.INSTANCE.getAllNewEmtpyExpressions())) {
                proposalStart = this.contents;
            } else if (this.position > 0 && this.position <= this.contents.length()) {
                int numberOfalreadyWrittenCharacters = 0;
                String substring = this.contents.substring(0, this.position);
                numberOfalreadyWrittenCharacters = this.findNumberOfAlreadyWrittenCharacters(substring);
                if (numberOfalreadyWrittenCharacters != 0 && numberOfalreadyWrittenCharacters <= substring.length()) {
                    int propStart = substring.length() - numberOfalreadyWrittenCharacters;
                    proposalStart = substring.substring(propStart);
                    String exprStart = substring.substring(0, propStart);
                    if (!StringUtil.isEmpty(this.prefix) && exprStart.endsWith(this.prefix)) {
                        proposalStart = String.valueOf(this.prefix) + proposalStart;
                    }
                }
            }
        }
        return proposalStart;
    }

    private int findNumberOfAlreadyWrittenCharacters(String evaluationString) {
        int numberOfalreadyWrittenCharacters = evaluationString.length();
        if (evaluationString.trim().length() > 0) {
            numberOfalreadyWrittenCharacters = 0;
            boolean isLetter = true;
            while (isLetter && numberOfalreadyWrittenCharacters < evaluationString.length()) {
                char charac = evaluationString.charAt(evaluationString.length() - numberOfalreadyWrittenCharacters - 1);
                if (Character.isJavaIdentifierPart(charac)) {
                    ++numberOfalreadyWrittenCharacters;
                    continue;
                }
                isLetter = false;
            }
        }
        return numberOfalreadyWrittenCharacters;
    }

    public static boolean matchEmptyExpressions(String contents, List<ContentProposal> emptyExpressions) {
        for (ContentProposal emptyExpression : emptyExpressions) {
            if (!ContentContextHelper.matchEmptyExpression(contents, emptyExpression)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchEmptyExpression(String contents, ContentProposal emptyExpression) {
        String proposal = emptyExpression.getProposal();
        return proposal.startsWith(contents) && proposal.length() != contents.length();
    }
}

