/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.hrm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PortType implements Enumerator
{
    MALE(0, "male", "male"),
    FEMALE(1, "female", "female"),
    OTHER(2, "other", "other"),
    UNDEF(3, "undef", "undef");

    public static final int MALE_VALUE = 0;
    public static final int FEMALE_VALUE = 1;
    public static final int OTHER_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    private static final PortType[] VALUES_ARRAY;
    public static final List<PortType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PortType[]{MALE, FEMALE, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PortType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortType get(int value) {
        switch (value) {
            case 0: {
                return MALE;
            }
            case 1: {
                return FEMALE;
            }
            case 2: {
                return OTHER;
            }
            case 3: {
                return UNDEF;
            }
        }
        return null;
    }

    private PortType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

