/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.nfp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.polarsys.time4sys.marte.nfp.Dimension;
import org.polarsys.time4sys.marte.nfp.impl.TimeDimension;

public enum TimeUnitKind implements Enumerator
{
    PS(1, "ps", "picosecond"),
    NS(2, "ns", "nanosecond"),
    US(3, "us", "microsecond"),
    MS(4, "ms", "millisecond"),
    S(5, "s", "second"),
    MN(6, "mn", "minute"),
    H(7, "h", "hour"),
    D(8, "d", "days");

    public static final int PS_VALUE = 1;
    public static final int NS_VALUE = 2;
    public static final int US_VALUE = 3;
    public static final int MS_VALUE = 4;
    public static final int S_VALUE = 5;
    public static final int MN_VALUE = 6;
    public static final int H_VALUE = 7;
    public static final int D_VALUE = 8;
    private static final TimeUnitKind[] VALUES_ARRAY;
    public static final List<TimeUnitKind> VALUES;
    public static final Dimension<TimeUnitKind> dimension;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeUnitKind[]{PS, NS, US, MS, S, MN, H, D};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
        dimension = TimeDimension.timeDimension;
    }

    public static TimeUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnitKind get(int value) {
        switch (value) {
            case 1: {
                return PS;
            }
            case 2: {
                return NS;
            }
            case 3: {
                return US;
            }
            case 4: {
                return MS;
            }
            case 5: {
                return S;
            }
            case 6: {
                return MN;
            }
            case 7: {
                return H;
            }
            case 8: {
                return D;
            }
        }
        return null;
    }

    private TimeUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

