/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import java.util.Iterator;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.ProcessorBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.ResourceService;
import org.polarsys.time4sys.marte.hrm.HardwareProcessor;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.Alarm;
import org.polarsys.time4sys.marte.srm.InterruptKind;
import org.polarsys.time4sys.marte.srm.NotificationResource;
import org.polarsys.time4sys.marte.srm.SoftwareTimerResource;
import org.polarsys.time4sys.marte.srm.SrmFactory;

public class AlarmBuilder {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private DesignBuilder designBuilder = null;
    private Alarm alarm = null;
    private String name = null;
    protected boolean isWatchdog = false;
    private SoftwareTimerResource timer;
    private Duration duration;
    private ResourceService reset;
    private ResourceService signal;

    public static AlarmBuilder anAlarm() {
        return new AlarmBuilder(null, null);
    }

    public static AlarmBuilder aWatchdog() {
        return new AlarmBuilder(null, null).usedAsAWatchdog();
    }

    public AlarmBuilder(DesignBuilder designBuilder, Alarm alarm) {
        this.designBuilder = designBuilder;
        this.alarm = alarm;
    }

    public AlarmBuilder called(String value) {
        this.name = value;
        return this;
    }

    public AlarmBuilder usedAsAWatchdog() {
        this.isWatchdog = true;
        return this;
    }

    public Alarm build(DesignBuilder value) {
        if (this.designBuilder == null && value != null) {
            this.designBuilder = value;
        }
        assert (this.designBuilder != null);
        if (this.alarm == null) {
            this.alarm = srmFactory.createAlarm();
            if (this.name != null) {
                this.alarm.setName(this.name);
            }
            this.alarm.setIsWatchdog(this.isWatchdog);
            if (this.isWatchdog) {
                this.alarm.setKind(InterruptKind.HARDWARE_INTERRUPTION);
            }
        }
        if (this.alarm.getTimers().isEmpty()) {
            this.timer = srmFactory.createSoftwareTimerResource();
            this.alarm.getOwnedResource().add((Object)this.timer);
            this.alarm.getTimers().add((Object)this.timer);
            if (this.duration != null) {
                this.timer.setDuration(this.duration);
            }
            NotificationResource notif = null;
            Iterator iterator = this.alarm.getNotificationResources().iterator();
            if (iterator.hasNext()) {
                NotificationResource res;
                notif = res = (NotificationResource)iterator.next();
            }
            if (notif == null) {
                notif = srmFactory.createNotificationResource();
                notif.setName(String.valueOf(this.name) + " notification");
                this.alarm.getOwnedResource().add((Object)notif);
                this.alarm.getNotificationResources().add((Object)notif);
            }
            assert (notif != null);
            if (notif.getSignalServices().isEmpty()) {
                this.signal = grmFactory.createResourceService();
                this.signal.setName(String.valueOf(this.name) + " signal");
                this.alarm.getPServices().add((Object)this.signal);
                notif.getSignalServices().add((Object)this.signal);
            }
            if (this.timer.getReset() == null) {
                this.reset = grmFactory.createResourceService();
                this.reset.setName("reset " + this.name);
                this.timer.getPServices().add((Object)this.reset);
                this.timer.setReset(this.reset);
            }
        }
        assert (this.reset != null);
        assert (this.signal != null);
        assert (!this.alarm.getNotificationResources().isEmpty());
        assert (!((NotificationResource)this.alarm.getNotificationResources().get(0)).getSignalServices().isEmpty());
        return this.alarm;
    }

    public AlarmBuilder ofDuration(String value) {
        this.duration = nfpFactory.createDurationFromString(value);
        return this;
    }

    public void activates(StepBuilder step) {
    }

    public AlarmBuilder handledBy(ProcessorBuilder theProcA) {
        this.build(null);
        HardwareProcessor proc = theProcA.build();
        proc.getOwnedResource().add((Object)this.alarm);
        return this;
    }

    public ResourceService buildResetService(DesignBuilder value) {
        this.build(value);
        assert (this.reset != null);
        return this.reset;
    }

    public ResourceService buildSignalService(DesignBuilder value) {
        this.build(value);
        assert (this.signal != null);
        return this.signal;
    }
}

