/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.internal.model.SystemNewConnectionPromptObject;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemViewRootInputAdapter
extends AbstractSystemViewAdapter {
    private SystemNewConnectionPromptObject newConnPrompt;
    private Object[] newConnPromptArray;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        return null;
    }

    public String getText(Object element) {
        return SystemResources.RESID_SYSTEMREGISTRY_CONNECTIONS;
    }

    public String getAbsoluteName(Object element) {
        return this.getText(element);
    }

    public String getType(Object element) {
        return SystemViewResources.RESID_PROPERTY_FILE_TYPE_ROOT_VALUE;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        ISystemViewInputProvider provider = (ISystemViewInputProvider)element;
        if (provider instanceof ISystemRegistry && this.showNewConnectionPrompt()) {
            Object[] children = provider.getSystemViewRoots();
            if (children == null || children.length == 0) {
                return this.getNewConnectionPromptObjectAsArray();
            }
            Object[] allChildren = new Object[children.length + 1];
            allChildren[0] = this.getNewConnectionPromptObject();
            int idx = 0;
            while (idx < children.length) {
                allChildren[idx + 1] = children[idx];
                ++idx;
            }
            return allChildren;
        }
        return provider.getSystemViewRoots();
    }

    public boolean hasChildren(IAdaptable element) {
        ISystemViewInputProvider provider = (ISystemViewInputProvider)element;
        if (provider instanceof ISystemRegistry && this.showNewConnectionPrompt()) {
            return true;
        }
        return provider.hasSystemViewRoots();
    }

    public boolean showDelete(Object element) {
        return false;
    }

    public boolean showRename(Object element) {
        return false;
    }

    public ISystemValidator getNameValidator(Object element) {
        return null;
    }

    private boolean showNewConnectionPrompt() {
        return SystemPreferencesManager.getShowNewConnectionPrompt();
    }

    private SystemNewConnectionPromptObject getNewConnectionPromptObject() {
        if (this.newConnPrompt == null) {
            this.newConnPrompt = new SystemNewConnectionPromptObject();
        }
        return this.newConnPrompt;
    }

    private Object[] getNewConnectionPromptObjectAsArray() {
        if (this.newConnPromptArray == null) {
            this.newConnPromptArray = new Object[1];
        }
        this.newConnPromptArray[0] = this.getNewConnectionPromptObject();
        return this.newConnPromptArray;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return null;
    }

    public Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getMementoHandle(Object element) {
        return "Connections";
    }

    public String getMementoHandleKey(Object element) {
        return this.getType(element);
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

