/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.files;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.dstore.core.model.DataStore;

public class DStoreOutputStream
extends OutputStream {
    private DataStore _dataStore;
    private String _remotePath;
    private String _encoding;
    private int _mode;
    private boolean _firstWrite = true;
    private int _options;
    private String _byteStreamHandlerId;
    private String _localLineSep;
    private String _targetLineSep;
    private int _localLineSepLength;
    static /* synthetic */ Class class$0;

    public DStoreOutputStream(DataStore dataStore, String remotePath, String encoding, int mode, boolean unixStyle, int options) {
        this._dataStore = dataStore;
        this._remotePath = remotePath;
        this._encoding = encoding;
        this._mode = mode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.dstore.universal.miners.UniversalByteStreamHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._byteStreamHandlerId = clazz.getName();
        this._localLineSep = System.getProperty("line.separator");
        this._targetLineSep = "\n";
        if (!unixStyle) {
            this._targetLineSep = "\r\n";
        }
        this._localLineSepLength = this._localLineSep.length();
        this._options = options;
    }

    public void close() throws IOException {
        super.close();
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (this._mode == -1) {
            String tempStr = new String(b, 0, length);
            tempStr = this.convertLineSeparators(tempStr);
            b = tempStr.getBytes(this._encoding);
        }
        if (this._firstWrite && (this._options & 1) == 0) {
            this._firstWrite = false;
            this._dataStore.replaceFile(this._remotePath, b, length, true, this._byteStreamHandlerId);
        } else {
            this._dataStore.replaceAppendFile(this._remotePath, b, length, true, this._byteStreamHandlerId);
        }
    }

    private String convertLineSeparators(String tempStr) {
        if (!this._localLineSep.equals(this._targetLineSep)) {
            int index = tempStr.indexOf(this._localLineSep);
            StringBuffer buf = new StringBuffer();
            boolean lineEndFound = false;
            int lastIndex = 0;
            while (index != -1) {
                buf = buf.append(tempStr.substring(lastIndex, index));
                buf = buf.append(this._targetLineSep);
                if (!lineEndFound) {
                    lineEndFound = true;
                }
                lastIndex = index + this._localLineSepLength;
                index = tempStr.indexOf(this._localLineSep, lastIndex);
            }
            if (lineEndFound) {
                buf = buf.append(tempStr.substring(lastIndex));
                tempStr = buf.toString();
            }
        }
        return tempStr;
    }

    public void write(byte[] b) throws IOException {
        if (this._mode == -1) {
            String tempStr = new String(b, 0, b.length);
            tempStr = this.convertLineSeparators(tempStr);
            b = tempStr.getBytes(this._encoding);
        }
        if (this._firstWrite && (this._options & 1) == 0) {
            this._firstWrite = false;
            this._dataStore.replaceFile(this._remotePath, b, b.length, true, this._byteStreamHandlerId);
        } else {
            this._dataStore.replaceAppendFile(this._remotePath, b, b.length, true, this._byteStreamHandlerId);
        }
    }

    public void write(int c) throws IOException {
        byte[] b = new byte[]{(byte)c};
        if (this._mode == -1) {
            String tempStr = new String(b, 0, 1);
            b = tempStr.getBytes(this._encoding);
        }
        if (this._firstWrite && (this._options & 1) == 0) {
            this._firstWrite = false;
            this._dataStore.replaceFile(this._remotePath, b, b.length, true, this._byteStreamHandlerId);
        } else {
            this._dataStore.replaceAppendFile(this._remotePath, b, b.length, true, this._byteStreamHandlerId);
        }
    }
}

