/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.rse.internal.files.ui.Activator;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.subsystems.files.core.model.SystemFileTransferModeMapping;
import org.eclipse.rse.internal.subsystems.files.core.model.SystemFileTransferModeRegistry;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeMapping;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.FileExtensionDialog;

public class UniversalPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
Listener,
ICellModifier {
    protected Label resourceTypeLabel;
    protected Table resourceTypeTable;
    protected Button addResourceTypeButton;
    protected Button removeResourceTypeButton;
    protected Button toggleModeButton;
    protected Button doSuperTransferButton;
    protected Button defaultBinaryButton;
    protected Button defaultTextButton;
    protected SystemFileTransferModeRegistry modeRegistry;
    protected ArrayList modeMappings;
    protected ArrayList imagesToDispose;
    protected Combo archiveTypeCombo;
    protected Combo defaultArchiveTypeCombo;
    protected Text downloadBufferSize;
    protected Text uploadBufferSize;
    protected Image fileImage;
    protected Image binaryFileImage;
    protected String[] columnProperties = new String[]{"P_ICON", "P_TYPE", "P_CONTENT"};

    public UniversalPreferencePage() {
        super(1);
        this.setPreferenceStore(RSEUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.rse.ui.ufpf0000");
    }

    protected void createFieldEditors() {
        this.modeRegistry = SystemFileTransferModeRegistry.getInstance();
        this.modeMappings = new ArrayList();
        this.imagesToDispose = new ArrayList();
        Composite parent = this.getFieldEditorParent();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        this.resourceTypeLabel = new Label(pageComponent, 16384);
        this.resourceTypeLabel.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TYPE_LABEL);
        this.resourceTypeLabel.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TYPE_TOOLTIP);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.resourceTypeLabel.setLayoutData((Object)data);
        this.resourceTypeTable = new Table(pageComponent, 67588);
        this.resourceTypeTable.addListener(13, (Listener)this);
        this.resourceTypeTable.addListener(14, (Listener)this);
        data = new GridData(1808);
        data.heightHint = this.resourceTypeTable.getItemHeight() * 12;
        data.grabExcessHorizontalSpace = true;
        this.resourceTypeTable.setLayoutData((Object)data);
        Composite groupComponent = new Composite(pageComponent, 0);
        groupComponent.setLayout((Layout)new GridLayout());
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.addResourceTypeButton = new Button(groupComponent, 8);
        this.addResourceTypeButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_ADDBUTTON_LABEL);
        this.addResourceTypeButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_ADDBUTTON_TOOLTIP);
        this.addResourceTypeButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.addResourceTypeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.addResourceTypeButton.setLayoutData((Object)data);
        this.removeResourceTypeButton = new Button(groupComponent, 8);
        this.removeResourceTypeButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_REMOVEBUTTON_LABEL);
        this.removeResourceTypeButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_REMOVEBUTTON_TOOLTIP);
        this.removeResourceTypeButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeResourceTypeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeResourceTypeButton.setLayoutData((Object)data);
        this.toggleModeButton = new Button(groupComponent, 8);
        this.toggleModeButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TOGGLEBUTTON_LABEL);
        this.toggleModeButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TOGGLEBUTTON_TOOLTIP);
        this.toggleModeButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.toggleModeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.toggleModeButton.setLayoutData((Object)data);
        Composite afterTableComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        afterTableComposite.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalSpan = 2;
        afterTableComposite.setLayoutData((Object)data);
        Group defaultModeGroup = new Group(afterTableComposite, 16);
        defaultModeGroup.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_DEFAULT_MODE_LABEL);
        defaultModeGroup.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_DEFAULT_MODE_TOOLTIP);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 10;
        defaultModeGroup.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        defaultModeGroup.setLayoutData((Object)data);
        this.defaultBinaryButton = new Button((Composite)defaultModeGroup, 16);
        this.defaultBinaryButton.addListener(13, (Listener)this);
        this.defaultBinaryButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_LABEL);
        this.defaultBinaryButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_TOOLTIP);
        this.defaultTextButton = new Button((Composite)defaultModeGroup, 16);
        this.defaultTextButton.addListener(13, (Listener)this);
        this.defaultTextButton.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_LABEL);
        this.defaultTextButton.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_TOOLTIP);
        Composite propertiesComposite = new Composite(afterTableComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        data = new GridData();
        data.horizontalSpan = 1;
        propertiesComposite.setLayout((Layout)layout);
        propertiesComposite.setLayoutData((Object)data);
        BooleanFieldEditor showHiddenEditor = new BooleanFieldEditor("org.eclipse.rse.subsystems.files.core.preferences.showhidden", FileResources.RESID_PREF_UNIVERSAL_SHOWHIDDEN_LABEL, propertiesComposite);
        this.addField((FieldEditor)showHiddenEditor);
        BooleanFieldEditor preserveTimestamps = new BooleanFieldEditor("org.eclipse.rse.subsystems.files.core.preferences.preservetimestamps", FileResources.RESID_PREF_UNIVERSAL_PRESERVE_TIMESTAMPS_LABEL, propertiesComposite);
        this.addField((FieldEditor)preserveTimestamps);
        BooleanFieldEditor shareCachedFiles = new BooleanFieldEditor("org.eclipse.rse.subsystems.files.core.preferences.sharecachedfiles", FileResources.RESID_PREF_UNIVERSAL_SHARE_CACHED_FILES_LABEL, propertiesComposite);
        this.addField((FieldEditor)shareCachedFiles);
        Group transferGroup = new Group(parent, 0);
        transferGroup.setText(FileResources.RESID_FILES_PREFERENCES_BUFFER);
        GridLayout tlayout = new GridLayout();
        tlayout.numColumns = 4;
        transferGroup.setLayout((Layout)tlayout);
        transferGroup.setLayoutData((Object)new GridData());
        Label downloadBufferLabel = new Label((Composite)transferGroup, 0);
        downloadBufferLabel.setText(FileResources.RESID_FILES_PREFERENCES_DOWNLOAD_BUFFER_SIZE_LABEL);
        downloadBufferLabel.setToolTipText(FileResources.RESID_FILES_PREFERENCES_DOWNLOAD_BUFFER_SIZE_TOOLTIP);
        this.downloadBufferSize = SystemWidgetHelpers.createTextField((Composite)transferGroup, (Listener)this);
        GridData tgd = new GridData();
        tgd.widthHint = 75;
        this.downloadBufferSize.setLayoutData((Object)tgd);
        this.downloadBufferSize.setTextLimit(10);
        this.downloadBufferSize.setText(String.valueOf(UniversalPreferencePage.getDownloadBufferSize()));
        this.downloadBufferSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        Label uploadBufferLabel = new Label((Composite)transferGroup, 0);
        uploadBufferLabel.setText(FileResources.RESID_FILES_PREFERENCES_UPLOAD_BUFFER_SIZE_LABEL);
        uploadBufferLabel.setToolTipText(FileResources.RESID_FILES_PREFERENCES_UPLOAD_BUFFER_SIZE_TOOLTIP);
        this.uploadBufferSize = SystemWidgetHelpers.createTextField((Composite)transferGroup, (Listener)this);
        tgd = new GridData();
        tgd.widthHint = 75;
        this.uploadBufferSize.setLayoutData((Object)tgd);
        this.uploadBufferSize.setTextLimit(10);
        this.uploadBufferSize.setText(String.valueOf(UniversalPreferencePage.getUploadBufferSize()));
        this.uploadBufferSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        Composite archiveGroup = new Composite(parent, 0);
        GridLayout alayout = new GridLayout();
        alayout.numColumns = 2;
        archiveGroup.setLayout((Layout)alayout);
        archiveGroup.setLayoutData((Object)new GridData(32));
        this.doSuperTransferButton = SystemWidgetHelpers.createCheckBox((Composite)archiveGroup, (String)FileResources.RESID_SUPERTRANSFER_PREFS_ENABLE, (Listener)this);
        GridData cdata = new GridData();
        cdata.horizontalSpan = 2;
        this.doSuperTransferButton.setLayoutData((Object)cdata);
        this.archiveTypeCombo = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)archiveGroup, null, (String)FileResources.RESID_SUPERTRANSFER_PREFS_TYPE_LABEL, (String)FileResources.RESID_SUPERTRANSFER_PREFS_TYPE_TOOLTIP);
        this.archiveTypeCombo.setItems(ArchiveHandlerManager.getInstance().getRegisteredExtensions());
        boolean doSuperTransfer = UniversalPreferencePage.getDoSuperTransfer();
        this.doSuperTransferButton.setSelection(doSuperTransfer);
        this.archiveTypeCombo.setTextLimit(6);
        this.archiveTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UniversalPreferencePage.setSuperTransferTypePreference(UniversalPreferencePage.this.archiveTypeCombo.getText());
            }
        });
        this.archiveTypeCombo.setEnabled(doSuperTransfer);
        this.fillResourceTypeTable();
        if (this.resourceTypeTable.getItemCount() > 0) {
            this.resourceTypeTable.setSelection(0);
            this.resourceTypeTable.setFocus();
        }
        this.updateEnabledState();
        new Mnemonics().setOnPreferencePage(true).setMnemonics(parent);
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore store) {
    }

    protected void fillResourceTypeTable() {
        TableLayout tableLayout = new TableLayout();
        this.resourceTypeTable.setLayout((Layout)tableLayout);
        this.resourceTypeTable.setHeaderVisible(true);
        this.resourceTypeTable.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(this.resourceTypeTable);
        tableViewer.setCellModifier((ICellModifier)this);
        ColumnPixelData layoutData = new ColumnPixelData(20, false);
        tableLayout.addColumnData((ColumnLayoutData)layoutData);
        TableColumn tableCol = new TableColumn(this.resourceTypeTable, 0, 0);
        tableCol.setResizable(false);
        tableCol.pack();
        tableCol.setWidth(20);
        tableCol.setText("");
        layoutData = new ColumnWeightData(40, true);
        tableLayout.addColumnData((ColumnLayoutData)layoutData);
        tableCol = new TableColumn(this.resourceTypeTable, 0, 1);
        tableCol.setResizable(true);
        tableCol.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TABLECOL_LABEL);
        tableCol.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_TABLECOL_TOOLTIP);
        tableCol.pack();
        tableCol.setWidth(100);
        layoutData = new ColumnWeightData(60, true);
        tableLayout.addColumnData((ColumnLayoutData)layoutData);
        tableCol = new TableColumn(this.resourceTypeTable, 0, 2);
        tableCol.setResizable(true);
        tableCol.setText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_LABEL);
        tableCol.setToolTipText(FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TOOLTIP);
        tableCol.pack();
        tableCol.setWidth(200);
        String[] contentTypes = new String[]{FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_LABEL, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_LABEL, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_XML_LABEL};
        CellEditor[] editors = new CellEditor[]{null, new TextCellEditor((Composite)this.resourceTypeTable), new ComboBoxCellEditor((Composite)this.resourceTypeTable, contentTypes, 8)};
        tableViewer.setColumnProperties(this.columnProperties);
        tableViewer.setCellEditors(editors);
        this.initControls();
    }

    private void initControls() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        ISystemFileTransferModeMapping[] mappings = this.getModeMappings();
        int i = 0;
        while (i < mappings.length) {
            this.newResourceTableItem(mappings[i], i, false);
            ++i;
        }
        int defaultFileTransferMode = UniversalPreferencePage.getFileTransferModeDefaultPreference();
        if (defaultFileTransferMode == 0) {
            this.defaultBinaryButton.setSelection(true);
        } else if (defaultFileTransferMode == 1) {
            this.defaultTextButton.setSelection(true);
        }
        String superTransferArcType = store.getString("org.eclipse.rse.subsystems.files.core.preferences.supertransfer.archivetype");
        this.archiveTypeCombo.setText(superTransferArcType);
        boolean doSuperTransfer = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        this.doSuperTransferButton.setSelection(doSuperTransfer);
        int downloadSize = store.getInt("org.eclipse.rse.subsystems.files.core.preferences.download.buffer.size");
        this.downloadBufferSize.setText(String.valueOf(downloadSize));
        int uploadSize = store.getInt("org.eclipse.rse.subsystems.files.core.preferences.upload.buffer.size");
        this.uploadBufferSize.setText(String.valueOf(uploadSize));
    }

    protected ISystemFileTransferModeMapping[] getModeMappings() {
        ISystemFileTransferModeMapping[] mappings = this.modeRegistry.getModeMappings();
        ISystemFileTransferModeMapping[] clonedMappings = new ISystemFileTransferModeMapping[mappings.length];
        int i = 0;
        while (i < mappings.length) {
            SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)mappings[i];
            clonedMappings[i] = (ISystemFileTransferModeMapping)mapping.clone();
            ++i;
        }
        return clonedMappings;
    }

    protected void resetResourceTypeTable() {
        this.modeRegistry.renit();
        this.modeMappings.clear();
        this.resourceTypeTable.setRedraw(false);
        this.resourceTypeTable.removeAll();
        ISystemFileTransferModeMapping[] mappings = this.getModeMappings();
        int i = 0;
        while (i < mappings.length) {
            this.newResourceTableItem(mappings[i], i, false);
            ++i;
        }
        this.resourceTypeTable.setRedraw(true);
        IEclipsePreferences prefs = new DefaultScope().getNode(RSEUIPlugin.getDefault().getBundle().getSymbolicName());
        int defaultFileTransferMode = prefs.getInt("org.eclipse.rse.subsystems.files.core.preferences.filetransfermodedefault", 0);
        this.defaultBinaryButton.setSelection(defaultFileTransferMode == 0);
        this.defaultTextButton.setSelection(defaultFileTransferMode == 1);
        if (this.resourceTypeTable.getItemCount() > 0) {
            this.resourceTypeTable.setSelection(0);
            this.resourceTypeTable.setFocus();
        }
        this.updateEnabledState();
        this.archiveTypeCombo.setEnabled(false);
    }

    protected void resetSuperTransferPrefs() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        String superTransferArcType = store.getDefaultString("org.eclipse.rse.subsystems.files.core.preferences.supertransfer.archivetype");
        this.archiveTypeCombo.setText(superTransferArcType);
        boolean doSuperTransfer = store.getDefaultBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        this.doSuperTransferButton.setSelection(doSuperTransfer);
    }

    protected void resetBufferSizePrefs() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        int downloadSize = store.getDefaultInt("org.eclipse.rse.subsystems.files.core.preferences.download.buffer.size");
        this.downloadBufferSize.setText(String.valueOf(downloadSize));
        int uploadSize = store.getDefaultInt("org.eclipse.rse.subsystems.files.core.preferences.upload.buffer.size");
        this.uploadBufferSize.setText(String.valueOf(uploadSize));
    }

    private Image applyBinaryDecoration(Image source) {
        ImageDescriptor binaryOverlay = Activator.getImageDescriptor("/icons/full/ovr16/binary_ovr.gif");
        DecorationOverlayIcon icon = new DecorationOverlayIcon(source, binaryOverlay, 3);
        return icon.createImage();
    }

    private Image getImageFor(ISystemFileTransferModeMapping mapping) {
        if (this.fileImage == null) {
            this.fileImage = WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FILE").createImage();
        }
        if (this.binaryFileImage == null) {
            this.binaryFileImage = this.applyBinaryDecoration(this.fileImage);
        }
        if (mapping.isBinary() || mapping.isXML()) {
            return this.binaryFileImage;
        }
        return this.fileImage;
    }

    protected TableItem newResourceTableItem(ISystemFileTransferModeMapping mapping, int index, boolean selected) {
        this.modeMappings.add(index, mapping);
        Image image = this.getImageFor(mapping);
        if (image != null) {
            this.imagesToDispose.add(image);
        }
        TableItem item = new TableItem(this.resourceTypeTable, 0, index);
        item.setData((Object)mapping);
        item.setImage(0, image);
        item.setText(1, mapping.getLabel());
        boolean isText = mapping.isText();
        boolean isXML = mapping.isXML();
        if (isText) {
            item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_LABEL);
        } else if (isXML) {
            item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_XML_LABEL);
        } else {
            item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_LABEL);
        }
        if (selected) {
            this.resourceTypeTable.setSelection(index);
        }
        return item;
    }

    public void dispose() {
        super.dispose();
        if (this.imagesToDispose != null) {
            Iterator e = this.imagesToDispose.iterator();
            while (e.hasNext()) {
                ((Image)e.next()).dispose();
            }
            this.imagesToDispose = null;
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addResourceTypeButton && event.type == 13) {
            this.promptForResourceType();
        } else if (event.widget == this.removeResourceTypeButton && event.type == 13) {
            this.removeSelectedResourceType();
        } else if (event.widget == this.toggleModeButton && event.type == 13) {
            this.toggleSelectedResourceTypeMode();
        } else if (event.widget == this.doSuperTransferButton && event.type == 13) {
            this.doSuperTransferButtonSelected();
        }
        this.updateEnabledState();
    }

    public void promptForResourceType() {
        FileExtensionDialog dialog = new FileExtensionDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String extension = dialog.getExtension();
            this.addResourceType(name, extension);
        }
    }

    public void removeSelectedResourceType() {
        int index = this.resourceTypeTable.getSelectionIndex();
        this.modeMappings.remove(index);
        TableItem[] items = this.resourceTypeTable.getSelection();
        if (items.length > 0) {
            items[0].dispose();
        }
    }

    public void toggleSelectedResourceTypeMode() {
        TableItem item = this.resourceTypeTable.getSelection()[0];
        SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)item.getData();
        if (mapping.isBinary()) {
            mapping.setAsText();
            item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_LABEL);
            item.setImage(this.getImageFor((ISystemFileTransferModeMapping)mapping));
        } else if (mapping.isText()) {
            mapping.setAsBinary();
            item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_LABEL);
            item.setImage(this.getImageFor((ISystemFileTransferModeMapping)mapping));
        } else if (mapping.isXML()) {
            mapping.setAsXML();
            item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_XML_LABEL);
            item.setImage(this.getImageFor((ISystemFileTransferModeMapping)mapping));
        }
    }

    public void addResourceType(String newName, String newExtension) {
        if (newName == null || newName.length() < 1) {
            newName = "*";
        } else {
            int index = newName.indexOf(42);
            if (index > -1 && (index != 0 || newName.length() != 1)) {
                RSEUIPlugin.getPluginMessageFile();
                Shell shell = this.getControl().getShell();
                String msgTxt = FileResources.MSG_ERROR_FILENAME_INVALID;
                SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF6002", 4, msgTxt);
                SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)message);
                return;
            }
        }
        String newFileName = null;
        newFileName = newExtension == null || newExtension.length() < 1 ? newName.toUpperCase() : (String.valueOf(newName) + "." + newExtension).toUpperCase();
        boolean found = false;
        int i = 0;
        SystemFileTransferModeMapping mapping = null;
        while (i < this.modeMappings.size() && !found) {
            mapping = (SystemFileTransferModeMapping)this.modeMappings.get(i);
            int result = newFileName.compareTo(mapping.getLabel().toUpperCase());
            if (result == 0) {
                MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)FileResources.FileEditorPreference_existsTitle, (String)FileResources.FileEditorPreference_existsMessage);
                this.resourceTypeTable.select(i);
                return;
            }
            if (result < 0) {
                found = true;
                continue;
            }
            ++i;
        }
        mapping = new SystemFileTransferModeMapping(newName, newExtension);
        if (this.defaultBinaryButton.getSelection()) {
            mapping.setAsBinary();
        } else {
            mapping.setAsText();
        }
        this.newResourceTableItem((ISystemFileTransferModeMapping)mapping, i, true);
        this.resourceTypeTable.setFocus();
    }

    private void doSuperTransferButtonSelected() {
        if (this.doSuperTransferButton.getSelection()) {
            this.archiveTypeCombo.setEnabled(true);
        } else {
            this.archiveTypeCombo.setEnabled(false);
        }
    }

    public void updateEnabledState() {
        boolean resourceTypeSelected = this.resourceTypeTable.getSelectionIndex() != -1;
        this.removeResourceTypeButton.setEnabled(resourceTypeSelected);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.resetResourceTypeTable();
        this.resetSuperTransferPrefs();
        this.resetBufferSizePrefs();
    }

    public boolean performOk() {
        super.performOk();
        if (this.modeMappings != null) {
            Object[] array1 = this.modeMappings.toArray();
            SystemFileTransferModeMapping[] mappingArray1 = new SystemFileTransferModeMapping[array1.length];
            int i = 0;
            while (i < array1.length) {
                mappingArray1[i] = (SystemFileTransferModeMapping)array1[i];
                ++i;
            }
            this.modeRegistry.setModeMappings(mappingArray1);
            this.modeRegistry.saveAssociations();
            int defaultFileTransferMode = 0;
            defaultFileTransferMode = this.defaultBinaryButton.getSelection() ? 0 : 1;
            UniversalPreferencePage.setFileTransferModeDefaultPreference(defaultFileTransferMode);
            UniversalPreferencePage.setDoSuperTransfer(this.doSuperTransferButton.getSelection());
            UniversalPreferencePage.setSuperTransferTypePreference(this.archiveTypeCombo.getText());
            UniversalPreferencePage.setDownloadBufferSize(this.downloadBufferSize.getText());
            UniversalPreferencePage.setUploadBufferSize(this.uploadBufferSize.getText());
        }
        return true;
    }

    public static int getFileTransferModeDefaultPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getInt("org.eclipse.rse.subsystems.files.core.preferences.filetransfermodedefault");
    }

    public static void setFileTransferModeDefaultPreference(int defaultMode) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.filetransfermodedefault", defaultMode);
        UniversalPreferencePage.savePreferenceStore();
    }

    public static String getSuperTransferTypePreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getString("org.eclipse.rse.subsystems.files.core.preferences.supertransfer.archivetype");
    }

    public static void setSuperTransferTypePreference(String type) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.supertransfer.archivetype", type);
        UniversalPreferencePage.savePreferenceStore();
    }

    public static boolean getDoSuperTransfer() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
    }

    public static int getDownloadBufferSize() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        int result = store.getInt("org.eclipse.rse.subsystems.files.core.preferences.download.buffer.size");
        if (result == 0) {
            result = 40;
        }
        return result;
    }

    public static int getUploadBufferSize() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        int result = store.getInt("org.eclipse.rse.subsystems.files.core.preferences.upload.buffer.size");
        if (result == 0) {
            result = 40;
        }
        return result;
    }

    public static void setDoSuperTransfer(boolean flag) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", flag);
        UniversalPreferencePage.savePreferenceStore();
    }

    public static void setDownloadBufferSize(String size) {
        UniversalPreferencePage.setDownloadBufferSize(Integer.parseInt(size));
    }

    public static void setUploadBufferSize(String size) {
        UniversalPreferencePage.setUploadBufferSize(Integer.parseInt(size));
    }

    public static void setDownloadBufferSize(int size) {
        if (size > 0) {
            IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.rse.subsystems.files.core.preferences.download.buffer.size", size);
            UniversalPreferencePage.savePreferenceStore();
        }
    }

    public static void setUploadBufferSize(int size) {
        if (size > 0) {
            IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.rse.subsystems.files.core.preferences.upload.buffer.size", size);
            UniversalPreferencePage.savePreferenceStore();
        }
    }

    private static void savePreferenceStore() {
        RSEUIPlugin.getDefault().savePluginPreferences();
    }

    public boolean canModify(Object element, String property) {
        if (property.equals(this.columnProperties[2])) {
            return true;
        }
        return property.equals(this.columnProperties[1]);
    }

    public Object getValue(Object element, String property) {
        SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)element;
        if (property.equals(this.columnProperties[2])) {
            return mapping.isBinary() ? new Integer(0) : new Integer(1);
        }
        if (property.equals(this.columnProperties[1])) {
            return mapping.getLabel();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)item.getData();
        if (mapping != null) {
            String nameExtension;
            int dotIndex;
            if (property.equals(this.columnProperties[2])) {
                if (value instanceof Integer) {
                    int index = (Integer)value;
                    if (index == 0) {
                        mapping.setAsBinary();
                        item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_BINARY_LABEL);
                    } else if (index == 1) {
                        mapping.setAsText();
                        item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_TEXT_LABEL);
                    } else if (index == 2) {
                        mapping.setAsXML();
                        item.setText(2, FileResources.RESID_PREF_UNIVERSAL_FILES_FILETYPES_MODE_XML_LABEL);
                    }
                    item.setImage(this.getImageFor((ISystemFileTransferModeMapping)mapping));
                }
            } else if (property.equals(this.columnProperties[1]) && value instanceof String && (dotIndex = (nameExtension = (String)value).lastIndexOf(46)) != -1) {
                String name = nameExtension.substring(0, dotIndex);
                String ext = nameExtension.substring(dotIndex + 1);
                mapping.setName(name);
                mapping.setExtension(ext);
                item.setText(1, nameExtension);
            }
        }
    }
}

