/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.SectionAxis;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.ChartPanelContentViewer;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.ChartPanelSelectionHandler;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.ModifiableTrace;
import org.eclipse.trace4cps.ui.view.EclipseDataItemFactory;
import org.eclipse.trace4cps.ui.view.EclipseToolTipGenerator;
import org.eclipse.trace4cps.vis.jfree.DataItemFactory;
import org.eclipse.trace4cps.vis.jfree.TracePlotManager;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYMeasureWithAnnotations;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.RangeAlign;

public class TraceViewer
extends ChartPanelContentViewer {
    private static final DecimalFormat FORMAT = new DecimalFormat(".###");
    private final TracePlotManager plotMgr;

    public TraceViewer(Composite parent) {
        super(parent);
        this.setPreserveSelection(true);
        this.plotMgr = new TracePlotManager(new ITrace[0]);
        this.plotMgr.setDataItemFactory((DataItemFactory)new EclipseDataItemFactory());
        this.plotMgr.setDelegateToolTipGenerator((XYToolTipGenerator)new EclipseToolTipGenerator(() -> ((TracePlotManager)this.plotMgr).getViewConfig()));
    }

    public TracePlotManager getPlotManager() {
        return this.plotMgr;
    }

    public ChartPanel getChartPanel() {
        return super.getChartPanelComposite().getChartPanel();
    }

    protected ChartPanelContentViewer.ChartPanelControlTuple createControl(Composite parent, int style, ChartPanelSelectionHandler.SelectionType selectionType) {
        ChartPanelContentViewer.ChartPanelControlTuple controlTuple = super.createControl(parent, style, selectionType);
        ChartPanel chartPanel = controlTuple.getChartPanelComposite().getChartPanel();
        XYMeasureWithAnnotations measurer = XYMeasureWithAnnotations.addToChartPanel((ChartPanel)chartPanel, (XYMeasureWithAnnotations.MeasurementAxis)XYMeasureWithAnnotations.MeasurementAxis.DOMAIN);
        measurer.setAnnotationLabelProvider((from, to) -> this.formatTimestamp(Math.abs(to.doubleValue() - from.doubleValue()), ((ModifiableTrace)this.plotMgr.getTraces().get(0)).getTimeUnit()));
        XYPlot xyPlot = new XYPlot();
        NumberAxis domainAxis = new NumberAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        domainAxis.setAutoRangeAlign(RangeAlign.LOWER);
        domainAxis.setRangeMinimumSize(1.0E-5);
        xyPlot.setDomainAxis((ValueAxis)domainAxis);
        SectionAxis rangeAxis = new SectionAxis();
        rangeAxis.setRangeMinimumSize(1.0);
        xyPlot.setRangeAxis((ValueAxis)rangeAxis);
        this.plotMgr.initializePlot(xyPlot);
        JFreeChart chart = new JFreeChart(null, null, (Plot)xyPlot, false);
        ChartFactory.getChartTheme().apply(chart);
        chartPanel.setChart(chart);
        return controlTuple;
    }

    protected XYPlot getXYPlot() {
        return (XYPlot)super.getPlot();
    }

    protected void refreshChart() {
        this.plotMgr.update(this.getXYPlot());
        ChartFactory.getChartTheme().apply(this.getChart());
    }

    public Range getRange() {
        return this.getXYPlot().getDomainAxis().getRange();
    }

    private String formatTimestamp(double value, TimeUnit tu) {
        if (1.0 <= value && value < 1000.0) {
            return " " + FORMAT.format(value) + " " + this.asString(tu) + " ";
        }
        if (value < 1.0) {
            return this.upscale(value, tu);
        }
        return this.downscale(value, tu);
    }

    private String upscale(double value, TimeUnit tu) {
        switch (tu) {
            case NANOSECONDS: {
                return String.valueOf(FORMAT.format(value)) + " " + this.asString(tu);
            }
            case MICROSECONDS: {
                return this.formatTimestamp(value * 1000.0, TimeUnit.NANOSECONDS);
            }
            case MILLISECONDS: {
                return this.formatTimestamp(value * 1000.0, TimeUnit.MICROSECONDS);
            }
            case SECONDS: {
                return this.formatTimestamp(value * 1000.0, TimeUnit.MILLISECONDS);
            }
            case MINUTES: {
                return this.formatTimestamp(value * 60.0, TimeUnit.SECONDS);
            }
            case HOURS: {
                return this.formatTimestamp(value * 60.0, TimeUnit.MINUTES);
            }
            case DAYS: {
                return this.formatTimestamp(value * 24.0, TimeUnit.HOURS);
            }
        }
        throw new IllegalStateException();
    }

    private String downscale(double value, TimeUnit tu) {
        switch (tu) {
            case NANOSECONDS: {
                return this.formatTimestamp(value / 1000.0, TimeUnit.MICROSECONDS);
            }
            case MICROSECONDS: {
                return this.formatTimestamp(value / 1000.0, TimeUnit.MILLISECONDS);
            }
            case MILLISECONDS: {
                return this.formatTimestamp(value / 1000.0, TimeUnit.SECONDS);
            }
            case SECONDS: {
                return this.formatTimestamp(value / 60.0, TimeUnit.MINUTES);
            }
            case MINUTES: {
                return this.formatTimestamp(value / 60.0, TimeUnit.HOURS);
            }
            case HOURS: {
                return this.formatTimestamp(value / 24.0, TimeUnit.DAYS);
            }
            case DAYS: {
                return String.valueOf(FORMAT.format(value)) + " " + this.asString(tu);
            }
        }
        throw new IllegalStateException();
    }

    private String asString(TimeUnit tu) {
        switch (tu) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hr";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new IllegalStateException();
    }
}

