/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AttributeUsageType {
    DESCRIBING(1, "Describing", "Describing"),
    LABELING(2, "Labeling", "Labeling"),
    FILTERING(3, "Filtering", "Filtering"),
    GROUPING(4, "Grouping", "Grouping"),
    COLORING(5, "Coloring", "Coloring");

    public static final int DESCRIBING_VALUE = 1;
    public static final int LABELING_VALUE = 2;
    public static final int FILTERING_VALUE = 3;
    public static final int GROUPING_VALUE = 4;
    public static final int COLORING_VALUE = 5;
    private static final AttributeUsageType[] VALUES_ARRAY;
    public static final List<AttributeUsageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeUsageType[]{DESCRIBING, LABELING, FILTERING, GROUPING, COLORING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeUsageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeUsageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeUsageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeUsageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeUsageType get(int value) {
        switch (value) {
            case 1: {
                return DESCRIBING;
            }
            case 2: {
                return LABELING;
            }
            case 3: {
                return FILTERING;
            }
            case 4: {
                return GROUPING;
            }
            case 5: {
                return COLORING;
            }
        }
        return null;
    }

    private AttributeUsageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

