/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;

public abstract class AbstractTraceViewAction
extends Action {
    private final String imgPath;
    final TraceView view;
    final TraceViewConfiguration viewCfg;

    AbstractTraceViewAction(TraceView view) {
        this(view, null);
    }

    AbstractTraceViewAction(TraceView view, String imgPath) {
        this.view = view;
        this.imgPath = imgPath;
        this.viewCfg = view.getViewConfiguration();
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imgPath != null) {
            return ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource(this.imgPath));
        }
        return super.getImageDescriptor();
    }

    public void run() {
        try {
            this.doRun();
        }
        catch (TraceException e) {
            Status status = new Status(4, ((Object)((Object)this)).getClass(), e.getMessage(), (Throwable)e);
            ErrorDialog.openError(null, (String)"Error", (String)"Failed to run action", (IStatus)status);
        }
    }

    protected abstract void doRun() throws TraceException;
}

