/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * generated by Xtext 2.22.0
 */
package org.eclipse.trace4cps.tl.etl.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.trace4cps.tl.etl.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.trace4cps.tl.etl.EtlPackage
 * @generated
 */
public class EtlAdapterFactory extends AdapterFactoryImpl
{
  /**
   * The cached model package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static EtlPackage modelPackage;

  /**
   * Creates an instance of the adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EtlAdapterFactory()
  {
    if (modelPackage == null)
    {
      modelPackage = EtlPackage.eINSTANCE;
    }
  }

  /**
   * Returns whether this factory is applicable for the type of the object.
   * <!-- begin-user-doc -->
   * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
   * <!-- end-user-doc -->
   * @return whether this factory is applicable for the type of the object.
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object object)
  {
    if (object == modelPackage)
    {
      return true;
    }
    if (object instanceof EObject)
    {
      return ((EObject)object).eClass().getEPackage() == modelPackage;
    }
    return false;
  }

  /**
   * The switch that delegates to the <code>createXXX</code> methods.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EtlSwitch<Adapter> modelSwitch =
    new EtlSwitch<Adapter>()
    {
      @Override
      public Adapter caseEtlModel(EtlModel object)
      {
        return createEtlModelAdapter();
      }
      @Override
      public Adapter caseTopLevelModelElement(TopLevelModelElement object)
      {
        return createTopLevelModelElementAdapter();
      }
      @Override
      public Adapter caseSignal(Signal object)
      {
        return createSignalAdapter();
      }
      @Override
      public Adapter caseConvSpec(ConvSpec object)
      {
        return createConvSpecAdapter();
      }
      @Override
      public Adapter caseFormula(Formula object)
      {
        return createFormulaAdapter();
      }
      @Override
      public Adapter caseStlAp(StlAp object)
      {
        return createStlApAdapter();
      }
      @Override
      public Adapter caseMtlAp(MtlAp object)
      {
        return createMtlApAdapter();
      }
      @Override
      public Adapter caseAttributeFilter(AttributeFilter object)
      {
        return createAttributeFilterAdapter();
      }
      @Override
      public Adapter caseKeyVal(KeyVal object)
      {
        return createKeyValAdapter();
      }
      @Override
      public Adapter caseIdString(IdString object)
      {
        return createIdStringAdapter();
      }
      @Override
      public Adapter caseInterval(Interval object)
      {
        return createIntervalAdapter();
      }
      @Override
      public Adapter caseIntervalSS(IntervalSS object)
      {
        return createIntervalSSAdapter();
      }
      @Override
      public Adapter caseIntervalSN(IntervalSN object)
      {
        return createIntervalSNAdapter();
      }
      @Override
      public Adapter caseIntervalNS(IntervalNS object)
      {
        return createIntervalNSAdapter();
      }
      @Override
      public Adapter caseIntervalNN(IntervalNN object)
      {
        return createIntervalNNAdapter();
      }
      @Override
      public Adapter caseSignalDef(SignalDef object)
      {
        return createSignalDefAdapter();
      }
      @Override
      public Adapter caseDef(Def object)
      {
        return createDefAdapter();
      }
      @Override
      public Adapter caseCheck(Check object)
      {
        return createCheckAdapter();
      }
      @Override
      public Adapter caseTraceSignal(TraceSignal object)
      {
        return createTraceSignalAdapter();
      }
      @Override
      public Adapter caseThroughputSignal(ThroughputSignal object)
      {
        return createThroughputSignalAdapter();
      }
      @Override
      public Adapter caseLatencySignal(LatencySignal object)
      {
        return createLatencySignalAdapter();
      }
      @Override
      public Adapter caseWipSignal(WipSignal object)
      {
        return createWipSignalAdapter();
      }
      @Override
      public Adapter caseResourceAmountSignal(ResourceAmountSignal object)
      {
        return createResourceAmountSignalAdapter();
      }
      @Override
      public Adapter caseResourceClientSignal(ResourceClientSignal object)
      {
        return createResourceClientSignalAdapter();
      }
      @Override
      public Adapter caseReferenceFormula(ReferenceFormula object)
      {
        return createReferenceFormulaAdapter();
      }
      @Override
      public Adapter caseApFormula(ApFormula object)
      {
        return createApFormulaAdapter();
      }
      @Override
      public Adapter caseNotFormula(NotFormula object)
      {
        return createNotFormulaAdapter();
      }
      @Override
      public Adapter caseAndOrFormula(AndOrFormula object)
      {
        return createAndOrFormulaAdapter();
      }
      @Override
      public Adapter caseIfThenFormula(IfThenFormula object)
      {
        return createIfThenFormulaAdapter();
      }
      @Override
      public Adapter caseGloballyUntimedFormula(GloballyUntimedFormula object)
      {
        return createGloballyUntimedFormulaAdapter();
      }
      @Override
      public Adapter caseGloballyFormula(GloballyFormula object)
      {
        return createGloballyFormulaAdapter();
      }
      @Override
      public Adapter caseFinallyUntimedFormula(FinallyUntimedFormula object)
      {
        return createFinallyUntimedFormulaAdapter();
      }
      @Override
      public Adapter caseFinallyFormula(FinallyFormula object)
      {
        return createFinallyFormulaAdapter();
      }
      @Override
      public Adapter caseUntilUntimedFormula(UntilUntimedFormula object)
      {
        return createUntilUntimedFormulaAdapter();
      }
      @Override
      public Adapter caseUntilFormula(UntilFormula object)
      {
        return createUntilFormulaAdapter();
      }
      @Override
      public Adapter caseStlApDeriv(StlApDeriv object)
      {
        return createStlApDerivAdapter();
      }
      @Override
      public Adapter caseMtlApStart(MtlApStart object)
      {
        return createMtlApStartAdapter();
      }
      @Override
      public Adapter caseMtlApEnd(MtlApEnd object)
      {
        return createMtlApEndAdapter();
      }
      @Override
      public Adapter defaultCase(EObject object)
      {
        return createEObjectAdapter();
      }
    };

  /**
   * Creates an adapter for the <code>target</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param target the object to adapt.
   * @return the adapter for the <code>target</code>.
   * @generated
   */
  @Override
  public Adapter createAdapter(Notifier target)
  {
    return modelSwitch.doSwitch((EObject)target);
  }


  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.EtlModel <em>Model</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.EtlModel
   * @generated
   */
  public Adapter createEtlModelAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.TopLevelModelElement <em>Top Level Model Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.TopLevelModelElement
   * @generated
   */
  public Adapter createTopLevelModelElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.Signal <em>Signal</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.Signal
   * @generated
   */
  public Adapter createSignalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.ConvSpec <em>Conv Spec</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.ConvSpec
   * @generated
   */
  public Adapter createConvSpecAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.Formula <em>Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.Formula
   * @generated
   */
  public Adapter createFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.StlAp <em>Stl Ap</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.StlAp
   * @generated
   */
  public Adapter createStlApAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.MtlAp <em>Mtl Ap</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.MtlAp
   * @generated
   */
  public Adapter createMtlApAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.AttributeFilter <em>Attribute Filter</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.AttributeFilter
   * @generated
   */
  public Adapter createAttributeFilterAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.KeyVal <em>Key Val</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.KeyVal
   * @generated
   */
  public Adapter createKeyValAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.IdString <em>Id String</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.IdString
   * @generated
   */
  public Adapter createIdStringAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.Interval <em>Interval</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.Interval
   * @generated
   */
  public Adapter createIntervalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.IntervalSS <em>Interval SS</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSS
   * @generated
   */
  public Adapter createIntervalSSAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.IntervalSN <em>Interval SN</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.IntervalSN
   * @generated
   */
  public Adapter createIntervalSNAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.IntervalNS <em>Interval NS</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNS
   * @generated
   */
  public Adapter createIntervalNSAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.IntervalNN <em>Interval NN</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.IntervalNN
   * @generated
   */
  public Adapter createIntervalNNAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.SignalDef <em>Signal Def</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.SignalDef
   * @generated
   */
  public Adapter createSignalDefAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.Def <em>Def</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.Def
   * @generated
   */
  public Adapter createDefAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.Check <em>Check</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.Check
   * @generated
   */
  public Adapter createCheckAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.TraceSignal <em>Trace Signal</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.TraceSignal
   * @generated
   */
  public Adapter createTraceSignalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.ThroughputSignal <em>Throughput Signal</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.ThroughputSignal
   * @generated
   */
  public Adapter createThroughputSignalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.LatencySignal <em>Latency Signal</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.LatencySignal
   * @generated
   */
  public Adapter createLatencySignalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.WipSignal <em>Wip Signal</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.WipSignal
   * @generated
   */
  public Adapter createWipSignalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.ResourceAmountSignal <em>Resource Amount Signal</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.ResourceAmountSignal
   * @generated
   */
  public Adapter createResourceAmountSignalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.ResourceClientSignal <em>Resource Client Signal</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.ResourceClientSignal
   * @generated
   */
  public Adapter createResourceClientSignalAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.ReferenceFormula <em>Reference Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.ReferenceFormula
   * @generated
   */
  public Adapter createReferenceFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.ApFormula <em>Ap Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.ApFormula
   * @generated
   */
  public Adapter createApFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.NotFormula <em>Not Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.NotFormula
   * @generated
   */
  public Adapter createNotFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.AndOrFormula <em>And Or Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.AndOrFormula
   * @generated
   */
  public Adapter createAndOrFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.IfThenFormula <em>If Then Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.IfThenFormula
   * @generated
   */
  public Adapter createIfThenFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula <em>Globally Untimed Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula
   * @generated
   */
  public Adapter createGloballyUntimedFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.GloballyFormula <em>Globally Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.GloballyFormula
   * @generated
   */
  public Adapter createGloballyFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula <em>Finally Untimed Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula
   * @generated
   */
  public Adapter createFinallyUntimedFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.FinallyFormula <em>Finally Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.FinallyFormula
   * @generated
   */
  public Adapter createFinallyFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.UntilUntimedFormula <em>Until Untimed Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.UntilUntimedFormula
   * @generated
   */
  public Adapter createUntilUntimedFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.UntilFormula <em>Until Formula</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.UntilFormula
   * @generated
   */
  public Adapter createUntilFormulaAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.StlApDeriv <em>Stl Ap Deriv</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.StlApDeriv
   * @generated
   */
  public Adapter createStlApDerivAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.MtlApStart <em>Mtl Ap Start</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.MtlApStart
   * @generated
   */
  public Adapter createMtlApStartAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.trace4cps.tl.etl.MtlApEnd <em>Mtl Ap End</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.trace4cps.tl.etl.MtlApEnd
   * @generated
   */
  public Adapter createMtlApEndAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for the default case.
   * <!-- begin-user-doc -->
   * This default implementation returns null.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @generated
   */
  public Adapter createEObjectAdapter()
  {
    return null;
  }

} //EtlAdapterFactory
