/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.analysis.core.weighted.tree;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;
import org.eclipse.tracecompass.incubator.internal.analysis.core.Activator;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.DefaultColorPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.SequentialPaletteProvider;

public class DifferentialPalette
implements IDataPalette {
    private static @Nullable DifferentialPalette fInstance = null;
    private static final int NB_COLORS = 5;
    private static final String NO_DIFF_STYLE = "equal";
    private static final String LESS_STYLES = "less";
    private static final String MORE_STYLES = "more";
    private static final Map<String, OutputElementStyle> STYLES;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private final int fMinThreshold;
    private final int fMaxThreshold;
    private final double fHeatStep;

    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)NO_DIFF_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)"No diff", (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)200, (int)200, (int)200), (Object)"opacity", (Object)Float.valueOf(1.0f))));
        IPaletteProvider palette = SequentialPaletteProvider.create((RGBAColor)DefaultColorPaletteProvider.GREEN, (int)6);
        int i = 0;
        for (RGBAColor color : palette.get()) {
            if (i == 0) {
                ++i;
                continue;
            }
            builder.put((Object)(LESS_STYLES + String.valueOf(i)), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(i), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()), (Object)"opacity", (Object)Float.valueOf((float)color.getAlpha() / 255.0f))));
            ++i;
        }
        palette = SequentialPaletteProvider.create((RGBAColor)DefaultColorPaletteProvider.RED, (int)6);
        i = 0;
        for (RGBAColor color : palette.get()) {
            if (i == 0) {
                ++i;
                continue;
            }
            builder.put((Object)(MORE_STYLES + String.valueOf(i)), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(i), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()), (Object)"opacity", (Object)Float.valueOf((float)color.getAlpha() / 255.0f))));
            ++i;
        }
        STYLES = builder.build();
    }

    public static DifferentialPalette create(int minThreshold, int maxThreshold) {
        if (minThreshold == maxThreshold) {
            Activator.getInstance().logWarning("Creating differential palette with wrong arguments: min threshold should be different from max threshold " + minThreshold);
            return new DifferentialPalette(minThreshold, minThreshold + 1);
        }
        return new DifferentialPalette(minThreshold, maxThreshold);
    }

    public static DifferentialPalette getInstance() {
        DifferentialPalette instance = fInstance;
        if (instance == null) {
            fInstance = instance = new DifferentialPalette();
        }
        return instance;
    }

    private DifferentialPalette() {
        this(0, 4);
    }

    private DifferentialPalette(int minThreshold, int maxThreshold) {
        this.fMinThreshold = Math.min(Math.abs(minThreshold), Math.abs(maxThreshold));
        this.fMaxThreshold = Math.max(Math.abs(minThreshold), Math.abs(maxThreshold));
        this.fHeatStep = (double)(this.fMaxThreshold - this.fMinThreshold) / 4.0;
    }

    @Override
    public OutputElementStyle getStyleFor(Object object) {
        if (object instanceof DifferentialWeightedTree) {
            DifferentialWeightedTree tree = (DifferentialWeightedTree)object;
            double difference = tree.getDifference();
            if (difference == Double.NaN) {
                return STYLE_MAP.computeIfAbsent("more5", styleStr -> new OutputElementStyle(styleStr));
            }
            double percent = Math.abs(difference) * 100.0;
            if (percent <= (double)this.fMinThreshold) {
                return STYLE_MAP.computeIfAbsent(NO_DIFF_STYLE, styleStr -> new OutputElementStyle(styleStr));
            }
            int diffHeat = 5;
            if (percent < (double)this.fMaxThreshold) {
                diffHeat = Math.min(5, Math.max(1, (int)((percent - (double)this.fMinThreshold) / this.fHeatStep) + 1));
            }
            return STYLE_MAP.computeIfAbsent(difference < 0.0 ? LESS_STYLES + diffHeat : MORE_STYLES + diffHeat, styleStr -> new OutputElementStyle(styleStr));
        }
        return STYLE_MAP.computeIfAbsent(NO_DIFF_STYLE, styleStr -> new OutputElementStyle(styleStr));
    }

    @Override
    public Map<String, OutputElementStyle> getStyles() {
        return STYLES;
    }
}

