/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.servlet.WebComponent;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.servlet.WebFilterConfig;
import org.glassfish.jersey.servlet.WebServletConfig;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ResponseWriter;
import org.glassfish.jersey.uri.UriComponent;

public class ServletContainer
extends HttpServlet
implements Filter,
Container {
    private static final long serialVersionUID = 3932047066686065219L;
    private static final ExtendedLogger LOGGER = new ExtendedLogger(Logger.getLogger(ServletContainer.class.getName()), Level.FINEST);
    private transient FilterConfig filterConfig;
    private transient WebComponent webComponent;
    private transient ResourceConfig resourceConfig;
    private transient Pattern staticContentPattern;
    private transient String filterContextPath;
    private volatile transient ContainerLifecycleListener containerListener;

    protected void init(WebConfig webConfig) throws ServletException {
        this.webComponent = new WebComponent(webConfig, this.resourceConfig);
        this.containerListener = this.webComponent.appHandler;
        this.containerListener.onStartup((Container)this);
    }

    public ServletContainer() {
    }

    public ServletContainer(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        this.service(request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URI requestUri;
        URI baseUri;
        UriBuilder absoluteUriBuilder;
        String servletPath = request.getServletPath();
        StringBuffer requestUrl = request.getRequestURL();
        String requestURI = request.getRequestURI();
        try {
            absoluteUriBuilder = UriBuilder.fromUri((String)requestUrl.toString());
        }
        catch (IllegalArgumentException iae) {
            this.setResponseForInvalidUri(response, iae);
            return;
        }
        String decodedBasePath = request.getContextPath() + servletPath + "/";
        String encodedBasePath = UriComponent.encode((String)decodedBasePath, (UriComponent.Type)UriComponent.Type.PATH);
        if (!decodedBasePath.equals(encodedBasePath)) {
            throw new ProcessingException("The servlet context path and/or the servlet path contain characters that are percent encoded");
        }
        try {
            baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
            String queryParameters = ContainerUtils.encodeUnsafeCharacters((String)request.getQueryString());
            if (queryParameters == null) {
                queryParameters = "";
            }
            requestUri = absoluteUriBuilder.replacePath(requestURI).replaceQuery(queryParameters).build(new Object[0]);
        }
        catch (IllegalArgumentException | UriBuilderException ex) {
            this.setResponseForInvalidUri(response, ex);
            return;
        }
        this.service(baseUri, requestUri, request, response);
    }

    private void setResponseForInvalidUri(HttpServletResponse response, Throwable throwable) throws IOException {
        LOGGER.log(Level.FINER, "Error while processing request.", throwable);
        Response.Status badRequest = Response.Status.BAD_REQUEST;
        if (this.webComponent.configSetStatusOverSendError) {
            response.reset();
            response.setStatus(badRequest.getStatusCode(), badRequest.getReasonPhrase());
        } else {
            response.sendError(badRequest.getStatusCode(), badRequest.getReasonPhrase());
        }
    }

    public void destroy() {
        super.destroy();
        ContainerLifecycleListener listener = this.containerListener;
        if (listener != null) {
            listener.onShutdown((Container)this);
        }
    }

    public void init() throws ServletException {
        this.init(new WebServletConfig(this));
    }

    public Value<Integer> service(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return this.webComponent.service(baseUri, requestUri, request, response);
    }

    private ResponseWriter serviceImpl(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return this.webComponent.serviceImpl(baseUri, requestUri, request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.init(new WebFilterConfig(filterConfig));
        String regex = (String)this.getConfiguration().getProperty("jersey.config.servlet.filter.staticContentRegex");
        if (regex != null && !regex.isEmpty()) {
            try {
                this.staticContentPattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                throw new ContainerException(LocalizationMessages.INIT_PARAM_REGEX_SYNTAX_INVALID(regex, "jersey.config.servlet.filter.staticContentRegex"), (Throwable)ex);
            }
        }
        this.filterContextPath = filterConfig.getInitParameter("jersey.config.servlet.filter.contextPath");
        if (this.filterContextPath != null) {
            if (this.filterContextPath.isEmpty()) {
                this.filterContextPath = null;
            } else {
                if (!this.filterContextPath.startsWith("/")) {
                    this.filterContextPath = '/' + this.filterContextPath;
                }
                if (this.filterContextPath.endsWith("/")) {
                    this.filterContextPath = this.filterContextPath.substring(0, this.filterContextPath.length() - 1);
                }
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response", (Throwable)e);
        }
    }

    public ServletContext getServletContext() {
        if (this.filterConfig != null) {
            return this.filterConfig.getServletContext();
        }
        return super.getServletContext();
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String includeRequestURI;
        if (request.getAttribute("javax.servlet.include.request_uri") != null && !(includeRequestURI = (String)request.getAttribute("javax.servlet.include.request_uri")).equals(request.getRequestURI())) {
            this.doFilter(request, response, chain, includeRequestURI, (String)request.getAttribute("javax.servlet.include.servlet_path"), (String)request.getAttribute("javax.servlet.include.query_string"));
            return;
        }
        String servletPath = request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        this.doFilter(request, response, chain, request.getRequestURI(), servletPath, request.getQueryString());
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String requestURI, String servletPath, String queryString) throws IOException, ServletException {
        URI requestUri;
        URI baseUri;
        Pattern p = this.getStaticContentPattern();
        if (p != null && p.matcher(servletPath).matches()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.filterContextPath != null && !servletPath.startsWith(this.filterContextPath)) {
            throw new ContainerException(LocalizationMessages.SERVLET_PATH_MISMATCH(servletPath, this.filterContextPath));
        }
        try {
            UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString());
            baseUri = this.filterContextPath == null ? absoluteUriBuilder.replacePath(request.getContextPath()).path("/").build(new Object[0]) : absoluteUriBuilder.replacePath(request.getContextPath()).path(this.filterContextPath).path("/").build(new Object[0]);
            requestUri = absoluteUriBuilder.replacePath(requestURI).replaceQuery(ContainerUtils.encodeUnsafeCharacters((String)queryString)).build(new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            this.setResponseForInvalidUri(response, iae);
            return;
        }
        ResponseWriter responseWriter = this.serviceImpl(baseUri, requestUri, request, response);
        if (this.webComponent.forwardOn404 && !response.isCommitted()) {
            boolean hasEntity = false;
            Response.StatusType status = null;
            if (responseWriter.responseContextResolved()) {
                ContainerResponse responseContext = responseWriter.getResponseContext();
                hasEntity = responseContext.hasEntity();
                status = responseContext.getStatusInfo();
            }
            if (!hasEntity && status == Response.Status.NOT_FOUND) {
                response.setStatus(200);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected Pattern getStaticContentPattern() {
        return this.staticContentPattern;
    }

    public ResourceConfig getConfiguration() {
        return this.webComponent.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        try {
            this.containerListener.onShutdown((Container)this);
            this.webComponent = new WebComponent(this.webComponent.webConfig, configuration);
            this.containerListener = this.webComponent.appHandler;
            this.containerListener.onReload((Container)this);
            this.containerListener.onStartup((Container)this);
        }
        catch (ServletException ex) {
            LOGGER.log(Level.SEVERE, "Reload failed", (Throwable)ex);
        }
    }

    public ApplicationHandler getApplicationHandler() {
        return this.webComponent.appHandler;
    }

    public WebComponent getWebComponent() {
        return this.webComponent;
    }
}

