/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2;

import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2.BaseMouseProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2.Messages;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IXYSeries;

public class SimpleTooltipProvider
extends BaseMouseProvider {
    private static final Format FORMAT = SubSecondTimeWithUnitFormat.getInstance();
    private static final String HTML_COLOR_TOOLTIP = "<span style=\"color:%s;\">%s</span>";
    private DensityToolTipHandler fToolTipHandler = null;

    @Override
    public TmfAbstractToolTipHandler getTooltipHandler() {
        DensityToolTipHandler toolTipHandler = this.fToolTipHandler;
        if (toolTipHandler == null) {
            this.fToolTipHandler = toolTipHandler = new DensityToolTipHandler();
        }
        return toolTipHandler;
    }

    public SimpleTooltipProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
    }

    private final class DensityToolTipHandler
    extends TmfAbstractToolTipHandler {
        private DensityToolTipHandler() {
        }

        public void fill(Control control, MouseEvent event, Point pt) {
            List<IXYSeries> seriesSet = SimpleTooltipProvider.this.getSeries();
            if (!seriesSet.isEmpty()) {
                if (event == null || SimpleTooltipProvider.this.getXAxis() == null || seriesSet.isEmpty()) {
                    return;
                }
                SimpleTooltipProvider.this.setToolTipText(null);
                long x1 = -1L;
                long x2 = -1L;
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<Long> yValues = new ArrayList<Long>();
                ArrayList<RGB> colors = new ArrayList<RGB>();
                for (IXYSeries ySeriesProvider : seriesSet) {
                    double[] xValues = ySeriesProvider.getXSeries();
                    if (xValues.length < 2) continue;
                    double delta = xValues[1] - xValues[0];
                    IAxis xAxis = SimpleTooltipProvider.this.getXAxis();
                    double coords = xAxis.getDataCoordinate(event.x);
                    int index = Arrays.binarySearch(xValues, coords);
                    if (index < 0) {
                        return;
                    }
                    double[] ySeries = ySeriesProvider.getYSeries();
                    long y = Math.round(ySeries[index]);
                    if (y <= 0L) continue;
                    x1 = (long)xValues[index];
                    x2 = (long)((double)x1 + delta);
                    String id = ySeriesProvider.getId();
                    colors.add(SimpleTooltipProvider.this.getDensityViewer().getColorForItem(id));
                    names.add(id);
                    yValues.add(y);
                }
                if (!names.isEmpty()) {
                    this.addItem(Messages.SimpleTooltipProvider_duration, String.valueOf(FORMAT.format(x1)) + '-' + FORMAT.format(x2));
                    if (seriesSet.size() == 1) {
                        this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString((String)String.valueOf(Messages.SimpleTooltipProvider_count)), TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)((Number)yValues.get(0))));
                    } else {
                        int i = 0;
                        while (i < names.size()) {
                            String id = (String)names.get(i);
                            RGB color = SimpleTooltipProvider.this.getDensityViewer().getColorForItem(id);
                            this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)String.format(SimpleTooltipProvider.HTML_COLOR_TOOLTIP, new RGBAColor(color.red, color.green, color.blue).toString(), id)), TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)((Number)yValues.get(i))));
                            ++i;
                        }
                    }
                }
            }
        }
    }
}

