/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.google.common.annotations.VisibleForTesting;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.Activator;

public class TraceServerConfiguration {
    public static final int TEST_PORT = 8378;
    protected static final String PROPERTY_HOST = "traceserver.host";
    protected static final String PROPERTY_PORT = "traceserver.port";
    private static final String PROPERTY_USESSL = "traceserver.useSSL";
    private static final String PROPERTY_KEYSTORE = "traceserver.keystore";
    private static final String PROPERTY_KEYSTORE_PASS = "traceserver.keystorepass";
    private static final int DEFAULT_HTTP_PORT = 8080;
    private static final int DEFAULT_SSL_PORT = 8443;
    private final int fPort;
    private final boolean fUseSSL;
    private final @Nullable String fKeystore;
    private final @Nullable String fKeystorePass;
    private final @Nullable String fHost;

    public static TraceServerConfiguration create() {
        String host;
        int port;
        boolean useSSL;
        String portStr = System.getProperty(PROPERTY_PORT);
        String usesslStr = System.getProperty(PROPERTY_USESSL);
        usesslStr = usesslStr == null || usesslStr.isEmpty() ? null : usesslStr;
        String keystore = System.getProperty(PROPERTY_KEYSTORE);
        keystore = keystore == null || keystore.isEmpty() ? null : keystore;
        String keystorePass = System.getProperty(PROPERTY_KEYSTORE_PASS);
        keystorePass = keystorePass == null || keystorePass.isEmpty() ? null : keystorePass;
        boolean bl = useSSL = usesslStr != null && !"false".equals(usesslStr);
        if (keystore != null && usesslStr == null) {
            useSSL = true;
        } else if (useSSL) {
            Activator.getInstance().logError(String.format("Server requested to use SSL, but no keystore specified. You must specify the keystore using the '%s' system property. Will use plain http instead.", PROPERTY_KEYSTORE));
            useSSL = false;
        }
        int n = port = useSSL ? 8443 : 8080;
        if (portStr != null && !portStr.isEmpty()) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException numberFormatException) {
                Activator.getInstance().logWarning(String.format("Invalid port specified: %s. Will use default port %d", portStr, port));
            }
        }
        if ((host = System.getProperty(PROPERTY_HOST)) != null && !host.isEmpty()) {
            return new TraceServerConfiguration(host, port, useSSL, keystore, keystorePass);
        }
        return new TraceServerConfiguration(port, useSSL, keystore, keystorePass);
    }

    @VisibleForTesting
    public TraceServerConfiguration(int port, boolean useSSL, @Nullable String keystore, @Nullable String keystorePass) {
        this(null, port, useSSL, keystore, keystorePass);
    }

    @VisibleForTesting
    public TraceServerConfiguration(String host, int port, boolean useSSL, @Nullable String keystore, @Nullable String keystorePass) {
        this.fHost = host;
        this.fPort = port;
        this.fUseSSL = useSSL;
        this.fKeystore = keystore;
        this.fKeystorePass = keystorePass;
    }

    public @Nullable String getHost() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    public boolean useSSL() {
        return this.fUseSSL;
    }

    public @Nullable String getKeystore() {
        return this.fKeystore;
    }

    public @Nullable String getKeystorePass() {
        return this.fKeystorePass;
    }
}

