/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header;

import org.apache.commons.lang3.ArrayUtils;

public enum BinaryFTraceDataType {
    UNKNOWN(0, null),
    CHAR(1, new String[]{"char", "s8", "u8"}),
    SHORT(2, new String[]{"short", "u16", "s16"}),
    INT(4, new String[]{"int", "s32", "u32", "pid_t", "uint32_t"}),
    LONG(8, new String[]{"long", "s64", "u64"});

    private final int fSize;
    private final String[] fTypeIdentifiers;

    private BinaryFTraceDataType(int size, String[] typeIdentifiers) {
        this.fSize = size;
        this.fTypeIdentifiers = typeIdentifiers;
    }

    public int getSize() {
        return this.fSize;
    }

    public static BinaryFTraceDataType getDataType(String typeIdentifier) {
        BinaryFTraceDataType[] binaryFTraceDataTypeArray = BinaryFTraceDataType.values();
        int n = binaryFTraceDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryFTraceDataType type = binaryFTraceDataTypeArray[n2];
            if (ArrayUtils.contains((Object[])type.fTypeIdentifiers, (Object)typeIdentifier)) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN;
    }
}

