/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.engine;

import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.engine.CSSEngineImpl;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTApplyStylesListener;
import org.eclipse.e4.ui.css.swt.properties.converters.CSSValueSWTColorConverterImpl;
import org.eclipse.e4.ui.css.swt.properties.converters.CSSValueSWTCursorConverterImpl;
import org.eclipse.e4.ui.css.swt.properties.converters.CSSValueSWTFontConverterImpl;
import org.eclipse.e4.ui.css.swt.properties.converters.CSSValueSWTFontDataConverterImpl;
import org.eclipse.e4.ui.css.swt.properties.converters.CSSValueSWTGradientConverterImpl;
import org.eclipse.e4.ui.css.swt.properties.converters.CSSValueSWTImageConverterImpl;
import org.eclipse.e4.ui.css.swt.properties.converters.CSSValueSWTRGBConverterImpl;
import org.eclipse.e4.ui.css.swt.resources.SWTResourceRegistryKeyFactory;
import org.eclipse.e4.ui.css.swt.resources.SWTResourcesRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;

public abstract class AbstractCSSSWTEngineImpl
extends CSSEngineImpl {
    protected Display display;

    public AbstractCSSSWTEngineImpl(Display display) {
        this(display, false);
    }

    public AbstractCSSSWTEngineImpl(Display display, boolean lazyApplyingStyles) {
        this.display = display;
        super.registerCSSValueConverter(CSSValueSWTRGBConverterImpl.INSTANCE);
        super.registerCSSValueConverter(CSSValueSWTColorConverterImpl.INSTANCE);
        super.registerCSSValueConverter(CSSValueSWTGradientConverterImpl.INSTANCE);
        super.registerCSSValueConverter(CSSValueSWTCursorConverterImpl.INSTANCE);
        super.registerCSSValueConverter(CSSValueSWTFontConverterImpl.INSTANCE);
        super.registerCSSValueConverter(CSSValueSWTFontDataConverterImpl.INSTANCE);
        super.registerCSSValueConverter(CSSValueSWTImageConverterImpl.INSTANCE);
        if (lazyApplyingStyles) {
            new CSSSWTApplyStylesListener(display, (CSSEngine)this);
        }
        this.initializeCSSElementProvider();
        this.initializeCSSPropertyHandlers();
        this.setResourceRegistryKeyFactory(new SWTResourceRegistryKeyFactory());
    }

    protected abstract void initializeCSSPropertyHandlers();

    protected abstract void initializeCSSElementProvider();

    public IResourcesRegistry getResourcesRegistry() {
        IResourcesRegistry resourcesRegistry = super.getResourcesRegistry();
        if (resourcesRegistry == null) {
            super.setResourcesRegistry((IResourcesRegistry)new SWTResourcesRegistry(this.display));
        }
        return super.getResourcesRegistry();
    }

    public Element getElement(Object element) {
        if (element instanceof CSSStylableElement && ((CSSStylableElement)element).getNativeWidget() instanceof Widget) {
            return (CSSStylableElement)element;
        }
        if (element instanceof Widget) {
            if (this.isStylable((Widget)element)) {
                return super.getElement(element);
            }
        } else {
            return super.getElement(element);
        }
        return null;
    }

    protected boolean isStylable(Widget widget) {
        return !Boolean.TRUE.equals(widget.getData("org.eclipse.e4.ui.css.disabled"));
    }

    public void reset() {
        for (CSSElementContext elementContext : this.getElementsContext().values()) {
            Element element = elementContext.getElement();
            if (!(element instanceof WidgetElement) || !this.isApplicableToReset((WidgetElement)((Object)element))) continue;
            ((WidgetElement)((Object)element)).reset();
        }
        this.getResourcesRegistry().dispose();
        super.reset();
    }

    private boolean isApplicableToReset(WidgetElement element) {
        if (element.getNativeWidget() instanceof Widget) {
            return !((Widget)element.getNativeWidget()).isDisposed();
        }
        return false;
    }
}

