/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.views.messageflow;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModelType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2TakeInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class Ros2MessageFlowPresentationProvider
extends TimeGraphPresentationProvider {
    private static final int NUM_STATES_NON_COLORS = 3;
    private static final int NUM_STATES_COLORS = 360;
    private static final StateItem[] STATE_TABLE;
    private static final IPaletteProvider PALETTE;
    private static final HashFunction fHasher;
    protected final LoadingCache<NamedTimeEvent, Optional<String>> fTimeEventNames = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<NamedTimeEvent, Optional<String>>(){

        public Optional<String> load(NamedTimeEvent event) {
            return Optional.ofNullable(event.getLabel());
        }
    });

    static {
        PALETTE = new RotatingPaletteProvider.Builder().setNbColors(360).build();
        fHasher = Hashing.sha512();
        STATE_TABLE = new StateItem[1083];
        Ros2MessageFlowPresentationProvider.STATE_TABLE[0] = new StateItem(State.ARROW_TRANSPORT.rgb, State.ARROW_TRANSPORT.toString());
        Ros2MessageFlowPresentationProvider.STATE_TABLE[1] = new StateItem(State.ARROW_CALLBACK_PUB.rgb, State.ARROW_CALLBACK_PUB.toString());
        Ros2MessageFlowPresentationProvider.STATE_TABLE[2] = new StateItem(State.ARROW_WAIT.rgb, State.ARROW_WAIT.toString());
        int i = 0;
        for (RGBAColor color : PALETTE.get()) {
            Ros2MessageFlowPresentationProvider.STATE_TABLE[3 + i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, color.toString());
            Ros2MessageFlowPresentationProvider.STATE_TABLE[363 + i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, color.toString());
            STATE_TABLE[363 + i].getStyleMap().put("height", Float.valueOf(0.7f));
            Ros2MessageFlowPresentationProvider.STATE_TABLE[723 + i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, color.toString());
            STATE_TABLE[723 + i].getStyleMap().put("height", Float.valueOf(0.4f));
            ++i;
        }
    }

    public Ros2MessageFlowPresentationProvider() {
        super("");
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(ITimeEvent event) {
        TimeGraphEntry entry;
        ITmfTreeDataModel model;
        if (event instanceof TimeEvent) {
            TimeEvent timeEvent = (TimeEvent)event;
            if (timeEvent.getValue() == Ros2MessagesDataProvider.ArrowType.TRANSPORT.getId()) {
                return State.ARROW_TRANSPORT.ordinal();
            }
            if (timeEvent.getValue() == Ros2MessagesDataProvider.ArrowType.CALLBACK_PUB.getId()) {
                return State.ARROW_CALLBACK_PUB.ordinal();
            }
            if (timeEvent.getValue() == Ros2MessagesDataProvider.ArrowType.WAIT.getId()) {
                return State.ARROW_WAIT.ordinal();
            }
        }
        if (event instanceof NamedTimeEvent && (model = (entry = (TimeGraphEntry)event.getEntry()).getEntryModel()) instanceof Ros2ObjectTimeGraphEntryModel) {
            return Ros2MessageFlowPresentationProvider.getObjectEntryModelIndex(event, model);
        }
        return -1;
    }

    private static int getObjectEntryModelIndex(ITimeEvent event, ITmfTreeDataModel model) {
        NamedTimeEvent namedEvent = (NamedTimeEvent)event;
        long hash = namedEvent.getLabel().hashCode();
        Ros2ObjectTimeGraphEntryModel messagesModel = (Ros2ObjectTimeGraphEntryModel)model;
        Ros2ObjectTimeGraphEntryModelType type = messagesModel.getType();
        boolean isTakeState = false;
        boolean isNodeState = false;
        if (Ros2ObjectTimeGraphEntryModelType.NODE == type) {
            Ros2NodeObject nodeObject = (Ros2NodeObject)messagesModel.getObject();
            hash = fHasher.hashUnencodedChars((CharSequence)nodeObject.getNodeName()).asLong();
            isNodeState = true;
        } else if (Ros2ObjectTimeGraphEntryModelType.PUBLISHER == type) {
            Ros2PublisherObject publisherObject = (Ros2PublisherObject)messagesModel.getObject();
            hash = fHasher.hashUnencodedChars((CharSequence)publisherObject.getTopicName()).asLong();
        } else if (Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION == type) {
            Ros2SubscriptionObject subscriptionObject = (Ros2SubscriptionObject)messagesModel.getObject();
            hash = fHasher.hashUnencodedChars((CharSequence)subscriptionObject.getTopicName()).asLong();
            Iterator<@NonNull E> stateDataIterator = event.getMetadata().get((Object)"data").iterator();
            isTakeState = stateDataIterator.hasNext() && stateDataIterator.next() instanceof Ros2TakeInstance;
        } else if (Ros2ObjectTimeGraphEntryModelType.TIMER == type) {
            Ros2TimerObject timerObject = (Ros2TimerObject)messagesModel.getObject();
            hash = fHasher.hashUnencodedChars((CharSequence)Long.toString(timerObject.getPeriod())).asLong();
        }
        int hashFloor = Math.floorMod(hash, PALETTE.get().size());
        int stateTypeOffset = isTakeState || isNodeState ? (isNodeState ? 2 : 1) * 360 : 0;
        return 3 + hashFloor + stateTypeOffset;
    }

    public @Nullable String getEventName(ITimeEvent event) {
        ITimeGraphEntry entry = event.getEntry();
        if (!(entry instanceof TimeGraphEntry)) {
            return null;
        }
        ITmfTreeDataModel model = ((TimeGraphEntry)entry).getEntryModel();
        if (!(model instanceof Ros2ObjectTimeGraphEntryModel)) {
            return null;
        }
        Ros2ObjectTimeGraphEntryModel messagesModel = (Ros2ObjectTimeGraphEntryModel)model;
        Ros2ObjectTimeGraphEntryModelType type = messagesModel.getType();
        if (Ros2ObjectTimeGraphEntryModelType.NODE == type) {
            return "node lifetime";
        }
        if (Ros2ObjectTimeGraphEntryModelType.PUBLISHER == type) {
            return "message publication";
        }
        if (Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION == type) {
            return "subscription callback/take";
        }
        if (Ros2ObjectTimeGraphEntryModelType.TIMER == type) {
            return "timer callback";
        }
        return null;
    }

    public String getStateTypeName(ITimeGraphEntry entry) {
        if (!(entry instanceof TimeGraphEntry)) {
            return null;
        }
        ITmfTreeDataModel model = ((TimeGraphEntry)entry).getEntryModel();
        if (!(model instanceof Ros2ObjectTimeGraphEntryModel)) {
            return null;
        }
        Ros2ObjectTimeGraphEntryModel messagesModel = (Ros2ObjectTimeGraphEntryModel)model;
        Ros2ObjectTimeGraphEntryModelType type = messagesModel.getType();
        if (Ros2ObjectTimeGraphEntryModelType.NODE == type) {
            return "Node name";
        }
        if (Ros2ObjectTimeGraphEntryModelType.PUBLISHER == type) {
            return "Publisher topic";
        }
        if (Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION == type) {
            return "Subscription topic";
        }
        if (Ros2ObjectTimeGraphEntryModelType.TIMER == type) {
            return "Timer period";
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        ITimeGraphEntry entry = event.getEntry();
        if (!(entry instanceof TimeGraphEntry)) {
            return builder.build();
        }
        ITmfTreeDataModel model = ((TimeGraphEntry)entry).getEntryModel();
        if (!(model instanceof Ros2ObjectTimeGraphEntryModel)) {
            return builder.build();
        }
        @NonNull @NonNull Multimap metadata = event.getMetadata();
        Ros2ObjectTimeGraphEntryModel messagesModel = (Ros2ObjectTimeGraphEntryModel)model;
        Ros2ObjectTimeGraphEntryModelType type = messagesModel.getType();
        if (Ros2ObjectTimeGraphEntryModelType.NODE == type) {
            Ros2NodeObject nodeObject = (Ros2NodeObject)metadata.get((Object)"data").iterator().next();
            builder.put((Object)"PID", (Object)Long.toString(((Ros2ObjectHandle)nodeObject.getHandle()).getPid()));
        } else if (Ros2ObjectTimeGraphEntryModelType.PUBLISHER == type) {
            Ros2PubInstance pub = (Ros2PubInstance)metadata.get((Object)"data").iterator().next();
            builder.put((Object)"Message pointer", (Object)Ros2MessageFlowPresentationProvider.toHex(pub.getMessage().getPointer()));
            builder.put((Object)"Source timestamp", (Object)FormatTimeUtils.formatTimeAbs((long)pub.getSourceTimestamp(), (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
            builder.put((Object)"PID", (Object)Long.toString(pub.getPublisherHandle().getPid()));
            builder.put((Object)"TID", (Object)Long.toString(pub.getTid()));
        } else if (Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION == type) {
            Object takeOrCallback = metadata.get((Object)"data").iterator().next();
            if (takeOrCallback instanceof Ros2TakeInstance) {
                Ros2TakeInstance take = (Ros2TakeInstance)takeOrCallback;
                builder.put((Object)"Message pointer", (Object)Ros2MessageFlowPresentationProvider.toHex(take.getMessage().getPointer()));
                builder.put((Object)"Source timestamp", (Object)FormatTimeUtils.formatTimeAbs((long)take.getSourceTimestamp(), (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
                builder.put((Object)"PID", (Object)Long.toString(take.getSubscriptionHandle().getPid()));
                builder.put((Object)"TID", (Object)Long.toString(take.getTid()));
            } else if (takeOrCallback instanceof Ros2CallbackInstance) {
                Ros2CallbackInstance callback = (Ros2CallbackInstance)takeOrCallback;
                builder.put((Object)"Intra-process", (Object)Boolean.toString(callback.isIntraProcess()));
                builder.put((Object)"PID", (Object)Long.toString(callback.getOwnerHandle().getPid()));
                builder.put((Object)"TID", (Object)Long.toString(callback.getTid()));
            }
        } else if (Ros2ObjectTimeGraphEntryModelType.TIMER == type) {
            Ros2CallbackInstance callback = (Ros2CallbackInstance)metadata.get((Object)"data").iterator().next();
            builder.put((Object)"Intra-process", (Object)Boolean.toString(callback.isIntraProcess()));
            builder.put((Object)"PID", (Object)Long.toString(callback.getOwnerHandle().getPid()));
            builder.put((Object)"TID", (Object)Long.toString(callback.getTid()));
        }
        return builder.build();
    }

    private static String toHex(long handle) {
        return "0x" + Long.toHexString(handle);
    }

    private static enum State {
        ARROW_TRANSPORT(new RGB(38, 38, 38)),
        ARROW_CALLBACK_PUB(new RGB(128, 128, 128)),
        ARROW_WAIT(new RGB(128, 1, 1));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

