/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.ui.view.spanlife;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife.SpanLifeEntryModel;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.view.spanlife.SpanMarkerEvent;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class SpanLifePresentationProvider
extends TimeGraphPresentationProvider {
    private static final @NonNull String ERROR = "error";
    private static final @NonNull String EVENT = "event";
    private static final @NonNull String MESSAGE = "message";
    private static final @NonNull String STACK = "stack";
    private static final @NonNull String OTHER = "other";
    private static final @NonNull String FLAG_EMOJI = "\ud83c\udff3\ufe0f";
    private static final @NonNull String MARKER_HEX_COLOR = X11ColorUtils.toHexColor((int)200, (int)0, (int)0);
    private static double OPACITY = 0.5882352941176471;
    private static final StateItem[] STATE_TABLE = new StateItem[]{new StateItem(new RGB(179, 205, 224), "Fist Service Class"), new StateItem(new RGB(100, 151, 177), "Second Service Class"), new StateItem(new RGB(0, 91, 150), "Third Service Class"), new StateItem(new RGB(3, 57, 108), "Forth Service Class"), new StateItem(new RGB(1, 31, 75), "Fifth Service Class"), new StateItem((Map)ImmutableMap.of((Object)"style-name", (Object)"error", (Object)"background-color", (Object)MARKER_HEX_COLOR, (Object)"opacity", (Object)OPACITY, (Object)"symbol-type", (Object)"cross", (Object)"height", (Object)Float.valueOf(0.4f))), new StateItem((Map)ImmutableMap.of((Object)"style-name", (Object)"event", (Object)"background-color", (Object)MARKER_HEX_COLOR, (Object)"opacity", (Object)OPACITY, (Object)"symbol-type", (Object)"diamond", (Object)"height", (Object)Float.valueOf(0.3f))), new StateItem((Map)ImmutableMap.of((Object)"style-name", (Object)"message", (Object)"background-color", (Object)MARKER_HEX_COLOR, (Object)"opacity", (Object)OPACITY, (Object)"symbol-type", (Object)"circle", (Object)"height", (Object)Float.valueOf(0.3f))), new StateItem((Map)ImmutableMap.of((Object)"style-name", (Object)"stack", (Object)"background-color", (Object)MARKER_HEX_COLOR, (Object)"opacity", (Object)OPACITY, (Object)"symbol-type", (Object)"square", (Object)"height", (Object)Float.valueOf(0.3f))), new StateItem((Map)ImmutableMap.of((Object)"style-name", (Object)"other", (Object)"background-color", (Object)MARKER_HEX_COLOR, (Object)"opacity", (Object)OPACITY, (Object)"symbol-type", (Object)"\ud83c\udff3\ufe0f", (Object)"height", (Object)Float.valueOf(0.3f)))};

    public SpanLifePresentationProvider() {
        super("Span");
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        ITimeGraphEntry entry;
        LinkedHashMap<String, String> eventHoverToolTipInfo = super.getEventHoverToolTipInfo(event);
        if (eventHoverToolTipInfo == null) {
            eventHoverToolTipInfo = new LinkedHashMap<String, String>();
        }
        if ((entry = event.getEntry()) instanceof TimeGraphEntry) {
            long id = ((TimeGraphEntry)entry).getEntryModel().getId();
            ITimeGraphDataProvider provider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)((TimeGraphEntry)entry));
            ArrayList<@NonNull Long> times = new ArrayList<Long>();
            times.add(event.getTime());
            SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(times, Collections.singleton(id));
            @NonNull @NonNull @NonNull TmfModelResponse tooltipResponse = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter), (IProgressMonitor)new NullProgressMonitor());
            @NonNull @NonNull Map tooltipModel = (Map)tooltipResponse.getModel();
            if (tooltipModel != null) {
                eventHoverToolTipInfo.putAll(tooltipModel);
            }
        }
        return eventHoverToolTipInfo;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        block18: {
            String type;
            if (!(event instanceof SpanMarkerEvent)) break block18;
            SpanMarkerEvent markerEvent = (SpanMarkerEvent)event;
            switch (type = markerEvent.getType()) {
                case "error": {
                    return 5;
                }
                case "event": {
                    return 6;
                }
                case "message": {
                    return 7;
                }
                case "stack": {
                    return 8;
                }
            }
            return 9;
        }
        if (event instanceof TimeEvent && ((TimeEvent)event).getValue() != Integer.MIN_VALUE) {
            if (event.getEntry() instanceof TimeGraphEntry && ((TimeGraphEntry)event.getEntry()).getEntryModel() instanceof SpanLifeEntryModel) {
                String processName = ((SpanLifeEntryModel)((TimeGraphEntry)event.getEntry()).getEntryModel()).getProcessName();
                return Math.abs(Objects.hash(processName)) % 5;
            }
            return 0;
        }
        return -1;
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        OutputElementStyle style;
        ITimeElement model;
        if (event instanceof MarkerEvent && (model = ((MarkerEvent)event).getModel()) != null && (style = model.getStyle()) != null) {
            return style.getStyleValues();
        }
        return super.getSpecificEventStyle(event);
    }
}

