/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search.federated;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;

public class IndexerJob
extends Job {
    public static final String FAMILY = "org.eclipse.help.base.indexer";

    public IndexerJob() {
        super(HelpBaseResources.IndexerJob_name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SearchIndexWithIndexingProgress index = BaseHelpSystem.getLocalSearchManager().getIndex(Platform.getNL());
        try {
            long start = System.currentTimeMillis();
            if (HelpPlugin.DEBUG_SEARCH) {
                System.out.println("Start to update search index");
            }
            BaseHelpSystem.getLocalSearchManager().ensureIndexUpdated(monitor, index);
            long stop = System.currentTimeMillis();
            if (HelpPlugin.DEBUG_SEARCH) {
                System.out.println("Milliseconds to update search index =  = " + (stop - start));
            }
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.help.base", 0, HelpBaseResources.IndexerJob_error, (Throwable)e);
        }
    }

    public boolean belongsTo(Object family) {
        return FAMILY.equals(family);
    }
}

