/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.IMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph.TimeEventFilterDialog;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.IFilterStrings;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.util.TimeGraphStyleUtil;
import org.eclipse.tracecompass.tmf.core.model.timegraph.IElementResolver;
import org.eclipse.tracecompass.tmf.core.signal.TmfDataModelSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfMarkerEventSourceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphEntryComparator;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphLegendProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphBookmarkListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphBookmarkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class AbstractTimeGraphMultiViewer
extends TmfViewer
implements IMultiViewer,
IResourceChangeListener {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(AbstractTimeGraphMultiViewer.class);
    private static final String TIMEGRAPH_UI_CONTEXT = "org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph.context";
    private static final String TMF_VIEW_UI_CONTEXT = "org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.context";
    private static final String DIRTY_UNDERFLOW_ERROR = "Dirty underflow error";
    private static final int DEFAULT_BUFFER_SIZE = 3;
    private static final Pattern RGBA_PATTERN = Pattern.compile("RGBA \\{(\\d+), (\\d+), (\\d+), (\\d+)\\}");
    protected static final int ALL_LEVELS = -1;
    private final String fName;
    private TimeGraphViewer fTimeGraphViewer;
    private ITableLabelProvider fLabelProvider = new TreeLabelProvider();
    private @NonNull ITimeGraphContentProvider fTimeGraphContentProvider = new TimeGraphContentProvider();
    private int[] fWeight = new int[]{1, 3};
    private String[] fFilterColumns;
    private ITreeContentProvider fFilterContentProvider;
    private TreeLabelProvider fFilterLabelProvider;
    private ITimeGraphLegendProvider fLegendProvider;
    private int fAutoExpandLevel = -1;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private final ITimeGraphPresentationProvider fPresentation;
    private String[] fColumns;
    private Comparator<ITimeGraphEntry>[] fColumnComparators;
    private int fInitialSortColumn = 0;
    private int fCurrentSortColumn = 0;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Utils.TimeFormat fTimeFormat = null;
    private int fSortDirection = 1024;
    private int fPrevTimeSpace = -1;
    private @NonNull Set<@NonNull TimeGraphEntry> fVisibleEntries = Collections.emptySet();
    private volatile boolean fIsRevealSelection = false;
    private Comparator<ITimeGraphEntry> fEntryComparator = null;
    private AtomicInteger fDirty = new AtomicInteger();
    private final Object fZoomThreadResultLock = new Object();
    private ITmfTrace fTrace;
    private @Nullable IFile fEditorFile;
    private List<TimeGraphEntry> fEntryList;
    private final Map<ITmfTrace, List<@NonNull TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private final Map<ITmfTrace, @NonNull ViewerFilter[]> fFiltersMap = new HashMap<ITmfTrace, ViewerFilter[]>();
    private final Map<ITmfTrace, ViewerContext> fViewerContext = new HashMap<ITmfTrace, ViewerContext>();
    private final Map<ITmfTrace, List<IMarkerEventSource>> fMarkerEventSourcesMap = new HashMap<ITmfTrace, List<IMarkerEventSource>>();
    private final Map<ITmfTrace, Job> fBuildJobMap = new HashMap<ITmfTrace, Job>();
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private final int fDisplayWidth;
    private ZoomThread fZoomThread;
    private Action fTimeEventFilterAction;
    private TimeEventFilterDialog fTimeEventFilterDialog;
    private final IWorkbenchPartSite fSite;
    private TimeGraphPartListener fPartListener;
    private TimeGraphPartListener2 fPartListener2;
    private IContextService fContextService;
    private List<IContextActivation> fActiveContexts = new ArrayList<IContextActivation>();
    private final @NonNull MenuManager fEntryMenuManager = new MenuManager();
    private static final ShowFindDialogAction FIND_ACTION = new ShowFindDialogAction();
    private ActionHandler fFindActionHandler;
    private IHandlerActivation fFindHandlerActivation;
    private final ITimeGraphSelectionListener fMetadataSelectionListener = event -> {
        Multimap metadata;
        ITimeGraphEntry entry = event.getSelection();
        if (entry instanceof IElementResolver && !(metadata = ((IElementResolver)entry).getMetadata()).isEmpty()) {
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfDataModelSelectedSignal((Object)this, metadata));
        }
    };
    public static final @NonNull String ID = "org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.MultiTimeGraphViewer";

    public AbstractTimeGraphMultiViewer(Composite parent, ITimeGraphPresentationProvider pres, IWorkbenchPartSite site) {
        super(parent);
        this.fPresentation = pres;
        this.fSite = site;
        this.fName = AbstractTimeGraphMultiViewer.class.getSimpleName();
        this.fDisplayWidth = Display.getDefault().getBounds().width;
        TimeGraphViewer timeGraphViewer = new TimeGraphViewer(parent, 0);
        timeGraphViewer.setTimeGraphScaleVisible(false);
        timeGraphViewer.setMarkerAxisControlVisible(false);
        timeGraphViewer.setHorizontalScrollBarVisible(false);
        this.fTimeGraphViewer = timeGraphViewer;
        this.setFilterColumns(new String[]{"Name"});
        this.setFilterLabelProvider(new TreeLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return this.getText(element);
                }
                return "";
            }
        });
    }

    public void init() {
        ITmfTrace trace;
        Action timeEventFilterAction;
        if (this.fLabelProvider != null) {
            this.fTimeGraphViewer.setTimeGraphLabelProvider(this.fLabelProvider);
        }
        if (this.fLegendProvider != null) {
            this.fTimeGraphViewer.setLegendProvider(this.fLegendProvider);
        }
        if (this.fColumns != null) {
            this.fTimeGraphViewer.setColumns(this.fColumns);
            if (this.fColumnComparators != null) {
                this.createColumnSelectionListener(this.fTimeGraphViewer.getTree());
            }
        }
        this.fTimeGraphViewer.setTimeGraphContentProvider(this.fTimeGraphContentProvider);
        this.fTimeGraphViewer.setFilterContentProvider((ITreeContentProvider)(this.fFilterContentProvider != null ? this.fFilterContentProvider : this.fTimeGraphContentProvider));
        this.fTimeGraphViewer.setFilterLabelProvider((ITableLabelProvider)this.fFilterLabelProvider);
        this.fTimeGraphViewer.setFilterColumns(this.fFilterColumns);
        this.fTimeGraphViewer.addSelectionListener(this.fMetadataSelectionListener);
        ITimeGraphPresentationProvider presentationProvider = this.getPresentationProvider();
        this.fTimeGraphViewer.setTimeGraphProvider(presentationProvider);
        presentationProvider.addColorListener(stateItems -> TimeGraphStyleUtil.loadValues((ITimeGraphPresentationProvider)this.getPresentationProvider()));
        presentationProvider.refresh();
        this.fTimeGraphViewer.setAutoExpandLevel(this.fAutoExpandLevel);
        this.fTimeGraphViewer.setWeights(this.fWeight);
        final TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        this.fTimeEventFilterAction = timeEventFilterAction = new Action(){

            public void run() {
                int xCoord = timeGraphControl.toControl((Point)timeGraphControl.getDisplay().getCursorLocation()).x;
                if (AbstractTimeGraphMultiViewer.this.fTimeGraphViewer.getNameSpace() < xCoord && xCoord < timeGraphControl.getSize().x) {
                    if (AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog != null) {
                        AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog.close();
                        AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog = null;
                    }
                    AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog = new TimeEventFilterDialog(timeGraphControl.getShell(), AbstractTimeGraphMultiViewer.this, AbstractTimeGraphMultiViewer.this.getTimeGraphViewer().getTimeGraphControl());
                    AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog.open();
                }
            }
        };
        this.fTimeGraphViewer.addRangeListener(event -> {
            long startTime = event.getStartTime();
            long endTime = event.getEndTime();
            TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range, this.fTrace));
            this.startZoomThread(startTime, endTime);
        });
        this.fTimeGraphViewer.addTimeListener(event -> {
            ITmfTimestamp startTime = TmfTimestamp.fromNanos((long)event.getBeginTime());
            ITmfTimestamp endTime = TmfTimestamp.fromNanos((long)event.getEndTime());
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, startTime, endTime, this.fTrace));
        });
        this.fTimeGraphViewer.addBookmarkListener(new ITimeGraphBookmarkListener(){

            public void bookmarkAdded(final TimeGraphBookmarkEvent event) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IMarkerEvent bookmark = event.getBookmark();
                            IFile editorFile = (this).AbstractTimeGraphMultiViewer.this.fEditorFile;
                            if (editorFile == null) {
                                return;
                            }
                            IMarker marker = editorFile.createMarker("org.eclipse.core.resources.bookmark");
                            marker.setAttribute("message", (Object)bookmark.getLabel());
                            marker.setAttribute("time", (Object)Long.toString(bookmark.getTime()));
                            if (bookmark.getDuration() > 0L) {
                                marker.setAttribute("duration", (Object)Long.toString(bookmark.getDuration()));
                                marker.setAttribute("location", (Object)NLS.bind((String)Messages.TmfMarker_LocationTimeRange, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime()), (Object)TmfTimestamp.fromNanos((long)(bookmark.getTime() + bookmark.getDuration()))));
                            } else {
                                marker.setAttribute("location", (Object)NLS.bind((String)Messages.TmfMarker_LocationTime, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime())));
                            }
                            marker.setAttribute("color", (Object)bookmark.getColor().toString());
                        }
                    }, null);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }

            public void bookmarkRemoved(TimeGraphBookmarkEvent event) {
                try {
                    IMarker[] markers;
                    IMarkerEvent bookmark = event.getBookmark();
                    IFile editorFile = AbstractTimeGraphMultiViewer.this.fEditorFile;
                    if (editorFile == null) {
                        return;
                    }
                    IMarker[] iMarkerArray = markers = editorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        if (bookmark.getLabel().equals(marker.getAttribute("message")) && Long.toString(bookmark.getTime()).equals(marker.getAttribute("time", null)) && Long.toString(bookmark.getDuration()).equals(marker.getAttribute("duration", Long.toString(0L))) && bookmark.getColor().toString().equals(marker.getAttribute("color"))) {
                            marker.delete();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }
        });
        timeGraphControl.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TmfUiRefreshHandler.getInstance().queueUpdate((Object)this, () -> {
                    if (timeGraphControl.isDisposed()) {
                        return;
                    }
                    int timeSpace = AbstractTimeGraphMultiViewer.this.getTimeGraphViewer().getTimeSpace();
                    Set<@NonNull TimeGraphEntry> newSet = AbstractTimeGraphMultiViewer.this.getVisibleItems(3);
                    if (AbstractTimeGraphMultiViewer.this.fPrevTimeSpace != timeSpace || !AbstractTimeGraphMultiViewer.this.fVisibleEntries.equals(newSet)) {
                        AbstractTimeGraphMultiViewer.this.fVisibleEntries = newSet;
                        AbstractTimeGraphMultiViewer.this.fPrevTimeSpace = timeSpace;
                        AbstractTimeGraphMultiViewer.this.startZoomThread(AbstractTimeGraphMultiViewer.this.getTimeGraphViewer().getTime0(), AbstractTimeGraphMultiViewer.this.getTimeGraphViewer().getTime1());
                    }
                });
            }
        });
        if (this.fSite instanceof IViewSite) {
            IStatusLineManager statusLineManager = ((IViewSite)this.fSite).getActionBars().getStatusLineManager();
            timeGraphControl.setStatusLineManager(statusLineManager);
        }
        if ((trace = TmfTraceManager.getInstance().getActiveTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider(this.fTimeGraphViewer.getSelectionProvider());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.createContextMenu();
        this.fPartListener = new TimeGraphPartListener();
        site.getPage().addPartListener((IPartListener)this.fPartListener);
        this.fPartListener2 = new TimeGraphPartListener2();
        site.getPage().addPartListener((IPartListener2)this.fPartListener2);
        this.contextServiceInit(timeGraphControl, site);
        this.updateTimeFormat();
        TmfSignalManager.register((Object)this);
    }

    private void contextServiceInit(TimeGraphControl timeGraphControl, IWorkbenchPartSite site) {
        @Nullable IWorkbenchWindow workbenchWindow = site.getWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        this.fContextService = (IContextService)workbenchWindow.getService(IContextService.class);
        if (timeGraphControl.isInFocus()) {
            this.activateContextService();
        }
        timeGraphControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                AbstractTimeGraphMultiViewer.this.deactivateContextService();
            }

            public void focusGained(FocusEvent e) {
                AbstractTimeGraphMultiViewer.this.activateContextService();
            }
        });
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fTimeGraphViewer == null) {
            return null;
        }
        return this.fTimeGraphViewer.getTimeViewAlignmentInfo();
    }

    public int getAvailableWidth(int requestedOffset) {
        if (this.fTimeGraphViewer == null) {
            return 0;
        }
        return this.fTimeGraphViewer.getAvailableWidth(requestedOffset);
    }

    public void performAlign(int offset, int width) {
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.performAlign(offset, width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.fTimeGraphViewer.dispose();
        TmfSignalManager.deregister((Object)this);
        Map<ITmfTrace, Job> map = this.fBuildJobMap;
        synchronized (map) {
            this.fBuildJobMap.values().forEach(Job::cancel);
        }
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.deactivateContextService();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        IWorkbenchPage page = this.fSite.getPage();
        if (this.fPartListener != null) {
            page.removePartListener((IPartListener)this.fPartListener);
        }
        if (this.fPartListener2 != null) {
            page.removePartListener((IPartListener2)this.fPartListener2);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fEditorFile)) {
                this.fTimeGraphViewer.setBookmarks(AbstractTimeGraphMultiViewer.refreshBookmarks(this.fEditorFile));
                this.redraw();
                return;
            }
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public String getViewerId() {
        return ID;
    }

    public TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphViewer;
    }

    public IWorkbenchPartSite getSite() {
        return this.fSite;
    }

    private void activateContextService() {
        if (this.fContextService == null) {
            return;
        }
        if (this.fActiveContexts.isEmpty()) {
            this.fActiveContexts.add(this.fContextService.activateContext(TIMEGRAPH_UI_CONTEXT));
            this.fActiveContexts.add(this.fContextService.activateContext(TMF_VIEW_UI_CONTEXT));
        }
    }

    private void deactivateContextService() {
        if (this.fContextService == null) {
            return;
        }
        this.fContextService.deactivateContexts(this.fActiveContexts);
        this.fActiveContexts.clear();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        this.resetViewer(signal.getTrace());
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fEditorFile = null;
            this.setStartTime(-1L);
            this.setEndTime(-1L);
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.setTimeBoundsAndRefresh();
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        ITmfTrace trace = this.fTrace;
        if (signal.getSource() == this || trace == null) {
            return;
        }
        ITmfTrace signalTrace = signal.getTrace();
        if (signalTrace != null && !TmfTraceManager.getInstance().isSynchronized(trace, signalTrace)) {
            return;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
        long beginTime = ctx.getSelectionRange().getStartTime().toNanos();
        long endTime = ctx.getSelectionRange().getEndTime().toNanos();
        Display.getDefault().asyncExec(() -> {
            if (this.fTimeGraphViewer.getControl().isDisposed()) {
                return;
            }
            if (beginTime == endTime) {
                this.fTimeGraphViewer.setSelectedTime(beginTime, true);
            } else {
                this.fTimeGraphViewer.setSelectionRange(beginTime, endTime, true);
            }
            this.synchingToTime(this.fTimeGraphViewer.getSelectionBegin());
        });
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(Objects.requireNonNull(this.fTrace));
        long startTime = ctx.getWindowRange().getStartTime().toNanos();
        long endTime = ctx.getWindowRange().getEndTime().toNanos();
        Display.getDefault().asyncExec(() -> {
            if (this.fTimeGraphViewer.getControl().isDisposed()) {
                return;
            }
            if (startTime == this.fTimeGraphViewer.getTime0() && endTime == this.fTimeGraphViewer.getTime1()) {
                return;
            }
            this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
            this.startZoomThread(startTime, endTime);
        });
    }

    @TmfSignalHandler
    public void updateTimeFormat(TmfTimestampFormatUpdateSignal signal) {
        this.updateTimeFormat();
        this.fTimeGraphViewer.refresh();
    }

    @TmfSignalHandler
    public void markerEventSourceUpdated(TmfMarkerEventSourceUpdatedSignal signal) {
        this.getTimeGraphViewer().setMarkerCategories(this.getMarkerCategories());
        this.getTimeGraphViewer().setMarkers(null);
        this.refresh();
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected ITimeGraphPresentationProvider getPresentationProvider() {
        return this.fPresentation;
    }

    protected void setEntryComparator(Comparator<ITimeGraphEntry> comparator) {
        this.fEntryComparator = comparator;
    }

    protected void loadingTrace(@NonNull ITmfTrace trace) {
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return TmfTraceManager.getTraceSet((ITmfTrace)trace);
    }

    protected @NonNull Set<@NonNull TimeGraphEntry> getVisibleItems(int buffer) {
        TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        if (timeGraphControl.isDisposed()) {
            return Collections.emptySet();
        }
        int start = Integer.max(0, this.fTimeGraphViewer.getTopIndex() - buffer);
        int end = Integer.min(this.fTimeGraphViewer.getExpandedElementCount() - 1, this.fTimeGraphViewer.getTopIndex() + timeGraphControl.countPerPage() + buffer);
        HashSet<@NonNull TimeGraphEntry> visible = new HashSet<TimeGraphEntry>(end - start + 1);
        int i = start;
        while (i <= end) {
            TimeGraphEntry element = (TimeGraphEntry)timeGraphControl.getExpandedElement(i);
            if (element != null) {
                visible.add(element);
            }
            ++i;
        }
        return visible;
    }

    protected abstract void buildEntryList(@NonNull ITmfTrace var1, @NonNull ITmfTrace var2, @NonNull IProgressMonitor var3);

    protected @Nullable List<@NonNull ITimeEvent> getEventList(@NonNull TimeGraphEntry entry, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ITimeEvent>();
    }

    protected @NonNull List<String> getViewMarkerCategories() {
        return new ArrayList<String>();
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    protected @Nullable List<@NonNull ILinkEvent> getLinkList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected @NonNull List<String> getViewerMarkerCategories() {
        return new ArrayList<String>();
    }

    protected @NonNull List<IMarkerEvent> getViewerMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    protected @NonNull List<IMarkerEvent> getTraceMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            markers.addAll(markerEventSource.getMarkerList(startTime, endTime, resolution, monitor));
        }
        return markers;
    }

    protected @NonNull List<String> getMarkerCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>(this.getViewerMarkerCategories());
        for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            categories.addAll(markerEventSource.getMarkerCategories());
        }
        return new ArrayList<String>(categories);
    }

    protected void setFilterColumns(String[] filterColumns) {
        this.fFilterColumns = Arrays.copyOf(filterColumns, filterColumns.length);
    }

    protected void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.fFilterContentProvider = contentProvider;
    }

    protected void setFilterLabelProvider(TreeLabelProvider labelProvider) {
        this.fFilterLabelProvider = labelProvider;
    }

    protected int getDisplayWidth() {
        return this.fDisplayWidth;
    }

    protected long getStartTime() {
        return this.fStartTime;
    }

    protected void setStartTime(long time) {
        this.fStartTime = time;
    }

    protected long getEndTime() {
        return this.fEndTime;
    }

    protected void setEndTime(long time) {
        this.fEndTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable List<@NonNull TimeGraphEntry> getEntryList(ITmfTrace trace) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            return this.fEntryListMap.get(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, List<@NonNull TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, List<@NonNull TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList == null) {
                this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                for (TimeGraphEntry entry : list) {
                    if (entryList.contains(entry)) continue;
                    entryList.add(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList != null) {
                entryList.removeAll(list);
            }
        }
    }

    private @NonNull List<IMarkerEventSource> getMarkerEventSources(ITmfTrace trace) {
        List<Object> markerEventSources = this.fMarkerEventSourcesMap.get(trace);
        if (markerEventSources == null) {
            markerEventSources = Collections.emptyList();
        }
        return markerEventSources;
    }

    private void updateTimeFormat() {
        if (this.fTimeFormat == null) {
            String datime = (String)TmfTimePreferences.getPreferenceMap().get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime");
            if ("TTT".equals(datime)) {
                this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.RELATIVE);
            } else {
                this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.CALENDAR);
            }
        } else {
            this.fTimeGraphViewer.setTimeFormat(this.fTimeFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace(ITmfTrace trace) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
        if (this.fTrace != null) {
            this.fFiltersMap.put(this.fTrace, this.fTimeGraphViewer.getFilters());
            this.fViewerContext.put(this.fTrace, new ViewerContext(this.fCurrentSortColumn, this.fSortDirection, this.fTimeGraphViewer.getSelection(), this.fTimeGraphViewer.getAllCollapsedElements()));
        }
        this.fTrace = trace;
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"MultiTimeGraphViewer:LoadingTrace", (Object[])new Object[]{"trace", trace.getName(), "viewerId", this.getViewerId()});
        this.restoreViewContext();
        this.fEditorFile = TmfTraceManager.getInstance().getTraceEditorFile(trace);
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            this.loadingTrace(trace);
            if (this.fEntryList == null) {
                this.rebuild();
            } else {
                this.setTimeBoundsAndRefresh();
            }
        }
        this.getPresentationProvider().refresh();
    }

    private void setTimeBoundsAndRefresh() {
        this.setStartTime(this.fTrace.getStartTime().toNanos());
        this.setEndTime(this.fTrace.getEndTime().toNanos());
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void rebuild() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog parentLogger = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "MultiTimeGraphViewer:Rebuilding", new Object[0]).setCategory(this.getViewerId()).build();){
            this.setTimeBoundsAndRefresh();
            final ITmfTrace viewerTrace = this.fTrace;
            if (viewerTrace == null) {
                return;
            }
            this.resetViewer(viewerTrace);
            ArrayList markerEventSources = new ArrayList();
            Map<ITmfTrace, Job> map = this.fBuildJobMap;
            synchronized (map) {
                IWorkbenchSiteProgressService service = null;
                if (this.fSite != null) {
                    service = (IWorkbenchSiteProgressService)this.fSite.getService(IWorkbenchSiteProgressService.class);
                }
                for (final ITmfTrace trace : this.getTracesToBuild(viewerTrace)) {
                    if (trace == null) break;
                    @NonNull List adapters = TmfTraceAdapterManager.getAdapters((ITmfTrace)trace, IMarkerEventSource.class);
                    markerEventSources.addAll(adapters);
                    Job buildJob = new Job(String.valueOf(this.getName()) + org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages.AbstractTimeGraphView_BuildJob){

                        protected IStatus run(IProgressMonitor monitor) {
                            new BuildRunnable(trace, viewerTrace, parentLogger).run(monitor);
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    this.fBuildJobMap.put(trace, buildJob);
                    if (service != null) {
                        service.schedule(buildJob);
                        continue;
                    }
                    buildJob.schedule();
                }
            }
            this.fMarkerEventSourcesMap.put(viewerTrace, markerEventSources);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void triggerRebuild() {
        this.rebuild();
    }

    protected void synchingToTime(long time) {
    }

    public void refresh() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentLogger = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RefreshRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            boolean isZoomThread = Thread.currentThread() instanceof ZoomThread;
            TmfUiRefreshHandler.getInstance().queueUpdate((Object)this, () -> {
                Throwable throwable = null;
                Object var4_5 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "MultiTimeGraphViewer:Refresh", new Object[0]).setParentScope(parentLogger).build();){
                    if (this.fTimeGraphViewer.getControl().isDisposed()) {
                        return;
                    }
                    this.fDirty.incrementAndGet();
                    try {
                        long endTime;
                        boolean inputChanged;
                        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
                        synchronized (map) {
                            this.fEntryList = this.fEntryListMap.get(this.fTrace);
                            if (this.fEntryList == null) {
                                this.fEntryList = new CopyOnWriteArrayList<TimeGraphEntry>();
                            } else if (this.fEntryComparator != null) {
                                ArrayList<TimeGraphEntry> list = new ArrayList<TimeGraphEntry>(this.fEntryList);
                                Collections.sort(list, this.fEntryComparator);
                                for (ITimeGraphEntry iTimeGraphEntry : list) {
                                    this.sortChildren(iTimeGraphEntry, this.fEntryComparator);
                                }
                                this.fEntryList.clear();
                                this.fEntryList.addAll(list);
                            }
                        }
                        boolean bl2 = inputChanged = this.fEntryList != this.fTimeGraphViewer.getInput();
                        if (inputChanged) {
                            this.fTimeGraphViewer.setInput(this.fEntryList);
                            this.fTimeGraphViewer.setFilters(this.fFiltersMap.get(this.fTrace));
                            this.fTimeGraphViewer.setLinks(null);
                            this.fTimeGraphViewer.setBookmarks(AbstractTimeGraphMultiViewer.refreshBookmarks(this.fEditorFile));
                            this.fTimeGraphViewer.setMarkerCategories(this.getMarkerCategories());
                            this.fTimeGraphViewer.setMarkers(null);
                            this.applyViewContext();
                        } else {
                            this.fTimeGraphViewer.refresh();
                        }
                        if (this.fIsRevealSelection) {
                            this.fIsRevealSelection = false;
                            this.fTimeGraphViewer.setSelection((ISelection)this.fTimeGraphViewer.getSelection(), true);
                        }
                        long startBound = this.fStartTime == Long.MAX_VALUE ? -1L : this.fStartTime;
                        long endBound = this.fEndTime == Long.MIN_VALUE ? -1L : this.fEndTime;
                        this.fTimeGraphViewer.setTimeBounds(startBound, endBound);
                        ITmfTrace trace = this.fTrace;
                        TmfTraceContext ctx = trace == null ? null : TmfTraceManager.getInstance().getTraceContext(trace);
                        long selectionBeginTime = ctx == null ? -1L : ctx.getSelectionRange().getStartTime().toNanos();
                        long selectionEndTime = ctx == null ? -1L : ctx.getSelectionRange().getEndTime().toNanos();
                        long startTime = ctx == null ? -1L : ctx.getWindowRange().getStartTime().toNanos();
                        long l = endTime = ctx == null ? -1L : ctx.getWindowRange().getEndTime().toNanos();
                        if (this.fStartTime > this.fEndTime) {
                            startTime = -1L;
                            endTime = -1L;
                        } else {
                            startTime = Math.min(Math.max(startTime, this.fStartTime), this.fEndTime);
                            endTime = Math.min(Math.max(endTime, this.fStartTime), this.fEndTime);
                        }
                        this.fTimeGraphViewer.setSelectionRange(selectionBeginTime, selectionEndTime, false);
                        this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
                        if (inputChanged && selectionBeginTime != -1L) {
                            this.synchingToTime(selectionBeginTime);
                        }
                        ZoomThread zoomThread = this.fZoomThread;
                        if (!isZoomThread || zoomThread != null && (zoomThread.getZoomStartTime() != startTime || zoomThread.getZoomEndTime() != endTime)) {
                            this.startZoomThread(startTime, endTime);
                        }
                    }
                    finally {
                        if (this.fDirty.decrementAndGet() < 0) {
                            Activator.getDefault().logError(DIRTY_UNDERFLOW_ERROR, new Throwable());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        object = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog flowParent = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RedrawRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            Display.getDefault().asyncExec(() -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "MultiTimeGraphViewer:Redraw", new Object[0]).setParentScope(flowParent).build();){
                    if (this.fTimeGraphViewer.getControl().isDisposed()) {
                        return;
                    }
                    this.fTimeGraphViewer.getControl().redraw();
                    this.fTimeGraphViewer.getControl().update();
                    Object object = this.fSyncObj;
                    synchronized (object) {
                        if (this.fRedrawState == State.PENDING) {
                            this.fRedrawState = State.IDLE;
                            this.redraw();
                        } else {
                            this.fRedrawState = State.IDLE;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startZoomThread(long startTime, long endTime) {
        block20: {
            try {
                Throwable throwable = null;
                Object var6_5 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "MultiTimeGraphViewer:ZoomThreadCreated", new Object[0]).setCategory(this.getViewerId()).build();){
                    int timeSpace;
                    long clampedStartTime = this.fStartTime == Long.MAX_VALUE ? startTime : Math.min(Math.max(startTime, this.fStartTime), this.fEndTime);
                    long clampedEndTime = this.fEndTime == Long.MIN_VALUE ? endTime : Math.max(Math.min(endTime, this.fEndTime), this.fStartTime);
                    this.fDirty.incrementAndGet();
                    boolean restart = false;
                    ZoomThread zoomThread = this.fZoomThread;
                    if (zoomThread != null) {
                        zoomThread.cancel();
                        if (zoomThread.fZoomStartTime == clampedStartTime && zoomThread.fZoomEndTime == clampedEndTime) {
                            restart = true;
                        }
                    }
                    if ((timeSpace = this.getTimeGraphViewer().getTimeSpace()) > 0) {
                        long resolution = Long.max(1L, (clampedEndTime - clampedStartTime) / (long)timeSpace);
                        zoomThread = this.createZoomThread(clampedStartTime, clampedEndTime, resolution, restart);
                    } else {
                        zoomThread = null;
                    }
                    this.fZoomThread = zoomThread;
                    if (zoomThread == null) break block20;
                    zoomThread.setScopeId(log.getId());
                    Object object = this.fZoomThreadResultLock;
                    synchronized (object) {
                        zoomThread.start();
                        this.fDirty.incrementAndGet();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (this.fDirty.decrementAndGet() < 0) {
                    Activator.getDefault().logError(DIRTY_UNDERFLOW_ERROR, new Throwable());
                }
            }
        }
    }

    protected @Nullable ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        return new ZoomThreadByEntry(this.getVisibleItems(3), startTime, endTime, resolution);
    }

    private void createColumnSelectionListener(final Tree tree) {
        int i = 0;
        while (i < this.fColumnComparators.length) {
            final int index = i;
            final Comparator<ITimeGraphEntry> comp = this.fColumnComparators[index];
            final TreeColumn column = tree.getColumn(i);
            if (comp != null) {
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TreeColumn prevSortcolumn = tree.getSortColumn();
                        int direction = tree.getSortDirection();
                        direction = prevSortcolumn == column ? (direction == 1024 ? 128 : 1024) : 1024;
                        tree.setSortColumn(column);
                        tree.setSortDirection(direction);
                        AbstractTimeGraphMultiViewer.this.fSortDirection = direction;
                        AbstractTimeGraphMultiViewer.this.fCurrentSortColumn = index;
                        Comparator comparator = comp;
                        if (comparator instanceof ITimeGraphEntryComparator) {
                            ((ITimeGraphEntryComparator)comparator).setDirection(direction);
                        }
                        if (direction != 1024) {
                            comparator = Objects.requireNonNull(Collections.reverseOrder(comparator));
                        }
                        AbstractTimeGraphMultiViewer.this.setEntryComparator(comparator);
                        AbstractTimeGraphMultiViewer.this.fIsRevealSelection = true;
                        AbstractTimeGraphMultiViewer.this.fTimeGraphViewer.getControl().setFocus();
                        AbstractTimeGraphMultiViewer.this.refresh();
                    }
                });
            }
            ++i;
        }
    }

    private void sortChildren(ITimeGraphEntry entry, Comparator<ITimeGraphEntry> comparator) {
        if (entry instanceof TimeGraphEntry) {
            ((TimeGraphEntry)entry).sortChildren(comparator);
        }
        for (ITimeGraphEntry child : entry.getChildren()) {
            this.sortChildren(child, comparator);
        }
    }

    private void restoreViewContext() {
        ViewerContext viewerContext = this.fViewerContext.get(this.fTrace);
        if (this.fColumnComparators != null) {
            this.fSortDirection = 1024;
            this.fCurrentSortColumn = this.fInitialSortColumn;
            if (viewerContext != null) {
                this.fSortDirection = viewerContext.getSortDirection();
                this.fCurrentSortColumn = viewerContext.getSortColumn();
            }
            if (this.fCurrentSortColumn < this.fColumnComparators.length && this.fColumnComparators[this.fCurrentSortColumn] != null) {
                Comparator<ITimeGraphEntry> comparator = this.fColumnComparators[this.fCurrentSortColumn];
                if (comparator instanceof ITimeGraphEntryComparator) {
                    ((ITimeGraphEntryComparator)comparator).setDirection(this.fSortDirection);
                }
                if (this.fSortDirection != 1024) {
                    comparator = Objects.requireNonNull(Collections.reverseOrder(comparator));
                }
                this.setEntryComparator(comparator);
            }
        }
    }

    private void applyViewContext() {
        ViewerContext viewContext = this.fViewerContext.remove(this.fTrace);
        this.applyExpandedStateContext(viewContext);
        if (this.fColumnComparators != null) {
            Tree tree = this.fTimeGraphViewer.getTree();
            TreeColumn column = tree.getColumn(this.fCurrentSortColumn);
            tree.setSortDirection(this.fSortDirection);
            tree.setSortColumn(column);
        }
        if (viewContext != null && viewContext.getSelection() != null) {
            this.fTimeGraphViewer.setSelection((ISelection)viewContext.getSelection(), true);
        }
    }

    private void applyExpandedStateContext(ViewerContext viewContext) {
        if (viewContext != null) {
            this.fTimeGraphViewer.expandAll();
            this.fTimeGraphViewer.setExpandedState(viewContext.getCollapsedEntries(), false);
        }
    }

    private static List<IMarkerEvent> refreshBookmarks(IFile editorFile) {
        ArrayList<IMarkerEvent> bookmarks = new ArrayList<IMarkerEvent>();
        if (editorFile == null || !editorFile.exists()) {
            return bookmarks;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = editorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                IMarker marker = iMarkerArray[n2];
                String label = marker.getAttribute("message", null);
                String time = marker.getAttribute("time", null);
                String duration = marker.getAttribute("duration", Long.toString(0L));
                String rgba = marker.getAttribute("color", null);
                if (label != null && time != null && rgba != null && (matcher = RGBA_PATTERN.matcher(rgba)).matches()) {
                    try {
                        int red = Integer.valueOf(matcher.group(1));
                        int green = Integer.valueOf(matcher.group(2));
                        int blue = Integer.valueOf(matcher.group(3));
                        int alpha = Integer.valueOf(matcher.group(4));
                        RGBA color = new RGBA(red, green, blue, alpha);
                        bookmarks.add((IMarkerEvent)new MarkerEvent(null, Long.valueOf(time).longValue(), Long.valueOf(duration).longValue(), IMarkerEvent.BOOKMARKS, color, label, true));
                    }
                    catch (NumberFormatException e) {
                        Activator.getDefault().logError(e.getMessage());
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage());
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyResults(Runnable runnable) {
        Object object = this.fZoomThreadResultLock;
        synchronized (object) {
            if (Thread.currentThread() == this.fZoomThread) {
                Display.getDefault().asyncExec(runnable);
            }
        }
    }

    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        this.zoomEntries(entries, zoomStartTime, zoomEndTime, resolution, false, monitor);
    }

    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, boolean fullSearch, @NonNull IProgressMonitor monitor) {
        try {
            Map<Integer, Predicate<Multimap<String, Object>>> predicates = this.generateRegexPredicate();
            for (TimeGraphEntry entry : entries) {
                List<ITimeEvent> zoomedEventList = this.getEventList(entry, zoomStartTime, zoomEndTime, fullSearch ? 1L : resolution, monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                if (zoomedEventList == null) continue;
                this.doFilterEvents(entry, zoomedEventList, predicates);
                this.applyResults(() -> entry.setZoomedEventList(zoomedEventList));
            }
            this.redraw();
        }
        catch (PatternSyntaxException e) {
            Activator.getDefault().logInfo("Invalid regex");
        }
    }

    @NonNullByDefault
    protected void doFilterEvents(TimeGraphEntry entry, List<ITimeEvent> eventList, Map<Integer, Predicate<Multimap<String, Object>>> predicates) {
        if (!predicates.isEmpty()) {
            eventList.forEach(te -> {
                for (Map.Entry mapEntry : predicates.entrySet()) {
                    Predicate value = Objects.requireNonNull((Predicate)mapEntry.getValue());
                    HashMultimap toTest = HashMultimap.create();
                    this.getPresentationProvider().getFilterInput(te).forEach((arg_0, arg_1) -> AbstractTimeGraphMultiViewer.lambda$11((Multimap)toTest, arg_0, arg_1));
                    te.getMetadata().forEach((arg_0, arg_1) -> AbstractTimeGraphMultiViewer.lambda$12((Multimap)toTest, arg_0, arg_1));
                    boolean status = value.test(toTest);
                    Integer property = (Integer)mapEntry.getKey();
                    if (property == 1 || property == 4) {
                        te.setProperty(property.intValue(), !status);
                        continue;
                    }
                    te.setProperty(property.intValue(), status);
                }
            });
        }
        this.fillWithNullEvents(entry, eventList);
    }

    private void fillWithNullEvents(TimeGraphEntry entry, List<ITimeEvent> eventList) {
        ArrayList filtered = new ArrayList();
        if (!eventList.isEmpty() && this.getTimeEventFilterDialog() != null && this.getTimeEventFilterDialog().hasActiveSavedFilters()) {
            eventList.forEach(te -> {
                if (!te.isPropertyActive(4)) {
                    filtered.add(te);
                }
            });
            long prevTime = eventList.get(0).getTime();
            long endTime = eventList.get(eventList.size() - 1).getTime() + eventList.get(eventList.size() - 1).getDuration();
            eventList.clear();
            for (ITimeEvent event : filtered) {
                if (prevTime < event.getTime()) {
                    NullTimeEvent nullTimeEvent = new NullTimeEvent((ITimeGraphEntry)entry, prevTime, event.getTime() - prevTime);
                    nullTimeEvent.setProperty(1, true);
                    nullTimeEvent.setProperty(4, true);
                    eventList.add((ITimeEvent)nullTimeEvent);
                }
                eventList.add(event);
                prevTime = event.getTime() + event.getDuration();
            }
            if (prevTime < endTime) {
                NullTimeEvent nullTimeEvent = new NullTimeEvent((ITimeGraphEntry)entry, prevTime, endTime - prevTime);
                nullTimeEvent.setProperty(1, true);
                nullTimeEvent.setProperty(4, true);
                eventList.add((ITimeEvent)nullTimeEvent);
            }
        }
    }

    @NonNullByDefault
    protected Map<Integer, Predicate<Multimap<String, Object>>> generateRegexPredicate() {
        Multimap<Integer, String> regexes = this.getRegexes();
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        for (Map.Entry entry : regexes.asMap().entrySet()) {
            Predicate predicate;
            String regex = IFilterStrings.mergeFilters((Collection)((Collection)entry.getValue()));
            FilterCu cu = FilterCu.compile((String)regex);
            Predicate predicate2 = predicate = cu != null ? cu.generate() : null;
            if (predicate == null) continue;
            predicates.put((Integer)entry.getKey(), predicate);
        }
        return predicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetViewer(ITmfTrace viewerTrace) {
        if (viewerTrace == null) {
            return;
        }
        Map<ITmfTrace, Object> map = this.fBuildJobMap;
        synchronized (map) {
            for (ITmfTrace trace : this.getTracesToBuild(viewerTrace)) {
                Job buildJob = this.fBuildJobMap.remove(trace);
                if (buildJob == null) continue;
                buildJob.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(viewerTrace);
        }
        this.fViewerContext.remove(viewerTrace);
        this.fFiltersMap.remove(viewerTrace);
        this.fMarkerEventSourcesMap.remove(viewerTrace);
        if (viewerTrace == this.fTrace && this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
    }

    private void createContextMenu() {
        this.fEntryMenuManager.setRemoveAllWhenShown(true);
        TimeGraphControl timeGraphControl = this.getTimeGraphViewer().getTimeGraphControl();
        Menu entryMenu = this.fEntryMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeGraphEntryMenuListener(event -> {
            Point p = timeGraphControl.toControl(event.x, event.y);
            if (p.x < this.getTimeGraphViewer().getNameSpace()) {
                timeGraphControl.setMenu(entryMenu);
            } else {
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        this.fEntryMenuManager.addMenuListener(manager -> {
            this.fillTimeGraphEntryContextMenu((IMenuManager)this.fEntryMenuManager);
            this.fEntryMenuManager.add((IContributionItem)new GroupMarker("additions"));
        });
        this.getSite().registerContextMenu(this.fEntryMenuManager, this.fTimeGraphViewer.getSelectionProvider());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        String dialogRegex;
        @NonNull @NonNull HashMultimap regexes = HashMultimap.create();
        String string = dialogRegex = this.fTimeEventFilterDialog != null ? this.fTimeEventFilterDialog.getTextBoxRegex() : "";
        if (!dialogRegex.isEmpty()) {
            regexes.put((Object)1, (Object)dialogRegex);
        }
        Set<@NonNull String> savedFilters = this.fTimeEventFilterDialog != null ? this.fTimeEventFilterDialog.getSavedFilters() : Collections.emptySet();
        for (String savedFilter : savedFilters) {
            regexes.put((Object)4, (Object)savedFilter);
            regexes.put((Object)1, (Object)savedFilter);
        }
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            return regexes;
        }
        TraceCompassFilter globalFilter = TraceCompassFilter.getFilterForTrace((ITmfTrace)trace);
        if (globalFilter == null) {
            return regexes;
        }
        regexes.putAll((Object)1, (Iterable)globalFilter.getRegexes());
        return regexes;
    }

    protected TimeEventFilterDialog getTimeEventFilterDialog() {
        return this.fTimeEventFilterDialog;
    }

    public void restartZoomThread() {
        ZoomThread zoomThread = this.fZoomThread;
        if (zoomThread != null) {
            zoomThread.cancel();
            this.fZoomThread = null;
        }
        Runnable runnable = () -> this.startZoomThread(this.getTimeGraphViewer().getTime0(), this.getTimeGraphViewer().getTime1());
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == Display.getCurrent()) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public Action getTimeEventFilterAction() {
        return this.fTimeEventFilterAction;
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
    }

    private static /* synthetic */ void lambda$11(Multimap multimap, String k, String e) {
        boolean bl = multimap.put((Object)k, (Object)e);
    }

    private static /* synthetic */ void lambda$12(Multimap multimap, String k, Object e) {
        boolean bl = multimap.put((Object)k, e);
    }

    private class BuildRunnable {
        private final @NonNull ITmfTrace fBuildTrace;
        private final @NonNull ITmfTrace fParentTrace;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public BuildRunnable(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, TraceCompassLogUtils.FlowScopeLog log) {
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fScope = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "MultiTimeGraphViewer:BuildThread", new Object[]{"trace", this.fBuildTrace.getName()}).setParentScope(this.fScope).build();){
                AbstractTimeGraphMultiViewer.this.buildEntryList(this.fBuildTrace, this.fParentTrace, Objects.requireNonNull(monitor));
                Map<ITmfTrace, Job> map = AbstractTimeGraphMultiViewer.this.fBuildJobMap;
                synchronized (map) {
                    AbstractTimeGraphMultiViewer.this.fBuildJobMap.remove(this.fBuildTrace);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    class FindTarget {
        FindTarget() {
        }

        public ITimeGraphEntry getSelection() {
            return AbstractTimeGraphMultiViewer.this.fTimeGraphViewer.getSelection();
        }

        public void selectAndReveal(@NonNull ITimeGraphEntry entry) {
            AbstractTimeGraphMultiViewer.this.fTimeGraphViewer.selectAndReveal(entry);
        }

        public ITimeGraphEntry[] getEntries() {
            TimeGraphViewer viewer = AbstractTimeGraphMultiViewer.this.getTimeGraphViewer();
            return viewer.getTimeGraphContentProvider().getElements(viewer.getInput());
        }

        public Shell getShell() {
            return AbstractTimeGraphMultiViewer.this.fSite.getShell();
        }
    }

    static class ShowFindDialogAction
    extends Action {
        public void run() {
        }

        public void checkShell(FindTarget target) {
        }

        public synchronized void partActivated(IWorkbenchPart part) {
        }
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    class TimeGraphPartListener
    implements IPartListener {
        TimeGraphPartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partActivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphMultiViewer.this) {
                ShowFindDialogAction showFindDialogAction = FIND_ACTION;
                synchronized (showFindDialogAction) {
                    if (AbstractTimeGraphMultiViewer.this.fFindActionHandler == null) {
                        AbstractTimeGraphMultiViewer.this.fFindActionHandler = new ActionHandler((IAction)FIND_ACTION);
                    }
                    if (AbstractTimeGraphMultiViewer.this.fFindHandlerActivation == null) {
                        Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                        AbstractTimeGraphMultiViewer.this.fFindHandlerActivation = ((IHandlerService)service).activateHandler(ActionFactory.FIND.getCommandId(), (IHandler)AbstractTimeGraphMultiViewer.this.fFindActionHandler);
                    }
                }
            }
            FIND_ACTION.partActivated(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphMultiViewer.this && AbstractTimeGraphMultiViewer.this.fFindHandlerActivation != null) {
                Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                ((IHandlerService)service).deactivateHandler(AbstractTimeGraphMultiViewer.this.fFindHandlerActivation);
                AbstractTimeGraphMultiViewer.this.fFindHandlerActivation = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class TimeGraphPartListener2
    implements IPartListener2 {
        TimeGraphPartListener2() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && part == AbstractTimeGraphMultiViewer.this) {
                Display.getDefault().asyncExec(() -> {
                    if (AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog != null) {
                        AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog.close();
                    }
                });
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && part == AbstractTimeGraphMultiViewer.this) {
                Display.getDefault().asyncExec(() -> {
                    if (AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog != null && AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog.isFilterActive()) {
                        AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog.open();
                    }
                });
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return new String();
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            return entry.getName();
        }
    }

    private static class ViewerContext {
        private final int fSortColumnIndex;
        private final int fSortDirection;
        private final @Nullable ITimeGraphEntry fSelection;
        private final @NonNull Set<@NonNull ITimeGraphEntry> fCollapsedEntries;

        ViewerContext(int sortColumn, int sortDirection, ITimeGraphEntry selection, @NonNull Set<@NonNull ITimeGraphEntry> collapsedEntries) {
            this.fSortColumnIndex = sortColumn;
            this.fSortDirection = sortDirection;
            this.fSelection = selection;
            this.fCollapsedEntries = ImmutableSet.copyOf(collapsedEntries);
        }

        public int getSortColumn() {
            return this.fSortColumnIndex;
        }

        public int getSortDirection() {
            return this.fSortDirection;
        }

        public ITimeGraphEntry getSelection() {
            return this.fSelection;
        }

        public @NonNull Set<@NonNull ITimeGraphEntry> getCollapsedEntries() {
            return this.fCollapsedEntries;
        }
    }

    protected abstract class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private int fScopeId;
        private final @NonNull IProgressMonitor fMonitor;

        public ZoomThread(long startTime, long endTime, long resolution) {
            super(String.valueOf(AbstractTimeGraphMultiViewer.this.getName()) + " zoom");
            this.fScopeId = -1;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = resolution;
            this.fMonitor = new NullProgressMonitor();
        }

        public long getZoomStartTime() {
            return this.fZoomStartTime;
        }

        public long getZoomEndTime() {
            return this.fZoomEndTime;
        }

        public long getResolution() {
            return this.fResolution;
        }

        public @NonNull IProgressMonitor getMonitor() {
            return this.fMonitor;
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }

        @Override
        public final void run() {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "MultiTimeGraphViewer:ZoomThread", new Object[]{"start", this.fZoomStartTime, "end", this.fZoomEndTime}).setCategoryAndId(AbstractTimeGraphMultiViewer.this.getViewerId(), this.fScopeId).build();){
                    this.doRun();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (AbstractTimeGraphMultiViewer.this.fDirty.decrementAndGet() < 0) {
                    Activator.getDefault().logError(AbstractTimeGraphMultiViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                }
            }
        }

        protected void applyResults(Runnable runnable) {
            AbstractTimeGraphMultiViewer.this.applyResults(runnable);
        }

        public abstract void doRun();

        public void setScopeId(int scopeId) {
            this.fScopeId = scopeId;
        }
    }

    private class ZoomThreadByEntry
    extends ZoomThread {
        private final @NonNull Collection<@NonNull TimeGraphEntry> fEntries;

        public ZoomThreadByEntry(Collection<TimeGraphEntry> entries, long startTime, long endTime, long resolution) {
            super(startTime, endTime, resolution);
            this.fEntries = entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void doRun() {
            sampling = new TimeGraphEntry.Sampling(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution());
            isFilterActive = AbstractTimeGraphMultiViewer.this.getRegexes().values().isEmpty() == false;
            var3_3 = null;
            var4_5 = null;
            try {
                log = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphMultiViewer.LOGGER, Level.FINER, "ZoomThread:GettingStates", new Object[0]);
                try {
                    isFilterCleared = isFilterActive == false && AbstractTimeGraphMultiViewer.this.getTimeGraphViewer().isTimeEventFilterActive() != false;
                    AbstractTimeGraphMultiViewer.this.getTimeGraphViewer().setTimeEventFilterApplied(isFilterActive);
                    hasSavedFilter = AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog != null && AbstractTimeGraphMultiViewer.this.fTimeEventFilterDialog.hasActiveSavedFilters() != false;
                    AbstractTimeGraphMultiViewer.this.getTimeGraphViewer().setSavedFilterStatus(hasSavedFilter);
                    incorrectSample = Iterables.filter(this.fEntries, (com.google.common.base.Predicate)(com.google.common.base.Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(boolean boolean org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry$Sampling org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry ), (Lorg/eclipse/tracecompass/tmf/ui/widgets/timegraph/model/TimeGraphEntry;)Z)((boolean)isFilterActive, (boolean)isFilterCleared, (TimeGraphEntry.Sampling)sampling));
                    AbstractTimeGraphMultiViewer.this.zoomEntries(incorrectSample, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
                }
                finally {
                    if (log != null) {
                        log.close();
                    }
                }
            }
            catch (Throwable var4_6) {
                if (var3_3 == null) {
                    var3_3 = var4_6;
                } else if (var3_3 != var4_6) {
                    var3_3.addSuppressed(var4_6);
                }
                throw var3_3;
            }
            var4_5 = null;
            var5_8 = null;
            try {
                linkLog = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphMultiViewer.LOGGER, Level.FINER, "ZoomThread:GettingLinks", new Object[0]);
                try {
                    computedLinks /* !! */  = AbstractTimeGraphMultiViewer.this.getLinkList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
                    filterDialog = AbstractTimeGraphMultiViewer.this.getTimeEventFilterDialog();
                    if (filterDialog != null && computedLinks /* !! */  != null) {
                        if (filterDialog.hasActiveSavedFilters()) {
                            computedLinks /* !! */  = Collections.emptyList();
                        } else {
                            computedLinks /* !! */ .forEach((Consumer<ILinkEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$1(org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph.TimeEventFilterDialog org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent ), (Lorg/eclipse/tracecompass/tmf/ui/widgets/timegraph/model/ILinkEvent;)V)((TimeEventFilterDialog)filterDialog));
                        }
                    }
                }
                finally {
                    if (linkLog != null) {
                        linkLog.close();
                    }
                }
            }
            catch (Throwable var5_9) {
                if (var4_5 == null) {
                    var4_5 = var5_9;
                } else if (var4_5 != var5_9) {
                    var4_5.addSuppressed(var5_9);
                }
                throw var4_5;
            }
            links = computedLinks /* !! */ ;
            var5_8 = null;
            var6_13 = null;
            try {
                markerLoglog = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphMultiViewer.LOGGER, Level.FINER, "ZoomThread:GettingMarkers", new Object[0]);
                try {
                    markers = new ArrayList<IMarkerEvent>(AbstractTimeGraphMultiViewer.this.getViewerMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
                    markers.addAll(AbstractTimeGraphMultiViewer.this.getTraceMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
                    this.applyResults((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$2(java.util.List java.util.List ), ()V)((ZoomThreadByEntry)this, links, markers));
                    var9_19 = AbstractTimeGraphMultiViewer.this.fZoomThreadResultLock;
                    synchronized (var9_19) {
                        if (Thread.currentThread() == AbstractTimeGraphMultiViewer.this.fZoomThread) {
                            AbstractTimeGraphMultiViewer.this.refresh();
                        }
                    }
                }
                finally {
                    if (markerLoglog != null) {
                        markerLoglog.close();
                    }
                }
            }
            catch (Throwable var6_14) {
                if (var5_8 == null) {
                    var5_8 = var6_14;
                } else if (var5_8 != var6_14) {
                    var5_8.addSuppressed(var6_14);
                }
                throw var5_8;
            }
            if (isFilterActive && Thread.currentThread() == AbstractTimeGraphMultiViewer.this.fZoomThread) {
                var5_8 = null;
                var6_13 = null;
                try {
                    log = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphMultiViewer.LOGGER, Level.FINER, "ZoomThread:GettingStatesFullSearch", new Object[0]);
                    try {
                        var9_19 = this.fEntries.iterator();
                        while (true) {
                            entry = var9_19.next();
                            if (this.getMonitor().isCanceled()) {
                                return;
                            }
                            AbstractTimeGraphMultiViewer.this.zoomEntries(Collections.singleton(entry), this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), true, this.getMonitor());
                            AbstractTimeGraphMultiViewer.this.refresh();
                            break;
                        }
                    }
                    finally {
                        if (var9_19.hasNext()) ** continue;
                    }
                }
                catch (Throwable var6_15) {
                    if (var5_8 == null) {
                        var5_8 = var6_15;
                    } else if (var5_8 != var6_15) {
                        var5_8.addSuppressed(var6_15);
                    }
                    throw var5_8;
                }
            }
        }

        private static /* synthetic */ boolean lambda$0(boolean bl, boolean bl2, TimeGraphEntry.Sampling sampling, TimeGraphEntry entry) {
            return bl || bl2 || !sampling.equals((Object)entry.getSampling());
        }

        private static /* synthetic */ void lambda$1(TimeEventFilterDialog timeEventFilterDialog, ILinkEvent link) {
            link.setProperty(1, timeEventFilterDialog.isFilterActive());
        }

        private /* synthetic */ void lambda$2(List list, List list2) {
            if (list != null) {
                AbstractTimeGraphMultiViewer.this.fTimeGraphViewer.setLinks(list);
            }
            AbstractTimeGraphMultiViewer.this.fTimeGraphViewer.setMarkerCategories(AbstractTimeGraphMultiViewer.this.getMarkerCategories());
            AbstractTimeGraphMultiViewer.this.fTimeGraphViewer.setMarkers(list2);
        }
    }
}

