/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.delegates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateCreator;

public class DelegateFieldCreator
extends DelegateCreator {
    private VariableDeclarationFragment fOldFieldFragment;

    @Override
    protected void initialize() {
        Assert.isTrue((boolean)(this.getDeclaration() instanceof FieldDeclaration));
        Assert.isTrue((((FieldDeclaration)this.getDeclaration()).fragments().size() == 1 ? 1 : 0) != 0);
        this.fOldFieldFragment = (VariableDeclarationFragment)((FieldDeclaration)this.getDeclaration()).fragments().get(0);
        if (this.getNewElementName() == null) {
            this.setNewElementName(this.fOldFieldFragment.getName().getIdentifier());
        }
        this.setInsertBefore(false);
    }

    @Override
    protected ASTNode createBody(BodyDeclaration fd) throws JavaScriptModelException {
        FieldDeclaration result = (FieldDeclaration)fd;
        Expression initializer = this.createDelegateFieldInitializer(result);
        return initializer;
    }

    @Override
    protected ASTNode createDocReference(BodyDeclaration declaration) {
        MemberRef ref = this.getAst().newMemberRef();
        ref.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            ref.setQualifier(this.createDestinationTypeName());
        }
        return ref;
    }

    @Override
    protected ASTNode getBodyHead(BodyDeclaration result) {
        return this.fOldFieldFragment;
    }

    @Override
    protected ChildPropertyDescriptor getJavaDocProperty() {
        return FieldDeclaration.JAVADOC_PROPERTY;
    }

    @Override
    protected ChildPropertyDescriptor getBodyProperty() {
        return VariableDeclarationFragment.INITIALIZER_PROPERTY;
    }

    @Override
    protected IBinding getDeclarationBinding() {
        return this.fOldFieldFragment.resolveBinding();
    }

    @Override
    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateFieldCreator_text_edit_group_label;
    }

    private Expression createDelegateFieldInitializer(FieldDeclaration declaration) throws JavaScriptModelException {
        Assert.isNotNull((Object)declaration);
        Expression qualification = this.getAccess();
        if (qualification != null) {
            FieldAccess access = this.getAst().newFieldAccess();
            access.setExpression(qualification);
            access.setName(this.getAst().newSimpleName(this.getNewElementName()));
            return access;
        }
        SimpleName access = this.getAst().newSimpleName(this.getNewElementName());
        return access;
    }
}

