/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.core.runtime.CoreException;

public class CPPPointerToMemberType
extends CPPPointerType
implements ICPPPointerToMemberType {
    private ICPPASTPointerToMember operator;
    private IType classType;

    public CPPPointerToMemberType(IType type, ICPPASTPointerToMember operator) {
        super(type, operator);
        this.operator = operator;
    }

    public CPPPointerToMemberType(IType type, IType classType, boolean isConst, boolean isVolatile, boolean isRestrict) {
        super(type, isConst, isVolatile, isRestrict);
        this.classType = classType;
    }

    @Override
    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof ICPPPointerToMemberType)) {
            return false;
        }
        if (!super.isSameType(o)) {
            return false;
        }
        ICPPPointerToMemberType pt = (ICPPPointerToMemberType)o;
        IType cls = pt.getMemberOfClass();
        if (cls != null) {
            return cls.isSameType(this.getMemberOfClass());
        }
        return false;
    }

    @Override
    public IType getMemberOfClass() {
        if (this.classType == null) {
            ICPPASTNameSpecifier nameSpec;
            IBinding binding = null;
            ICPPASTPointerToMember pm = this.operator;
            if (pm == null) {
                nameSpec = new CPPASTName();
            } else {
                nameSpec = (ICPPASTName)pm.getName();
                if (nameSpec instanceof ICPPASTQualifiedName) {
                    ICPPASTQualifiedName qname = (ICPPASTQualifiedName)nameSpec;
                    ICPPASTNameSpecifier[] qualifier = qname.getQualifier();
                    nameSpec = qualifier.length > 0 ? qualifier[qualifier.length - 1] : (ICPPASTName)qname.getLastName();
                }
                binding = nameSpec.resolvePreBinding();
            }
            this.classType = binding instanceof IType ? (IType)((Object)binding) : new CPPClassType.CPPClassTypeProblem(nameSpec, 5, nameSpec.toCharArray());
        }
        return this.classType;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 7;
        if (this.isConst()) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.isVolatile()) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        if (this.isRestrict()) {
            firstBytes = (short)(firstBytes | 0x80);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.getType());
        buffer.marshalType(this.getMemberOfClass());
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        IType memberOf = buffer.unmarshalType();
        return new CPPPointerToMemberType(nested, memberOf, (firstBytes & 0x20) != 0, (firstBytes & 0x40) != 0, (firstBytes & 0x80) != 0);
    }
}

