/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HeaderParser {
    private HeaderParser() {
    }

    public static List<PathElement> parseHeader(String header) {
        String[] clauses;
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        if (header == null || header.trim().length() == 0) {
            return elements;
        }
        for (String clause : clauses = header.split(",(?![^\\(\\)]*(\\)))")) {
            String[] tokens = clause.split(";");
            if (tokens.length < 1) {
                throw new IllegalArgumentException("Invalid header clause: " + clause);
            }
            PathElement elem = new PathElement(tokens[0].trim());
            elements.add(elem);
            for (int i = 1; i < tokens.length; ++i) {
                int pos = tokens[i].indexOf(61);
                if (pos != -1) {
                    String value;
                    String name;
                    if (pos > 0 && tokens[i].charAt(pos - 1) == ':') {
                        name = tokens[i].substring(0, pos - 1).trim();
                        value = tokens[i].substring(pos + 1).trim();
                        elem.addDirective(name, value);
                        continue;
                    }
                    name = tokens[i].substring(0, pos).trim();
                    value = tokens[i].substring(pos + 1).trim();
                    elem.addAttribute(name, value);
                    continue;
                }
                elem = new PathElement(tokens[i].trim());
                elements.add(elem);
            }
        }
        return elements;
    }

    public static class PathElement {
        private String path;
        private Map<String, String> attributes;
        private Map<String, String> directives;

        public PathElement(String path) {
            this.path = path;
            this.attributes = new HashMap<String, String>();
            this.directives = new HashMap<String, String>();
        }

        public String getName() {
            return this.path;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void addAttribute(String name, String value) {
            this.attributes.put(name, value);
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public String getDirective(String name) {
            return this.directives.get(name);
        }

        public void addDirective(String name, String value) {
            this.directives.put(name, value);
        }
    }
}

