/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.internal.content.LowLevelIOException;

public class LazyReader
extends Reader
implements ILazySource {
    private final int blockCapacity;
    char[][] blocks = new char[0][];
    private long bufferSize;
    private final Reader in;
    private long mark;
    private long offset;
    private final long maxBufferSize;

    public LazyReader(Reader in, int blockCapacity) {
        this.in = in;
        this.blockCapacity = blockCapacity;
        this.maxBufferSize = (long)blockCapacity * Integer.MAX_VALUE;
    }

    @Override
    public void close() {
    }

    private int computeBlockSize(int blockIndex) {
        if (blockIndex < this.blocks.length - 1) {
            return this.blockCapacity;
        }
        int blockSize = (int)(this.bufferSize % (long)this.blockCapacity);
        return blockSize == 0 ? this.blockCapacity : blockSize;
    }

    private int copyFromBuffer(char[] userBuffer, int userOffset, int needed) throws LowLevelIOException {
        int copied = 0;
        int current = this.getCurrentBlockIndex();
        while (needed - copied > 0 && current < this.blocks.length) {
            int blockSize = this.computeBlockSize(current);
            int offsetInBlock = this.getOffsetInCurrentBlock();
            int availableInBlock = blockSize - offsetInBlock;
            int toCopy = Math.min(availableInBlock, needed - copied);
            System.arraycopy(this.blocks[current], offsetInBlock, userBuffer, userOffset + copied, toCopy);
            copied += toCopy;
            ++current;
            this.increaseOffset(toCopy);
        }
        return copied;
    }

    private int getCurrentBlockIndex() {
        return Math.toIntExact(this.offset / (long)this.blockCapacity);
    }

    private int getOffsetInCurrentBlock() {
        return (int)this.offset % this.blockCapacity;
    }

    private void increaseOffset(long inc) throws LowLevelIOException {
        this.checkOffsetIncrease(inc);
        this.offset += inc;
    }

    private void checkOffsetIncrease(long inc) throws LowLevelIOException {
        if (this.offset + inc >= this.maxBufferSize) {
            throw new LowLevelIOException(new EOFException("This would bring the current offset over the limit: " + this.maxBufferSize));
        }
    }

    private void ensureAvailable(long charsToRead) throws IOException {
        this.checkOffsetIncrease(charsToRead);
        int loadedBlockSize = this.blockCapacity;
        while (this.bufferSize < this.offset + charsToRead && loadedBlockSize == this.blockCapacity) {
            try {
                loadedBlockSize = this.loadBlock();
            }
            catch (IOException ioe) {
                throw new LowLevelIOException(ioe);
            }
            this.bufferSize += (long)loadedBlockSize;
        }
    }

    protected int getBlockCount() {
        return this.blocks.length;
    }

    protected long getBufferSize() {
        return this.bufferSize;
    }

    protected void setBufferSize(long bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected long getMark() {
        return this.mark;
    }

    protected long getOffset() {
        return this.offset;
    }

    protected void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public boolean isText() {
        return true;
    }

    private int loadBlock() throws IOException {
        char[] newBlock = new char[this.blockCapacity];
        int readCount = this.in.read(newBlock);
        if (readCount == -1) {
            return 0;
        }
        char[][] tmpBlocks = new char[this.blocks.length + 1][];
        System.arraycopy(this.blocks, 0, tmpBlocks, 0, this.blocks.length);
        this.blocks = tmpBlocks;
        this.blocks[this.blocks.length - 1] = newBlock;
        return readCount;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        this.ensureAvailable(1L);
        if (this.bufferSize <= this.offset) {
            return -1;
        }
        char nextChar = this.blocks[this.getCurrentBlockIndex()][this.getOffsetInCurrentBlock()];
        this.increaseOffset(1L);
        return nextChar;
    }

    @Override
    public int read(char[] c) throws IOException {
        return this.read(c, 0, c.length);
    }

    @Override
    public int read(char[] c, int off, int len) throws IOException {
        this.ensureAvailable(len);
        int copied = this.copyFromBuffer(c, off, len);
        return copied == 0 ? -1 : copied;
    }

    @Override
    public boolean ready() throws IOException {
        try {
            return this.bufferSize - this.offset > 0L || this.in.ready();
        }
        catch (IOException ioe) {
            throw new LowLevelIOException(ioe);
        }
    }

    @Override
    public void reset() {
        this.offset = this.mark;
    }

    @Override
    public void rewind() {
        this.mark = 0L;
        this.offset = 0L;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        if (toSkip <= 0L) {
            return 0L;
        }
        this.ensureAvailable(toSkip);
        long skipped = Math.min(toSkip, this.bufferSize - this.offset);
        this.increaseOffset(skipped);
        return skipped;
    }
}

