/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.VariableHelpers;

public class CPPVariableInstance
extends CPPSpecialization
implements ICPPVariableInstance,
ICPPInternalVariable {
    private ICPPTemplateArgument[] templateArguments;
    private IType type;
    private IValue initialValue;

    public CPPVariableInstance(IBinding specialized, IBinding owner, ICPPTemplateParameterMap argumentMap, ICPPTemplateArgument[] args, IType tpe, IValue value) {
        super(specialized, owner, argumentMap);
        this.templateArguments = args;
        this.type = tpe;
        this.initialValue = value;
    }

    @Override
    public ICPPTemplateDefinition getTemplateDefinition() {
        return (ICPPTemplateDefinition)this.getSpecializedBinding();
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.templateArguments;
    }

    @Override
    public boolean isExplicitSpecialization() {
        if (this.getDefinition() != null) {
            return true;
        }
        IASTNode[] decls = this.getDeclarations();
        if (decls != null) {
            IASTNode[] iASTNodeArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode decl = iASTNodeArray[n2];
                if (decl != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return ((ICPPVariable)this.getSpecializedBinding()).isConstexpr();
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public IValue getInitialValue() {
        return this.initialValue;
    }

    @Override
    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    @Override
    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        return VariableHelpers.hasStorageClass(name, ns, storage);
    }
}

