/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Configuration;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.ConfigurationSourceType;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.ErrorResponse;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.ConfigurationQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ErrorResponseUtil;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSource;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceManager;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;

@Path(value="/config")
@Tag(name="Configurations")
public class ConfigurationManagerService {
    private final TmfConfigurationSourceManager fConfigSourceManager = TmfConfigurationSourceManager.getInstance();

    @GET
    @Path(value="/types/")
    @Produces(value={"application/json"})
    @Operation(summary="Get the list of configuration source types defined on the server", responses={@ApiResponse(responseCode="200", description="Returns a list of configuration source types", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConfigurationSourceType.class)))})})
    public Response getConfigurationTypes() {
        return Response.ok((Object)this.fConfigSourceManager.getConfigurationSourceTypes()).build();
    }

    @GET
    @Path(value="/types/{typeId}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a single configuration source type defined on the server", responses={@ApiResponse(responseCode="200", description="Returns a single configuration source type", content={@Content(schema=@Schema(implementation=ConfigurationSourceType.class))}), @ApiResponse(responseCode="404", description="No such configuration type", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response getConfigurationType(@Parameter(description="The configuration source type ID") @PathParam(value="typeId") String typeId) {
        ITmfConfigurationSource configurationSource = this.fConfigSourceManager.getConfigurationSource(typeId);
        if (configurationSource == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration source type doesn't exist");
        }
        return Response.ok((Object)configurationSource.getConfigurationSourceType()).build();
    }

    @GET
    @Path(value="/types/{typeId}/configs")
    @Produces(value={"application/json"})
    @Operation(summary="Get the list of configurations that are instantiated of a given configuration source type", responses={@ApiResponse(responseCode="200", description="Get the list of configuration descriptors ", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Configuration.class)))}), @ApiResponse(responseCode="404", description="No such configuration source type or configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response getConfigurations(@Parameter(description="The configuration source type ID") @PathParam(value="typeId") String typeId) {
        ITmfConfigurationSource configurationSource = this.fConfigSourceManager.getConfigurationSource(typeId);
        if (configurationSource == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration source type doesn't exist");
        }
        return Response.ok((Object)configurationSource.getConfigurations()).build();
    }

    @POST
    @Path(value="/types/{typeId}/configs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a configuration instance for the given configuration source type", responses={@ApiResponse(responseCode="200", description="The configuration instance was successfully created", content={@Content(schema=@Schema(implementation=Configuration.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="No such configuration source type or configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal trace-server error while trying to create configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response postConfiguration(@Parameter(description="The configuration source type ID") @PathParam(value="typeId") String typeId, @RequestBody(description="Query parameters to create a configuration instance. Provide all query parameter keys and values as specified in the corresponding configuration source type.", content={@Content(examples={@ExampleObject(value="{\"name\": \"test.xml\", \"description\": \"Configuration with test.xml\", \"parameters\":{ \"path\": \"/home/user/test.xml\" }}")}, schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.ConfigurationQueryParameters.class))}, required=true) ConfigurationQueryParameters queryParameters) {
        ITmfConfigurationSource configurationSource = this.fConfigSourceManager.getConfigurationSource(typeId);
        if (configurationSource == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration source type doesn't exist");
        }
        if (queryParameters == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.BAD_REQUEST, "Missing query parameters");
        }
        ITmfConfiguration inputConfig = new TmfConfiguration.Builder().setName(queryParameters.getName()).setDescription(queryParameters.getDescription()).setSourceTypeId(typeId).setParameters(queryParameters.getParameters()).build();
        try {
            ITmfConfiguration config = configurationSource.create(inputConfig);
            return Response.ok((Object)config).build();
        }
        catch (TmfConfigurationException e) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @GET
    @Path(value="/types/{typeId}/configs/{configId}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a configuration instance of a given configuration source type", responses={@ApiResponse(responseCode="200", description="Get a configuration instance", content={@Content(schema=@Schema(implementation=Configuration.class))}), @ApiResponse(responseCode="404", description="No such configuration source type or configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response getConfiguration(@Parameter(description="The configuration source type ID") @PathParam(value="typeId") String typeId, @Parameter(description="The configuration instance ID") @PathParam(value="configId") String configId) {
        ITmfConfigurationSource configurationSource = this.fConfigSourceManager.getConfigurationSource(typeId);
        if (configurationSource == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration source type doesn't exist");
        }
        if (configId == null || !configurationSource.contains(configId)) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration instance doesn't exist for type " + typeId);
        }
        ITmfConfiguration config = configurationSource.get(configId);
        if (config == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration instance doesn't exist for type " + typeId);
        }
        return Response.ok((Object)config).build();
    }

    @PUT
    @Path(value="/types/{typeId}/configs/{configId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a configuration instance of a given configuration source type", responses={@ApiResponse(responseCode="200", description="The configuration instance was successfully updated", content={@Content(schema=@Schema(implementation=Configuration.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="No such configuration source type or configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal trace-server error while trying to update configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response putConfiguration(@Parameter(description="The configuration source type ID") @PathParam(value="typeId") String typeId, @Parameter(description="The configuration instance ID") @PathParam(value="configId") String configId, @RequestBody(description="Query parameters to update a configuration instance. Provide all query parameter keys and values as specified in the corresponding configuration source type.", content={@Content(examples={@ExampleObject(value="{\"name\": \"test.xml\", \"description\": \"Configuration with test.xml\", \"parameters\":{ \"path\": \"/home/user/test.xml\" }}")}, schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.ConfigurationQueryParameters.class))}, required=true) ConfigurationQueryParameters queryParameters) {
        ITmfConfigurationSource configurationSource = this.fConfigSourceManager.getConfigurationSource(typeId);
        if (configurationSource == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration source type doesn't exist");
        }
        if (queryParameters == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.BAD_REQUEST, "Missing query parameters");
        }
        if (configId == null || !configurationSource.contains(configId)) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration instance doesn't exist for type " + typeId);
        }
        ITmfConfiguration inputConfig = new TmfConfiguration.Builder().setId(configId).setName(queryParameters.getName()).setDescription(queryParameters.getDescription()).setSourceTypeId(typeId).setParameters(queryParameters.getParameters()).build();
        try {
            ITmfConfiguration config = configurationSource.update(configId, inputConfig);
            return Response.ok((Object)config).build();
        }
        catch (TmfConfigurationException e) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @DELETE
    @Path(value="/types/{typeId}/configs/{configId}")
    @Produces(value={"application/json"})
    @Operation(summary="Delete a configuration instance of a given configuration source type", responses={@ApiResponse(responseCode="200", description="The configuration instance was successfully deleted", content={@Content(schema=@Schema(implementation=Configuration.class))}), @ApiResponse(responseCode="404", description="No such configuration source type or configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal trace-server error while trying to delete configuration instance", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response deleteConfiguration(@Parameter(description="The configuration source type ID") @PathParam(value="typeId") String typeId, @Parameter(description="The configuration instance ID") @PathParam(value="configId") String configId) {
        ITmfConfigurationSource configurationSource = this.fConfigSourceManager.getConfigurationSource(typeId);
        if (configurationSource == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration source type doesn't exist");
        }
        if (configId == null || !configurationSource.contains(configId)) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.NOT_FOUND, "Configuration instance doesn't exist for type " + typeId);
        }
        ITmfConfiguration config = configurationSource.remove(configId);
        if (config == null) {
            return ErrorResponseUtil.newErrorResponse(Response.Status.BAD_REQUEST, "Failed removing configuration instance");
        }
        return Response.ok((Object)config).build();
    }
}

