/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

class NoStampValidationState
extends BufferValidationState {
    private IDocumentListener fDocumentListener;
    private FileBufferListener fFileBufferListener;
    private boolean fChanged;
    private long fContentStamp = -1L;

    public NoStampValidationState(IFile file) {
        super(file);
        this.fContentStamp = file.getModificationStamp();
        this.fFileBufferListener = new FileBufferListener();
        FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)this.fFileBufferListener);
        this.fDocumentListener = new DocumentChangedListener();
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    @Override
    public RefactoringStatus isValid(boolean needsSaving, boolean resilientForDerived) throws CoreException {
        RefactoringStatus result = super.isValid(needsSaving, resilientForDerived);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fChanged || this.fContentStamp != this.fFile.getModificationStamp()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.TextChanges_error_content_changed, BasicElementLabels.getPathLabel(this.fFile.getFullPath(), false)));
        }
        return result;
    }

    @Override
    public void dispose() {
        if (this.fFileBufferListener != null) {
            FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this.fFileBufferListener);
            this.fFileBufferListener = null;
        }
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
    }

    private void documentChanged() {
        this.fChanged = true;
        this.getDocument().removeDocumentListener(this.fDocumentListener);
        FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this.fFileBufferListener);
        this.fFileBufferListener = null;
        this.fDocumentListener = null;
    }

    class DocumentChangedListener
    implements IDocumentListener {
        DocumentChangedListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            NoStampValidationState.this.documentChanged();
        }
    }

    class FileBufferListener
    implements IFileBufferListener {
        FileBufferListener() {
        }

        public void bufferCreated(IFileBuffer buffer) {
            if (buffer.getLocation().equals((Object)NoStampValidationState.this.fFile.getFullPath()) && buffer instanceof ITextFileBuffer) {
                ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
                if (NoStampValidationState.this.fDocumentListener == null) {
                    NoStampValidationState.this.fDocumentListener = new DocumentChangedListener();
                }
                textBuffer.getDocument().addDocumentListener(NoStampValidationState.this.fDocumentListener);
            }
        }

        public void bufferDisposed(IFileBuffer buffer) {
            if (NoStampValidationState.this.fDocumentListener != null && buffer.getLocation().equals((Object)NoStampValidationState.this.fFile.getFullPath())) {
                if (buffer instanceof ITextFileBuffer) {
                    ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
                    textBuffer.getDocument().removeDocumentListener(NoStampValidationState.this.fDocumentListener);
                    NoStampValidationState.this.fDocumentListener = null;
                }
                NoStampValidationState.this.fContentStamp = NoStampValidationState.this.fFile.getModificationStamp();
            }
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }
    }
}

