/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;

public class TmfConfiguration
implements ITmfConfiguration {
    private final String fId;
    private final String fName;
    private final String fDescription;
    private final String fSourceTypeId;
    private final Map<String, Object> fParameters;

    private TmfConfiguration(Builder builder) {
        this.fId = Objects.requireNonNull(builder.fId);
        this.fName = builder.fName;
        this.fDescription = builder.fDescription;
        this.fSourceTypeId = Objects.requireNonNull(builder.fSourceTypeId);
        this.fParameters = builder.fParameters;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getSourceTypeId() {
        return this.fSourceTypeId;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.fParameters;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "fName=" + this.getName() + ", fDescription=" + this.getDescription() + ", fType=" + this.getSourceTypeId() + ", fId=" + this.getId() + ", fParameters=" + this.getParameters() + "]";
    }

    public boolean equals(@Nullable Object arg0) {
        if (!(arg0 instanceof TmfConfiguration)) {
            return false;
        }
        TmfConfiguration other = (TmfConfiguration)arg0;
        return Objects.equals(this.fName, other.fName) && Objects.equals(this.fId, other.fId) && Objects.equals(this.fSourceTypeId, other.fSourceTypeId) && Objects.equals(this.fDescription, other.fDescription) && Objects.equals(this.fParameters, other.fParameters);
    }

    public int hashCode() {
        return Objects.hash(this.fName, this.fId, this.fSourceTypeId, this.fDescription, this.fParameters);
    }

    public static class Builder {
        private String fId = "";
        private String fName = "";
        private String fDescription = "";
        private String fSourceTypeId = "";
        private Map<String, Object> fParameters = new HashMap<String, Object>();

        public Builder setId(String id) {
            this.fId = id;
            return this;
        }

        public Builder setName(String name) {
            this.fName = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.fDescription = description;
            return this;
        }

        public Builder setSourceTypeId(String sourceTypeId) {
            this.fSourceTypeId = sourceTypeId;
            return this;
        }

        public Builder setParameters(Map<String, Object> parameters) {
            this.fParameters = parameters;
            return this;
        }

        public ITmfConfiguration build() {
            String typeId = this.fSourceTypeId;
            if (typeId.isBlank()) {
                throw new IllegalStateException("Configuration source type ID not set");
            }
            String id = this.fId;
            if (id.isBlank()) {
                throw new IllegalStateException("Configuration ID not set");
            }
            return new TmfConfiguration(this);
        }
    }
}

