/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.core.natives.CNativePlugin;
import org.eclipse.cdt.internal.core.natives.Messages;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.SpawnerInputStream;
import org.eclipse.cdt.utils.spawner.SpawnerOutputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class Spawner
extends Process {
    @Deprecated(forRemoval=true)
    public int NOOP = 0;
    @Deprecated(forRemoval=true)
    public int HUP = 1;
    @Deprecated(forRemoval=true)
    public int KILL = 9;
    @Deprecated(forRemoval=true)
    public int TERM = 15;
    @Deprecated(forRemoval=true)
    public int INT = 2;
    @Deprecated(forRemoval=true)
    public int CTRLC = 1000;
    private static final int SIG_NOOP = 0;
    private static final int SIG_HUP = 1;
    private static final int SIG_KILL = 9;
    private static final int SIG_TERM = 15;
    private static final int SIG_INT = 2;
    private static final int SIG_CTRLC = 1000;
    private static final int DEFAULT_GRACEFUL_EXIT_TIME_MS;
    int pid = 0;
    int status;
    final IChannel[] fChannels = new IChannel[3];
    OutputStream out;
    InputStream in;
    InputStream err;
    private PTY fPty;
    private final int fGracefulExitTimeMs;
    private State fState = State.RUNNING;

    static {
        String timeStr = System.getProperty("org.eclipse.cdt.core.graceful_exit_time_ms");
        int time = 1000;
        if (timeStr != null) {
            try {
                time = Integer.parseInt(timeStr);
            }
            catch (NumberFormatException e) {
                CNativePlugin.log("Failed to parse system property. Falling back to " + time + " ms graceful exit time.", e);
            }
        }
        DEFAULT_GRACEFUL_EXIT_TIME_MS = time;
        try {
            System.loadLibrary("spawner");
            Spawner.configureNativeTrace(Platform.getDebugBoolean((String)"org.eclipse.cdt.core.native/debug/spawner"), Platform.getDebugBoolean((String)"org.eclipse.cdt.core.native/debug/spawner/details"), Platform.getDebugBoolean((String)"org.eclipse.cdt.core.native/debug/spawner/starter"), Platform.getDebugBoolean((String)"org.eclipse.cdt.core.native/debug/spawner/read_report"));
        }
        catch (SecurityException e) {
            CNativePlugin.log(e);
        }
        catch (UnsatisfiedLinkError e) {
            CNativePlugin.log(e);
        }
    }

    @Deprecated
    public Spawner(String command, boolean bNoRedirect) throws IOException {
        this.fGracefulExitTimeMs = DEFAULT_GRACEFUL_EXIT_TIME_MS;
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        if (bNoRedirect) {
            this.exec_detached(cmdarray, new String[0], ".");
        } else {
            this.exec(cmdarray, new String[0], ".");
        }
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir) throws IOException {
        this(cmdarray, envp, dir, DEFAULT_GRACEFUL_EXIT_TIME_MS);
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir, int gracefulExitTimeMs) throws IOException {
        this.fGracefulExitTimeMs = gracefulExitTimeMs;
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir, PTY pty) throws IOException {
        this(cmdarray, envp, dir, pty, DEFAULT_GRACEFUL_EXIT_TIME_MS);
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir, PTY pty, int gracefulExitTimeMs) throws IOException {
        this.fGracefulExitTimeMs = gracefulExitTimeMs;
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.fPty = pty;
        this.exec_pty(cmdarray, envp, dirpath, pty);
    }

    @Deprecated
    protected Spawner(String command) throws IOException {
        this(command, null);
    }

    protected Spawner(String[] cmdarray) throws IOException {
        this(cmdarray, null);
    }

    protected Spawner(String[] cmdarray, int gracefulExitTimeMs) throws IOException {
        this(cmdarray, null, gracefulExitTimeMs);
    }

    protected Spawner(String[] cmdarray, String[] envp) throws IOException {
        this(cmdarray, envp, null);
    }

    protected Spawner(String[] cmdarray, String[] envp, int gracefulExitTimeMs) throws IOException {
        this(cmdarray, envp, null, gracefulExitTimeMs);
    }

    @Deprecated
    protected Spawner(String cmd, String[] envp) throws IOException {
        this(cmd, envp, null);
    }

    @Deprecated
    protected Spawner(String command, String[] envp, File dir) throws IOException {
        this.fGracefulExitTimeMs = DEFAULT_GRACEFUL_EXIT_TIME_MS;
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    protected void finalize() throws Throwable {
        this.closeUnusedStreams();
    }

    @Override
    public synchronized InputStream getInputStream() {
        if (this.in == null) {
            this.in = this.fPty != null ? this.fPty.getInputStream() : new SpawnerInputStream(this.fChannels[1]);
        }
        return this.in;
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = this.fPty != null ? this.fPty.getOutputStream() : new SpawnerOutputStream(this.fChannels[0]);
        }
        return this.out;
    }

    @Override
    public synchronized InputStream getErrorStream() {
        if (this.err == null) {
            this.err = this.fPty != null && !this.fPty.isConsole() ? new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            } : new SpawnerInputStream(this.fChannels[2]);
        }
        return this.err;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (this.fState != State.DONE) {
            this.wait();
        }
        this.closeUnusedStreams();
        return this.status;
    }

    @Override
    public synchronized int exitValue() {
        if (this.fState != State.DONE) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.status;
    }

    @Override
    public synchronized void destroy() {
        switch (this.fState) {
            case RUNNING: {
                this.fState = State.DESTROYING;
                this.terminate();
                this.closeUnusedStreams();
                if (this.fState != State.DONE) {
                    try {
                        this.wait(this.fGracefulExitTimeMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.fState == State.DONE) break;
                this.kill();
                break;
            }
        }
    }

    @Override
    public long pid() {
        return this.pid;
    }

    public int interrupt() {
        return this.raise(this.pid, 2);
    }

    public int interruptCTRLC() {
        if (Platform.getOS().equals("win32")) {
            return this.raise(this.pid, 1000);
        }
        return this.interrupt();
    }

    public int hangup() {
        return this.raise(this.pid, 1);
    }

    public int kill() {
        return this.raise(this.pid, 9);
    }

    public int terminate() {
        return this.raise(this.pid, 15);
    }

    public boolean isRunning() {
        return this.raise(this.pid, 0) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        Reaper reaper = new Reaper(cmdarray, envp, dirpath);
        reaper.setDaemon(true);
        reaper.start();
        Spawner spawner = this;
        synchronized (spawner) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.pid == -1) {
            throw new IOException(reaper.getErrorMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec_pty(String[] cmdarray, String[] envp, String dirpath, final PTY pty) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        Reaper reaper = new Reaper(this, cmdarray, envp, dirpath){

            @Override
            int execute(String[] cmd, String[] env, String dir, IChannel[] channels) throws IOException {
                return pty.exec_pty(this, cmd, env, dir, channels);
            }

            @Override
            protected int waitFor(int pid) {
                return pty.waitFor(this, pid);
            }
        };
        reaper.setDaemon(true);
        reaper.start();
        Spawner spawner = this;
        synchronized (spawner) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.pid == -1) {
            throw new IOException("Exec_tty error:" + reaper.getErrorMessage());
        }
    }

    public void exec_detached(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        this.pid = this.exec1(cmdarray, envp, dirpath);
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
    }

    private synchronized void closeUnusedStreams() {
        try {
            if (this.err == null) {
                this.getErrorStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.in == null) {
                this.getInputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.out == null) {
                this.getOutputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    native int exec0(String[] var1, String[] var2, String var3, IChannel[] var4) throws IOException;

    native int exec1(String[] var1, String[] var2, String var3) throws IOException;

    public native int exec2(String[] var1, String[] var2, String var3, IChannel[] var4, String var5, int var6, boolean var7) throws IOException;

    public native int raise(int var1, int var2);

    public int raise(int sig) {
        return this.raise(this.pid, sig);
    }

    public native int waitFor(int var1);

    private static native void configureNativeTrace(boolean var0, boolean var1, boolean var2, boolean var3);

    public static interface IChannel {
    }

    class Reaper
    extends Thread {
        String[] fCmdarray;
        String[] fEnvp;
        String fDirpath;
        volatile Throwable fException;

        public Reaper(String[] array, String[] env, String dir) {
            super("Spawner Reaper");
            this.fCmdarray = array;
            this.fEnvp = env;
            this.fDirpath = dir;
            this.fException = null;
        }

        int execute(String[] cmdarray, String[] envp, String dir, IChannel[] channels) throws IOException {
            return Spawner.this.exec0(cmdarray, envp, dir, channels);
        }

        int waitFor(int pid) {
            return Spawner.this.waitFor(pid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int _pid;
            try {
                _pid = this.execute(this.fCmdarray, this.fEnvp, this.fDirpath, Spawner.this.fChannels);
            }
            catch (Exception e) {
                _pid = -1;
                this.fException = e;
            }
            Spawner spawner = Spawner.this;
            synchronized (spawner) {
                Spawner.this.pid = _pid;
                Spawner.this.notifyAll();
            }
            if (_pid != -1) {
                Spawner.this.status = this.waitFor(Spawner.this.pid);
                spawner = Spawner.this;
                synchronized (spawner) {
                    Spawner.this.fState = State.DONE;
                    Spawner.this.notifyAll();
                }
            }
        }

        public String getErrorMessage() {
            String reason = this.fException != null ? this.fException.getMessage() : "Unknown reason";
            return NLS.bind((String)Messages.Util_error_cannotRun, (Object)this.fCmdarray[0], (Object)reason);
        }
    }

    private static enum State {
        RUNNING,
        DESTROYING,
        DONE;

    }

    public static class UnixChannel
    implements IChannel {
        final int fd;

        public UnixChannel(int fd) {
            this.fd = fd;
        }
    }

    public static class WinChannel
    implements IChannel {
        final long handle;

        public WinChannel(long handle) {
            this.handle = handle;
        }
    }
}

