/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.FlameDataProviderTestUtils;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.flamegraph.FlameGraphDataProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartEntryModel;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.junit.Assert;
import org.junit.Test;

public class FlameGraphDataProviderTest
extends CallStackTestBase2 {
    private static final String EXPECTED_FILE_PATH = "testfiles/dp/";
    private static final String WITH_PARENT = " with parent ";
    private static final @NonNull Map<@NonNull String, @NonNull Object> TREE_PARAMETERS = ImmutableMap.of((Object)"requested_times", (Object)ImmutableList.of((Object)0, (Object)Long.MAX_VALUE));
    private static final Map<String, String> VALUE_TO_STYLE = new HashMap<String, String>();

    @Test
    public void testFlameGraphDataProviderAllItems() throws IOException {
        CallStackAnalysisStub cga = this.getModule();
        FlameGraphDataProvider provider = new FlameGraphDataProvider(this.getTrace(), (IWeightedTreeProvider)cga, cga.getId());
        Map<@NonNull Long, FlameChartEntryModel> idsToNames = FlameGraphDataProviderTest.assertAndGetTree(provider, "expectedFgTreeFull", Collections.emptyMap());
        FlameGraphDataProviderTest.assertRowsRequests(provider, idsToNames, "Full", 19L);
        FlameGraphDataProviderTest.assertWrongTooltipQueries(provider, idsToNames);
    }

    @Test
    public void testFlameGraphDataProviderGroupByProcess() throws IOException {
        CallStackAnalysisStub cga = this.getModule();
        FlameGraphDataProvider provider = new FlameGraphDataProvider(this.getTrace(), (IWeightedTreeProvider)cga, cga.getId());
        Map<@NonNull Long, FlameChartEntryModel> idsToNames = FlameGraphDataProviderTest.assertAndGetTree(provider, "expectedFgTreeProcess", (Map<String, Object>)ImmutableMap.of((Object)"group_by", (Object)"Processes/*"));
        FlameGraphDataProviderTest.assertRowsRequests(provider, idsToNames, "Process", 38L);
        FlameGraphDataProviderTest.assertWrongTooltipQueries(provider, idsToNames);
    }

    @Test
    public void testFlameGraphDataProviderGrouped() throws IOException {
        CallStackAnalysisStub cga = this.getModule();
        FlameGraphDataProvider provider = new FlameGraphDataProvider(this.getTrace(), (IWeightedTreeProvider)cga, cga.getId());
        Map<@NonNull Long, FlameChartEntryModel> idsToNames = FlameGraphDataProviderTest.assertAndGetTree(provider, "expectedFgTreeOne", (Map<String, Object>)ImmutableMap.of((Object)"group_by", (Object)AllGroupDescriptor.getInstance().getName()));
        FlameGraphDataProviderTest.assertRowsRequests(provider, idsToNames, "One", 72L);
        FlameGraphDataProviderTest.assertWrongTooltipQueries(provider, idsToNames);
    }

    @Test
    public void testFlameGraphDataProviderSelection() throws IOException {
        CallStackAnalysisStub cga = this.getModule();
        FlameGraphDataProvider provider = new FlameGraphDataProvider(this.getTrace(), (IWeightedTreeProvider)cga, cga.getId());
        Map<@NonNull Long, FlameChartEntryModel> idsToNames = FlameGraphDataProviderTest.assertAndGetTree(provider, "expectedFgTreeSelection", (Map<String, Object>)ImmutableMap.of((Object)"selection_range", (Object)ImmutableList.of((Object)5, (Object)15)));
        FlameGraphDataProviderTest.assertRowsRequests(provider, idsToNames, "Selection", 10L);
        FlameGraphDataProviderTest.assertWrongTooltipQueries(provider, idsToNames);
    }

    private static void assertRowsRequests(FlameGraphDataProvider<?, ?, ?> provider, Map<Long, FlameChartEntryModel> idsToNames, String resultFileSuffix, long maxDuration) throws IOException {
        String filePrefix = "expectedFgRow" + resultFileSuffix;
        ImmutableList.Builder builder = ImmutableList.builder();
        long i = 0L;
        while (i < maxDuration) {
            builder.add((Object)i);
            ++i;
        }
        FlameGraphDataProviderTest.assertRows(provider, idsToNames, (List<Long>)builder.build(), filePrefix, "All");
        FlameGraphDataProviderTest.assertRows(provider, idsToNames, (List<Long>)ImmutableList.of((Object)0L, (Object)(maxDuration - 1L)), filePrefix, "2Times");
        builder = ImmutableList.builder();
        i = maxDuration / 2L;
        while (i < maxDuration) {
            builder.add((Object)i);
            ++i;
        }
        FlameGraphDataProviderTest.assertRows(provider, idsToNames, (List<Long>)builder.build(), filePrefix, "Zoom");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<@NonNull Long, FlameChartEntryModel> assertAndGetTree(FlameGraphDataProvider<?, ?, ?> provider, String filePath, @NonNull Map<@NonNull String, @NonNull Object> additionalParameters) throws IOException {
        HashMap<@NonNull String, @NonNull Object> parameters = new HashMap<String, Object>(TREE_PARAMETERS);
        parameters.putAll(additionalParameters);
        @NonNull TmfModelResponse treeResponse = provider.fetchTree(parameters, null);
        Assert.assertNotNull((Object)treeResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)treeResponse.getStatus());
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        List treeEntries = treeModel.getEntries();
        List<String> expectedStrings = Files.readAllLines(Paths.get(EXPECTED_FILE_PATH + filePath, new String[0]));
        Assert.assertEquals((long)expectedStrings.size(), (long)treeEntries.size());
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(",");
            FlameChartEntryModel parent = null;
            if (!split[5].equals("-")) {
                parent = FlameDataProviderTestUtils.findEntryByNameAndType(treeEntries, split[5], FlameGraphDataProviderTest.getEntryType(split[4]));
                Assert.assertNotNull((String)("parent entry of " + split[0] + ' ' + split[1] + WITH_PARENT + split[5]), (Object)parent);
            }
            FlameChartEntryModel fgEntry = parent == null ? FlameDataProviderTestUtils.findEntryByNameAndType(treeEntries, split[1], FlameGraphDataProviderTest.getEntryType(split[0])) : FlameDataProviderTestUtils.findEntryByNameAndType(FlameDataProviderTestUtils.findEntriesByParent(treeEntries, parent.getId()), split[1], FlameGraphDataProviderTest.getEntryType(split[0]));
            Assert.assertNotNull((String)("Expecting entry " + split[0] + ' ' + split[1] + WITH_PARENT + split[5]), (Object)fgEntry);
            Assert.assertEquals((String)("Start time of entry " + split[0] + ' ' + split[1] + WITH_PARENT + split[5]), (long)Long.parseLong(split[2]), (long)fgEntry.getStartTime());
            Assert.assertEquals((String)("End time of entry " + split[0] + ' ' + split[1] + WITH_PARENT + split[5]), (long)Long.parseLong(split[3]), (long)fgEntry.getEndTime());
            Assert.assertEquals((String)("Parent ID of entry " + split[0] + ' ' + split[1] + WITH_PARENT + split[5]), (long)(parent == null ? -1L : parent.getId()), (long)fgEntry.getParentId());
            ++i;
        }
        HashMap<@NonNull Long, FlameChartEntryModel> map = new HashMap<Long, FlameChartEntryModel>();
        for (FlameChartEntryModel fgModel : treeEntries) {
            map.put(fgModel.getId(), fgModel);
        }
        return map;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertWrongTooltipQueries(FlameGraphDataProvider<?, ?, ?> provider, Map<@NonNull Long, FlameChartEntryModel> idsToNames) {
        @NonNull List<@NonNull Long> wrongEntry = Collections.singletonList(13213L);
        @NonNull List<@NonNull Long> twoEntries = Objects.requireNonNull(List.of(Long.valueOf(1L), Long.valueOf(2L)));
        FlameChartEntryModel entry = FlameDataProviderTestUtils.findEntryByNameAndType(idsToNames.values(), "1", FlameChartEntryModel.EntryType.FUNCTION);
        Assert.assertNotNull((Object)entry);
        @NonNull List<@NonNull Long> correctEntry = Collections.singletonList(entry.getId());
        @NonNull @NonNull @NonNull TmfModelResponse tooltipResponse = provider.fetchTooltip(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)tooltipResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.FAILED, (Object)tooltipResponse.getStatus());
        @NonNull @NonNull Map tooltipModel = (Map)tooltipResponse.getModel();
        if (tooltipModel != null) {
            Assert.assertTrue((boolean)tooltipModel.isEmpty());
        }
        tooltipResponse = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(0L, Long.MAX_VALUE, 2, idsToNames.keySet())), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)tooltipResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.FAILED, (Object)tooltipResponse.getStatus());
        tooltipModel = (Map)tooltipResponse.getModel();
        if (tooltipModel != null) {
            Assert.assertTrue((boolean)tooltipModel.isEmpty());
        }
        tooltipResponse = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(3L, 3L, 1, twoEntries)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)tooltipResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.FAILED, (Object)tooltipResponse.getStatus());
        tooltipModel = (Map)tooltipResponse.getModel();
        if (tooltipModel != null) {
            Assert.assertTrue((boolean)tooltipModel.isEmpty());
        }
        tooltipResponse = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(3L, 3L, 1, wrongEntry)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)tooltipResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)tooltipResponse.getStatus());
        tooltipModel = (Map)tooltipResponse.getModel();
        if (tooltipModel != null) {
            Assert.assertTrue((boolean)tooltipModel.isEmpty());
        }
        tooltipResponse = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(321837218L, 321837218L, 1, correctEntry)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)tooltipResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)tooltipResponse.getStatus());
        tooltipModel = (Map)tooltipResponse.getModel();
        if (tooltipModel != null) {
            Assert.assertTrue((boolean)tooltipModel.isEmpty());
        }
        tooltipResponse = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(0L, 3L, 2, correctEntry)), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)tooltipResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.FAILED, (Object)tooltipResponse.getStatus());
        tooltipModel = (Map)tooltipResponse.getModel();
        if (tooltipModel != null) {
            Assert.assertTrue((boolean)tooltipModel.isEmpty());
        }
    }

    private static FlameChartEntryModel.EntryType getEntryType(String string) {
        return FlameChartEntryModel.EntryType.valueOf((String)string.toUpperCase());
    }

    private static void assertRows(FlameGraphDataProvider<?, ?, ?> provider, Map<Long, FlameChartEntryModel> idsToNames, @NonNull List<Long> requestedTimes, String filePath, String descriptor) throws IOException {
        TmfModelResponse rowResponse = provider.fetchRowModel(FlameGraphDataProviderTest.prepareRowParameters(idsToNames.keySet(), requestedTimes), null);
        Assert.assertNotNull((Object)rowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        TimeGraphModel rowModel = (TimeGraphModel)rowResponse.getModel();
        Assert.assertNotNull((Object)rowModel);
        HashMap<Long, @NonNull ITimeGraphRowModel> rows = new HashMap<Long, ITimeGraphRowModel>();
        for (ITimeGraphRowModel oneRow : rowModel.getRows()) {
            rows.put(oneRow.getEntryID(), oneRow);
        }
        Collection<FlameChartEntryModel> models = idsToNames.values();
        List<String> expectedStrings = Files.readAllLines(Paths.get(EXPECTED_FILE_PATH + filePath + descriptor, new String[0]));
        Assert.assertEquals((long)expectedStrings.size(), (long)rows.size());
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(":");
            FlameChartEntryModel fgEntry = FlameGraphDataProviderTest.findRowEntry(split[0], models);
            Assert.assertNotNull((String)(String.valueOf(descriptor) + ":Entry exists " + split[0]), (Object)fgEntry);
            ITimeGraphRowModel row = (ITimeGraphRowModel)rows.get(fgEntry.getId());
            Assert.assertNotNull((String)(String.valueOf(descriptor) + ": Row entry exists" + split[0]), (Object)row);
            @NonNull String[] rowStates = split[1].split(",");
            FlameGraphDataProviderTest.assertTooltip(provider, fgEntry.getId(), Long.parseLong(rowStates[0]), false, rowStates[3], String.valueOf(Long.parseLong(rowStates[1])) + " ns");
            FlameGraphDataProviderTest.assertTooltip(provider, fgEntry.getId(), Long.parseLong(rowStates[0]), true, rowStates[3], String.valueOf(Long.parseLong(rowStates[1])) + " ns");
            FlameGraphDataProviderTest.assertEqualsStates(split[1], row.getStates(), String.valueOf(descriptor) + ": " + split[0], FlameGraphDataProviderTest.getEntryType(split[0].split(",")[0]));
            ++i;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertTooltip(FlameGraphDataProvider<?, ?, ?> provider, Long entryId, Long requestedTime, boolean isAction, String expectedObject, String expectedDuration) {
        @NonNull @NonNull @NonNull TmfModelResponse tooltipResponse = provider.fetchTooltip(FlameGraphDataProviderTest.prepareTooltipParameters(entryId, requestedTime, isAction), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)tooltipResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)tooltipResponse.getStatus());
        @NonNull @NonNull Map tooltipModel = (Map)tooltipResponse.getModel();
        Assert.assertNotNull((Object)tooltipModel);
        if (expectedObject.equals("null")) {
            Assert.assertTrue((boolean)tooltipModel.isEmpty());
        } else if (List.of(ProcessStatus.RUN.toString(), ProcessStatus.WAIT_CPU.toString()).contains(expectedObject)) {
            if (isAction) {
                Assert.assertNotNull((Object)tooltipModel);
            } else {
                Assert.assertEquals((Object)expectedObject, tooltipModel.get("Object"));
                Assert.assertEquals((Object)expectedDuration, tooltipModel.get("Duration"));
            }
        } else if (isAction) {
            Assert.assertNotNull((Object)tooltipModel);
        } else {
            Assert.assertEquals((Object)expectedObject, tooltipModel.get("Object"));
            Assert.assertEquals((Object)expectedDuration, tooltipModel.get("\tTotal duration"));
        }
    }

    private static FlameChartEntryModel findRowEntry(String entryDetails, Collection<FlameChartEntryModel> models) {
        String[] details = entryDetails.split(",");
        FlameChartEntryModel parentEntry = FlameDataProviderTestUtils.findEntryByNameAndType(models, details[3], FlameGraphDataProviderTest.getEntryType(details[2]));
        if (parentEntry == null) {
            return null;
        }
        return FlameDataProviderTestUtils.findEntryByNameAndType(FlameDataProviderTestUtils.findEntriesByParent(models, parentEntry.getId()), details[1], FlameGraphDataProviderTest.getEntryType(details[0]));
    }

    private static @NonNull Map<@NonNull String, @NonNull Object> prepareRowParameters(@NonNull Set<Long> ids, @NonNull List<Long> requestedTimes) {
        return ImmutableMap.of((Object)"requested_times", requestedTimes, (Object)"requested_items", ids);
    }

    private static @NonNull Map<@NonNull String, @NonNull Object> prepareTooltipParameters(Long entryId, Long requestedTime, boolean isAction) {
        if (isAction) {
            return ImmutableMap.of((Object)"requested_times", Collections.singletonList(requestedTime), (Object)"requested_items", Collections.singletonList(entryId), (Object)"actions", (Object)Collections.EMPTY_LIST);
        }
        return ImmutableMap.of((Object)"requested_times", Collections.singletonList(requestedTime), (Object)"requested_items", Collections.singletonList(entryId));
    }

    private static void assertEqualsStates(String string, @NonNull List<@NonNull ITimeGraphState> states, String descriptor, FlameChartEntryModel.EntryType entryType) {
        String[] stringStates = string.split(",");
        int i = 0;
        while (i < stringStates.length / 4) {
            Assert.assertTrue((String)(String.valueOf(descriptor) + " has state " + i), (states.size() > i ? 1 : 0) != 0);
            ITimeGraphState state = states.get(i);
            Assert.assertEquals((String)(String.valueOf(descriptor) + ": start time at position " + i), (long)Long.parseLong(stringStates[i * 4]), (long)state.getStartTime());
            Assert.assertEquals((String)(String.valueOf(descriptor) + ": duration at position " + i), (long)Long.parseLong(stringStates[i * 4 + 1]), (long)state.getDuration());
            String strValue = stringStates[i * 4 + 2];
            OutputElementStyle style = state.getStyle();
            if (strValue.equals("-")) {
                Assert.assertNull((String)(String.valueOf(descriptor) + ": style at position " + i), (Object)style);
            } else {
                Assert.assertNotNull((String)(String.valueOf(descriptor) + ": existing style at position " + i), (Object)style);
                String parentKey = style.getParentKey();
                if (!entryType.equals((Object)FlameChartEntryModel.EntryType.KERNEL)) {
                    try {
                        Integer.parseInt(parentKey);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Assert.fail((String)("Unexpected style: " + parentKey));
                    }
                }
                String expectedStyle = VALUE_TO_STYLE.computeIfAbsent(strValue, str -> parentKey);
                Assert.assertEquals((String)(String.valueOf(descriptor) + ": style at position " + i), (Object)expectedStyle, (Object)parentKey);
            }
            Assert.assertEquals((String)(String.valueOf(descriptor) + ": no value at position " + i), (long)Integer.MIN_VALUE, (long)state.getValue());
            Assert.assertEquals((String)(String.valueOf(descriptor) + ": label at position " + i), (Object)stringStates[i * 4 + 3], (Object)String.valueOf(state.getLabel()));
            ++i;
        }
        Assert.assertEquals((String)(String.valueOf(descriptor) + " no extra state"), (long)(stringStates.length / 4), (long)states.size());
    }
}

