/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.ipv4;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4.IPv4Endpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4.IPv4Packet;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class IPv4PacketTest {
    private static final Map<String, String> EXPECTED_FIELDS = new LinkedHashMap<String, String>();
    private static final String EXPECTED_TOSTRING;
    private ByteBuffer fPacket;

    static {
        EXPECTED_FIELDS.put("Version", "4");
        EXPECTED_FIELDS.put("Header Length", "24 bytes");
        EXPECTED_FIELDS.put("Differentiated Services Field", "0x26");
        EXPECTED_FIELDS.put("Explicit Congestion Notification", "0x02");
        EXPECTED_FIELDS.put("Total Length", "255 bytes");
        EXPECTED_FIELDS.put("Identification", "0x0ff0");
        EXPECTED_FIELDS.put("Don't Fragment Flag", "false");
        EXPECTED_FIELDS.put("More Fragment Flag", "false");
        EXPECTED_FIELDS.put("Fragment Offset", "7905");
        EXPECTED_FIELDS.put("Time to live", "160");
        EXPECTED_FIELDS.put("Protocol", "Unknown (254)");
        EXPECTED_FIELDS.put("Checksum", "0x3344");
        EXPECTED_FIELDS.put("Source IP Address", "192.168.1.0");
        EXPECTED_FIELDS.put("Destination IP Address", "193.169.2.1");
        EXPECTED_FIELDS.put("Options", "a2 56 a2 56");
        StringBuilder sb = new StringBuilder();
        sb.append("Internet Protocol Version 4, Source: 192.168.1.0, Destination: 193.169.2.1\n");
        sb.append("Version: 4, Identification: 0x0ff0, Header Length: 24 bytes, Total Length: 255 bytes\n");
        sb.append("Differentiated Services Code Point: 0x26; Explicit Congestion Notification: 0x02\n");
        sb.append("Flags: 0x00 (Don't have more fragments), Fragment Offset: 7905\n");
        sb.append("Time to live: 160\n");
        sb.append("Protocol: 254\n");
        sb.append("Header Checksum: 0x3344\n");
        sb.append("Payload: a6");
        EXPECTED_TOSTRING = sb.toString();
    }

    @Before
    public void initialize() {
        this.fPacket = ByteBuffer.allocate(25);
        this.fPacket.order(ByteOrder.BIG_ENDIAN);
        this.fPacket.put((byte)70);
        this.fPacket.put((byte)-102);
        this.fPacket.put((byte)0);
        this.fPacket.put((byte)-1);
        this.fPacket.put((byte)15);
        this.fPacket.put((byte)-16);
        this.fPacket.put((byte)30);
        this.fPacket.put((byte)-31);
        this.fPacket.put((byte)-96);
        this.fPacket.put((byte)-2);
        this.fPacket.put((byte)51);
        this.fPacket.put((byte)68);
        this.fPacket.put((byte)-64);
        this.fPacket.put((byte)-88);
        this.fPacket.put((byte)1);
        this.fPacket.put((byte)0);
        this.fPacket.put((byte)-63);
        this.fPacket.put((byte)-87);
        this.fPacket.put((byte)2);
        this.fPacket.put((byte)1);
        this.fPacket.put((byte)-94);
        this.fPacket.put((byte)86);
        this.fPacket.put((byte)-94);
        this.fPacket.put((byte)86);
        this.fPacket.put((byte)-90);
        this.fPacket.flip();
    }

    @Test
    public void CompleteIPv4PacketTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile file = trace.getTrace();){
            ByteBuffer byteBuffer = this.fPacket;
            if (byteBuffer == null) {
                Assert.fail((String)"CompleteIPv4PacketTest has failed!");
                return;
            }
            IPv4Packet packet = new IPv4Packet(file, null, byteBuffer);
            Assert.assertEquals((Object)PcapProtocol.IPV4, (Object)packet.getProtocol());
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.IPV4));
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
            Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.TCP));
            Assert.assertTrue((boolean)packet.validate());
            IPv4Packet expected = new IPv4Packet(file, null, byteBuffer);
            Assert.assertEquals((long)expected.hashCode(), (long)packet.hashCode());
            Assert.assertEquals((Object)expected, (Object)packet);
            Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
            Assert.assertEquals((Object)EXPECTED_TOSTRING, (Object)packet.toString());
            Assert.assertEquals((Object)"Src: 192.168.1.0 , Dst: 193.169.2.1", (Object)packet.getLocalSummaryString());
            Assert.assertEquals((Object)"192.168.1.0 > 193.169.2.1 Id=4080 Len=1", (Object)packet.getGlobalSummaryString());
            Assert.assertEquals((Object)new IPv4Endpoint(packet, true), (Object)packet.getSourceEndpoint());
            Assert.assertEquals((Object)new IPv4Endpoint(packet, false), (Object)packet.getDestinationEndpoint());
            this.fPacket.position(24);
            byte[] payload = new byte[1];
            this.fPacket.get(payload);
            Assert.assertEquals((Object)ByteBuffer.wrap(payload), (Object)packet.getPayload());
            Assert.assertEquals((Object)InetAddress.getByAddress(Arrays.copyOfRange(this.fPacket.array(), 12, 16)), (Object)packet.getSourceIpAddress());
            Assert.assertEquals((Object)InetAddress.getByAddress(Arrays.copyOfRange(this.fPacket.array(), 16, 20)), (Object)packet.getDestinationIpAddress());
            Assert.assertTrue((boolean)Arrays.equals(packet.getOptions(), Arrays.copyOfRange(this.fPacket.array(), 20, 24)));
            Assert.assertEquals((long)4L, (long)packet.getVersion());
            Assert.assertEquals((long)24L, (long)packet.getHeaderLength());
            Assert.assertEquals((long)38L, (long)packet.getDSCP());
            Assert.assertEquals((long)2L, (long)packet.getExplicitCongestionNotification());
            Assert.assertEquals((long)255L, (long)packet.getTotalLength());
            Assert.assertEquals((long)4080L, (long)packet.getIdentification());
            Assert.assertFalse((boolean)packet.getReservedFlag());
            Assert.assertFalse((boolean)packet.getDontFragmentFlag());
            Assert.assertFalse((boolean)packet.getHasMoreFragment());
            Assert.assertEquals((long)7905L, (long)packet.getFragmentOffset());
            Assert.assertEquals((long)160L, (long)packet.getTimeToLive());
            Assert.assertEquals((long)254L, (long)packet.getIpDatagramProtocol());
            Assert.assertEquals((long)13124L, (long)packet.getHeaderChecksum());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

