/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.core.tests.stubs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartNumericalDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartStringDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractDoubleResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractLongResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.IStringResolver;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;

@NonNullByDefault
public class StubChartProvider
implements IDataChartProvider<StubObject> {
    public static final String NAME = "Long Chart Provider";
    public static final String STRING_DESCRIPTOR = "String";
    public static final String INTEGER_DESCRIPTOR = "Integer";
    public static final String LONG_DESCRIPTOR = "Long";
    public static final String DOUBLE_DESCRIPTOR = "Double";
    private final List<StubObject> fSource = new ArrayList<StubObject>();
    private @Nullable List<IDataChartDescriptor<StubObject, ?>> fDescriptors = null;

    public String getName() {
        return NAME;
    }

    public Stream<StubObject> getSource() {
        return (Stream)NonNullUtils.checkNotNull(this.fSource.stream());
    }

    public void addData(StubObject obj) {
        this.fSource.add(obj);
    }

    public Collection<IDataChartDescriptor<StubObject, ?>> getDataDescriptors() {
        List<IDataChartDescriptor<StubObject, ?>> list = this.fDescriptors;
        if (list == null) {
            list = new ArrayList();
            list.add((IDataChartDescriptor<StubObject, ?>)new DataChartStringDescriptor(STRING_DESCRIPTOR, (IStringResolver)new IStringResolver<StubObject>(){

                public Function<StubObject, @Nullable String> getMapper() {
                    return o -> o.getString();
                }
            }));
            list.add((IDataChartDescriptor<StubObject, ?>)new DataChartNumericalDescriptor(INTEGER_DESCRIPTOR, (INumericalResolver)new INumericalResolver<StubObject, Integer>(){

                public Function<StubObject, @Nullable Integer> getMapper() {
                    return o -> o.getInt();
                }

                public Comparator<Integer> getComparator() {
                    return (Comparator)NonNullUtils.checkNotNull(Comparator.naturalOrder());
                }

                public Integer getMinValue() {
                    return Integer.MIN_VALUE;
                }

                public Integer getMaxValue() {
                    return Integer.MAX_VALUE;
                }

                public Integer getZeroValue() {
                    return 0;
                }
            }));
            list.add((IDataChartDescriptor<StubObject, ?>)new DataChartNumericalDescriptor(LONG_DESCRIPTOR, (INumericalResolver)new AbstractLongResolver<StubObject>(){

                public Function<StubObject, @Nullable Long> getMapper() {
                    return o -> o.getLong();
                }
            }));
            list.add((IDataChartDescriptor<StubObject, ?>)new DataChartNumericalDescriptor(DOUBLE_DESCRIPTOR, (INumericalResolver)new AbstractDoubleResolver<StubObject>(){

                public Function<StubObject, @Nullable Double> getMapper() {
                    return o -> o.getDbl();
                }
            }));
            this.fDescriptors = list;
        }
        return list;
    }

    public IDataChartDescriptor<StubObject, ?> getDataDescriptor(String name) {
        return this.getDataDescriptors().stream().filter(d -> d.getName().equals(name)).findFirst().get();
    }
}

