/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfStyledProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOnDemandAnalysesElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;

@NonNullByDefault
public abstract class TmfOnDemandAnalysisElement
extends TmfProjectModelElement
implements ITmfStyledProjectModelElement {
    private static final ExecutorService EXECUTOR = (ExecutorService)NonNullUtils.checkNotNull((Object)Executors.newFixedThreadPool(1));
    private static final StyledString.Styler STRIKED_OUT_STYLER = new StyledString.Styler(){

        public void applyStyles(@Nullable TextStyle textStyle) {
            if (textStyle != null) {
                textStyle.strikeout = true;
            }
        }
    };
    private final IOnDemandAnalysis fAnalysis;
    private volatile boolean fKnowIfCanRun = false;
    private volatile boolean fCanRun = false;

    protected TmfOnDemandAnalysisElement(String analysisName, IResource resource, TmfOnDemandAnalysesElement parent, IOnDemandAnalysis analysis) {
        super(analysisName, resource, parent);
        this.fAnalysis = analysis;
    }

    @Override
    public TmfOnDemandAnalysesElement getParent() {
        return (TmfOnDemandAnalysesElement)NonNullUtils.checkNotNull((Object)((TmfOnDemandAnalysesElement)super.getParent()));
    }

    @Override
    public abstract Image getIcon();

    @Override
    protected synchronized void refreshChildren() {
        if (!this.fKnowIfCanRun) {
            this.fKnowIfCanRun = true;
            EXECUTOR.execute(new AnalysisChecker(this));
        }
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable StyledString.Styler getStyler() {
        if (!this.fCanRun) {
            return STRIKED_OUT_STYLER;
        }
        return null;
    }

    public IOnDemandAnalysis getAnalysis() {
        return this.fAnalysis;
    }

    public boolean canRun() {
        return this.fCanRun;
    }

    public String getHelpMessage() {
        ITmfTrace trace = this.getParent().getParent().getTrace();
        if (trace != null) {
            return this.getAnalysis().getHelpText(trace);
        }
        return this.getAnalysis().getHelpText();
    }

    private static class AnalysisChecker
    implements Runnable {
        private final TmfOnDemandAnalysisElement fElem;

        public AnalysisChecker(TmfOnDemandAnalysisElement elem) {
            this.fElem = elem;
        }

        @Override
        public void run() {
            ITmfTrace trace = this.fElem.getParent().getParent().getTrace();
            if (trace != null) {
                this.fElem.fCanRun = this.fElem.getAnalysis().canExecute(trace);
                this.fElem.refresh();
            }
        }
    }
}

