/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.knn.KnnSearchStrategy;

public abstract class AbstractKnnCollector
implements KnnCollector {
    protected long visitedCount;
    private final long visitLimit;
    private final KnnSearchStrategy searchStrategy;
    private final int k;

    protected AbstractKnnCollector(int k, long visitLimit, KnnSearchStrategy searchStrategy) {
        this.k = k;
        this.searchStrategy = searchStrategy;
        this.visitLimit = visitLimit;
    }

    protected AbstractKnnCollector(int k, long visitLimit) {
        this(k, visitLimit, null);
    }

    @Override
    public final boolean earlyTerminated() {
        return this.visitedCount >= this.visitLimit;
    }

    @Override
    public final void incVisitedCount(int count) {
        assert (count > 0);
        this.visitedCount += (long)count;
    }

    @Override
    public final long visitedCount() {
        return this.visitedCount;
    }

    @Override
    public final long visitLimit() {
        return this.visitLimit;
    }

    @Override
    public final int k() {
        return this.k;
    }

    @Override
    public abstract boolean collect(int var1, float var2);

    public abstract int numCollected();

    @Override
    public abstract float minCompetitiveSimilarity();

    @Override
    public abstract TopDocs topDocs();

    @Override
    public KnnSearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }
}

