/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.trace;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.btf.core.event.BtfEvent;
import org.eclipse.tracecompass.btf.core.trace.BtfColumnNames;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;

@NonNullByDefault
public final class BtfEventAspects {
    private static final Iterable<ITmfEventAspect<?>> BTF_ASPECTS = ImmutableList.of((Object)TmfBaseAspects.getTimestampAspect(), (Object)new BtfSourceAspect(), (Object)new TmfContentFieldAspect(BtfColumnNames.SOURCE_INSTANCE.toString(), new String[]{BtfColumnNames.SOURCE_INSTANCE.toString()}), (Object)TmfBaseAspects.getEventTypeAspect(), (Object)new BtfTargetAspect(), (Object)new TmfContentFieldAspect(BtfColumnNames.TARGET_INSTANCE.toString(), new String[]{BtfColumnNames.TARGET_INSTANCE.toString()}), (Object)new TmfContentFieldAspect(BtfColumnNames.EVENT.toString(), new String[]{BtfColumnNames.EVENT.toString()}), (Object)new TmfContentFieldAspect(BtfColumnNames.NOTES.toString(), new String[]{BtfColumnNames.NOTES.toString()}));

    private BtfEventAspects() {
    }

    public static Iterable<ITmfEventAspect<?>> getAspects() {
        return BTF_ASPECTS;
    }

    private static class BtfSourceAspect
    implements ITmfEventAspect<String> {
        private BtfSourceAspect() {
        }

        public String getName() {
            return BtfColumnNames.SOURCE.toString();
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable String resolve(ITmfEvent event) {
            if (!(event instanceof BtfEvent)) {
                return "";
            }
            String ret = ((BtfEvent)event).getSource();
            return ret == null ? "" : ret;
        }
    }

    private static class BtfTargetAspect
    implements ITmfEventAspect<String> {
        private BtfTargetAspect() {
        }

        public String getName() {
            return BtfColumnNames.TARGET.toString();
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable String resolve(ITmfEvent event) {
            if (!(event instanceof BtfEvent)) {
                return "";
            }
            String ret = ((BtfEvent)event).getTarget();
            return ret == null ? "" : ret;
        }
    }
}

