/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart.barchart;

import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IXYSeries;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;

public class TmfHistogramTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener,
MouseMoveListener,
PaintListener {
    private int fHighlightX;
    private int fHighlightY;
    private boolean fIsHighlight;

    public TmfHistogramTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L) {
            IAxis xAxis = this.getXAxis();
            IAxis yAxis = this.getYAxis();
            double xCoordinate = xAxis.getDataCoordinate(e.x);
            List<IXYSeries> series = this.getSeries();
            if (xCoordinate < 0.0 || series.isEmpty()) {
                return;
            }
            double y = 0.0;
            double rangeStart = 0.0;
            double rangeEnd = 0.0;
            IXYSeries firstSeries = series.get(0);
            double[] xS = firstSeries.getXSeries();
            double[] yS = firstSeries.getYSeries();
            if (xS == null || yS == null) {
                return;
            }
            int i = 0;
            while (i < xS.length - 1) {
                int pixel = xAxis.getPixelCoordinate(xS[i]);
                if (pixel <= e.x) {
                    rangeStart = xS[i];
                    rangeEnd = (long)xS[i + 1];
                    y = xCoordinate >= rangeStart ? yS[i + 1] : yS[i];
                }
                ++i;
            }
            ITmfChartTimeProvider viewer = this.getChartViewer();
            StringBuilder builder = new StringBuilder();
            builder.append("Range=[");
            builder.append(TmfTimestamp.fromNanos((long)((long)rangeStart + viewer.getTimeOffset())).toString());
            builder.append(',');
            builder.append(TmfTimestamp.fromNanos((long)((long)rangeEnd + viewer.getTimeOffset())).toString());
            builder.append("]\n");
            builder.append("y=");
            builder.append((long)y);
            this.setToolTipText(builder.toString());
            this.fHighlightX = e.x;
            this.fHighlightY = yAxis.getPixelCoordinate(y);
            this.fIsHighlight = true;
            this.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        this.fIsHighlight = false;
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        if (this.fIsHighlight) {
            e.gc.setBackground(Display.getDefault().getSystemColor(3));
            e.gc.setAlpha(128);
            e.gc.fillOval(this.fHighlightX - 5, this.fHighlightY - 5, 10, 10);
        }
    }
}

