/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.linecharts;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.linecharts.ICompressionSupport;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class StepChart
extends ScrollableChart
implements ICompressionSupport {
    public StepChart() {
    }

    public StepChart(Composite parent, int style) {
        super(parent, style);
    }

    public void addSeriesData(List<ILineSeriesData> lineSeriesDataList) {
        this.addSeriesData(lineSeriesDataList, Integer.MAX_VALUE);
    }

    public void addSeriesData(List<ILineSeriesData> lineSeriesDataList, int compressToLength) {
        if (lineSeriesDataList != null && lineSeriesDataList.size() > 0) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (ILineSeriesData lineSeriesData : lineSeriesDataList) {
                try {
                    ISeriesData seriesData = lineSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData, compressToLength);
                    ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                    lineSeriesSettings.getSeriesSettingsHighlight();
                    lineSeriesSettings.setEnableStep(true);
                    ILineSeries lineSeries = (ILineSeries)this.createSeries(optimizedSeriesData, lineSeriesSettings);
                    baseChart.applySeriesSettings((ISeries<?>)lineSeries, lineSeriesSettings);
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }
}

