/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;

public class ArchiveFileManipulations {
    public static boolean isTarFile(String fileName) {
        if (fileName.isEmpty()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                TarFile tarFile = new TarFile(fileName);
                if (tarFile != null) {
                    tarFile.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | TarException ioException) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(String fileName) {
        if (fileName.isEmpty()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                ZipFile zipFile = new ZipFile(fileName);
                if (zipFile == null) return true;
                zipFile.close();
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException ioException) {
            return false;
        }
    }

    public static void closeStructureProvider(ILeveledImportStructureProvider structureProvider, Shell shell) {
        if (structureProvider instanceof ZipLeveledStructureProvider) {
            ZipLeveledStructureProvider zsp = (ZipLeveledStructureProvider)structureProvider;
            ArchiveFileManipulations.closeZipFile(zsp.getZipFile(), shell);
        }
        if (structureProvider instanceof TarLeveledStructureProvider) {
            TarLeveledStructureProvider tsp = (TarLeveledStructureProvider)structureProvider;
            ArchiveFileManipulations.closeTarFile(tsp.getTarFile(), shell);
        }
    }

    public static boolean closeZipFile(ZipFile file, Shell shell) {
        try {
            file.close();
        }
        catch (IOException e) {
            ArchiveFileManipulations.displayErrorDialog(NLS.bind((String)DataTransferMessages.ZipImport_couldNotClose, (Object)file.getName()), shell);
            return false;
        }
        return true;
    }

    public static boolean closeTarFile(TarFile file, Shell shell) {
        try {
            file.close();
        }
        catch (IOException e) {
            ArchiveFileManipulations.displayErrorDialog(NLS.bind((String)DataTransferMessages.ZipImport_couldNotClose, (Object)file.getName()), shell);
            return false;
        }
        return true;
    }

    protected static void displayErrorDialog(String message, Shell shell) {
        MessageDialog.open((int)1, (Shell)shell, (String)ArchiveFileManipulations.getErrorDialogTitle(), (String)message, (int)0x10000000);
    }

    protected static String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }
}

