/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GoToAddressComposite {
    private Text fExpression;
    private Button fOKButton;
    private Button fCancelButton;
    private Composite fComposite;
    private Combo fGoToCombo;
    private Button fHexButton;

    public Control createControl(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fComposite, DebugUIPlugin.getUniqueIdentifier() + ".GoToAddressComposite_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fGoToCombo = new Combo(this.fComposite, 8);
        this.fGoToCombo.add(DebugUIMessages.GoToAddressComposite_0);
        this.fGoToCombo.add(DebugUIMessages.GoToAddressComposite_4);
        this.fGoToCombo.add(DebugUIMessages.GoToAddressComposite_5);
        this.fGoToCombo.select(0);
        this.fExpression = new Text(this.fComposite, 2052);
        this.fExpression.setLayoutData((Object)new GridData(768));
        this.fHexButton = new Button(this.fComposite, 32);
        this.fHexButton.setText(DebugUIMessages.GoToAddressComposite_6);
        this.fHexButton.setSelection(true);
        this.fOKButton = new Button(this.fComposite, 0);
        this.fOKButton.setText(DebugUIMessages.GoToAddressComposite_1);
        this.fCancelButton = new Button(this.fComposite, 0);
        this.fCancelButton.setText(DebugUIMessages.GoToAddressComposite_2);
        return this.fComposite;
    }

    public int getHeight() {
        int height = this.fComposite.computeSize((int)-1, (int)-1).y;
        return height;
    }

    public Button getButton(int id) {
        if (id == 0) {
            return this.fOKButton;
        }
        if (id == 1) {
            return this.fCancelButton;
        }
        return null;
    }

    public String getExpressionText() {
        return this.fExpression.getText();
    }

    public Text getExpressionWidget() {
        return this.fExpression;
    }

    public boolean isGoToAddress() {
        return this.fGoToCombo.getSelectionIndex() == 0;
    }

    public boolean isOffset() {
        return this.fGoToCombo.getSelectionIndex() == 1;
    }

    public boolean isJump() {
        return this.fGoToCombo.getSelectionIndex() == 2;
    }

    public boolean isHex() {
        return this.fHexButton.getSelection();
    }

    public BigInteger getGoToAddress(BigInteger baseAddress, BigInteger selectedAddress) throws NumberFormatException {
        boolean add = true;
        String expression = this.getExpressionText();
        boolean hex = this.isHex();
        int radix = hex ? 16 : 10;
        expression = expression.trim();
        if (this.isGoToAddress()) {
            if ((expression = expression.toUpperCase()).startsWith("0X")) {
                expression = expression.substring(2);
                radix = 16;
            }
            return new BigInteger(expression, radix);
        }
        if (expression.startsWith("+")) {
            expression = expression.substring(1);
        } else if (expression.startsWith("-")) {
            expression = expression.substring(1);
            add = false;
        }
        expression = expression.toUpperCase();
        if (expression.startsWith("0X")) {
            expression = expression.substring(2);
            radix = 16;
        }
        BigInteger gotoAddress = new BigInteger(expression, radix);
        BigInteger address = baseAddress;
        if (this.isJump()) {
            address = selectedAddress;
        }
        if (address == null) {
            throw new NumberFormatException(DebugUIMessages.GoToAddressComposite_7);
        }
        gotoAddress = add ? address.add(gotoAddress) : address.subtract(gotoAddress);
        return gotoAddress;
    }
}

