/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.signal;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class TmfWindowRangeUpdatedSignal
extends TmfSignal {
    private final TmfTimeRange fCurrentRange;
    private final @Nullable ITmfTrace fTrace;

    public TmfWindowRangeUpdatedSignal(Object source, TmfTimeRange range) {
        this(source, range, TmfTraceManager.getInstance().getActiveTrace());
    }

    public TmfWindowRangeUpdatedSignal(Object source, TmfTimeRange range, ITmfTrace trace) {
        super(source);
        this.fCurrentRange = range;
        this.fTrace = trace;
    }

    public TmfTimeRange getCurrentRange() {
        return this.fCurrentRange;
    }

    public @Nullable ITmfTrace getTrace() {
        return this.fTrace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" [source=");
        if (this.getSource() != null) {
            sb.append(this.getSource().toString());
        } else {
            sb.append("null");
        }
        sb.append(", range=");
        if (this.fCurrentRange != null) {
            sb.append(this.fCurrentRange.toString());
        } else {
            sb.append("null");
        }
        sb.append(']');
        return sb.toString();
    }
}

